/*
 * Decompiled with CFR 0.152.
 */
package com.structurizr.validation;

import com.structurizr.Workspace;
import com.structurizr.model.Model;
import com.structurizr.model.SoftwareSystem;
import com.structurizr.validation.WorkspaceScopeValidationException;
import com.structurizr.validation.WorkspaceScopeValidator;

public class LandscapeWorkspaceScopeValidator
implements WorkspaceScopeValidator {
    @Override
    public void validate(Workspace workspace) throws WorkspaceScopeValidationException {
        Model model = workspace.getModel();
        for (SoftwareSystem softwareSystem : model.getSoftwareSystems()) {
            if (softwareSystem.getContainers().size() > 0) {
                throw new WorkspaceScopeValidationException("Workspace is landscape scoped, but the software system named " + softwareSystem.getName() + " has containers.");
            }
            if (softwareSystem.getDocumentation().isEmpty()) continue;
            throw new WorkspaceScopeValidationException("Workspace is landscape scoped, but the software system named " + softwareSystem.getName() + " has documentation.");
        }
    }
}

