/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.RIConstants;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.io.FastStringWriter;
import com.sun.faces.util.DebugUtil;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.LRUMap;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.ReflectionUtils;
import com.sun.faces.util.RequestStateManager;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.event.AbortProcessingException;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.validation.SchemaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private static boolean unitTestModeEnabled = false;
    private static final String patternCacheKey = "com.sun.faces.patternCache";

    private Util() {
        throw new IllegalStateException();
    }

    private static Map<String, Pattern> getPatternCache(Map<String, Object> appMap) {
        LRUMap result = (LRUMap)appMap.get(patternCacheKey);
        if (null == result) {
            result = new LRUMap(15);
            appMap.put(patternCacheKey, result);
        }
        return result;
    }

    private static Map<String, Pattern> getPatternCache(ServletContext sc) {
        LRUMap result = (LRUMap)sc.getAttribute(patternCacheKey);
        if (null == result) {
            result = new LRUMap(15);
            sc.setAttribute(patternCacheKey, result);
        }
        return result;
    }

    public static boolean isPortletRequest(FacesContext context) {
        return context.getExternalContext().getRequestMap().get("javax.portlet.faces.phase") != null;
    }

    public static Object getListenerInstance(ValueExpression type, ValueExpression binding) {
        FacesContext faces = FacesContext.getCurrentInstance();
        Object instance = null;
        if (faces == null) {
            return null;
        }
        if (binding != null) {
            instance = binding.getValue(faces.getELContext());
        }
        if (instance == null && type != null) {
            try {
                instance = ReflectionUtils.newInstance((String)type.getValue(faces.getELContext()));
            }
            catch (Exception e) {
                throw new AbortProcessingException(e.getMessage(), (Throwable)e);
            }
            if (binding != null) {
                binding.setValue(faces.getELContext(), instance);
            }
        }
        return instance;
    }

    public static void setUnitTestModeEnabled(boolean enabled) {
        unitTestModeEnabled = enabled;
    }

    public static boolean isUnitTestModeEnabled() {
        return unitTestModeEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransformerFactory createTransformerFactory() {
        TransformerFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = TransformerFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SAXParserFactory createSAXParserFactory() {
        SAXParserFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = SAXParserFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = DocumentBuilderFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SchemaFactory createSchemaFactory(String uri) {
        SchemaFactory factory;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(Util.class.getClassLoader());
            factory = SchemaFactory.newInstance(uri);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return factory;
    }

    public static Class loadClass(String name, Object fallbackClass) throws ClassNotFoundException {
        ClassLoader loader = Util.getCurrentLoader(fallbackClass);
        return Class.forName(name, true, loader);
    }

    public static ClassLoader getCurrentLoader(Object fallbackClass) {
        ClassLoader loader = Util.getContextClassLoader();
        if (loader == null) {
            loader = fallbackClass.getClass().getClassLoader();
        }
        return loader;
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static void notNull(String varname, Object var) {
        if (var == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", varname));
        }
    }

    public static Locale getLocaleFromContextOrSystem(FacesContext context) {
        UIViewRoot root;
        Locale temp;
        Locale result = temp = Locale.getDefault();
        if (null != context && null != (root = context.getViewRoot()) && null == (result = root.getLocale())) {
            result = temp;
        }
        return result;
    }

    public static Converter getConverterForClass(Class converterClass, FacesContext context) {
        if (converterClass == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterClass);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Converter getConverterForIdentifer(String converterId, FacesContext context) {
        if (converterId == null) {
            return null;
        }
        try {
            Application application = context.getApplication();
            return application.createConverter(converterId);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static StateManager getStateManager(FacesContext context) throws FacesException {
        return context.getApplication().getStateManager();
    }

    public static Class getTypeFromString(String type) throws ClassNotFoundException {
        Class result;
        if (type.equals("byte")) {
            result = Byte.TYPE;
        } else if (type.equals("short")) {
            result = Short.TYPE;
        } else if (type.equals("int")) {
            result = Integer.TYPE;
        } else if (type.equals("long")) {
            result = Long.TYPE;
        } else if (type.equals("float")) {
            result = Float.TYPE;
        } else if (type.equals("double")) {
            result = Double.TYPE;
        } else if (type.equals("boolean")) {
            result = Boolean.TYPE;
        } else if (type.equals("char")) {
            result = Character.TYPE;
        } else if (type.equals("void")) {
            result = Void.TYPE;
        } else {
            if (type.indexOf(46) == -1) {
                type = "java.lang." + type;
            }
            result = Util.loadClass(type, Void.TYPE);
        }
        return result;
    }

    public static ViewHandler getViewHandler(FacesContext context) throws FacesException {
        Application application = context.getApplication();
        assert (application != null);
        ViewHandler viewHandler = application.getViewHandler();
        assert (viewHandler != null);
        return viewHandler;
    }

    public static boolean componentIsDisabled(UIComponent component) {
        return Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled")));
    }

    public static boolean componentIsDisabledOrReadonly(UIComponent component) {
        return Boolean.valueOf(String.valueOf(component.getAttributes().get("disabled"))) != false || Boolean.valueOf(String.valueOf(component.getAttributes().get("readonly"))) != false;
    }

    public static Locale getLocaleFromString(String localeStr) throws IllegalArgumentException {
        if (null == localeStr || localeStr.length() < 2) {
            throw new IllegalArgumentException("Illegal locale String: " + localeStr);
        }
        Locale result = null;
        String lang = null;
        String country = null;
        String variant = null;
        char[] seps = new char[]{'-', '_'};
        int inputLength = localeStr.length();
        int i = 0;
        int j = 0;
        if (inputLength >= 2 && (i = Util.indexOfSet(localeStr, seps, 0)) == -1) {
            if (2 != localeStr.length()) {
                throw new IllegalArgumentException("Illegal locale String: " + localeStr);
            }
            lang = localeStr.toLowerCase();
        }
        if (i != -1) {
            lang = localeStr.substring(0, i);
            if (inputLength >= 5 && (j = Util.indexOfSet(localeStr, seps, i + 1)) == -1) {
                if (inputLength != 5) {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
                country = localeStr.substring(i + 1);
            }
            if (j != -1) {
                country = localeStr.substring(i + 1, j);
                if (inputLength >= 8) {
                    variant = localeStr.substring(j + 1);
                } else {
                    throw new IllegalArgumentException("Illegal locale String: " + localeStr);
                }
            }
        }
        if (variant != null && country != null && lang != null) {
            result = new Locale(lang, country, variant);
        } else if (lang != null && country != null) {
            result = new Locale(lang, country);
        } else if (lang != null) {
            result = new Locale(lang, "");
        }
        return result;
    }

    public static int indexOfSet(String str, char[] set, int fromIndex) {
        int result = -1;
        int len = str.length();
        for (int i = fromIndex; i < len; ++i) {
            int innerLen = set.length;
            for (int j = 0; j < innerLen; ++j) {
                if (str.charAt(i) != set[j]) continue;
                result = i;
                break;
            }
            if (-1 != result) break;
        }
        return result;
    }

    public static String getStackTraceString(Throwable e) {
        if (null == e) {
            return "";
        }
        StackTraceElement[] stacks = e.getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (StackTraceElement stack : stacks) {
            sb.append(stack.toString()).append('\n');
        }
        return sb.toString();
    }

    public static String getContentTypeFromResponse(Object response) {
        String result = null;
        if (null != response) {
            try {
                Object obj;
                Method method = ReflectionUtils.lookupMethod(response.getClass(), "getContentType", RIConstants.EMPTY_CLASS_ARGS);
                if (null != method && null != (obj = method.invoke(response, RIConstants.EMPTY_METH_ARGS))) {
                    result = obj.toString();
                }
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }
        return result;
    }

    public static FeatureDescriptor getFeatureDescriptor(String name, String displayName, String desc, boolean expert, boolean hidden, boolean preferred, Object type, Boolean designTime) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setName(name);
        fd.setDisplayName(displayName);
        fd.setShortDescription(desc);
        fd.setExpert(expert);
        fd.setHidden(hidden);
        fd.setPreferred(preferred);
        fd.setValue("type", type);
        fd.setValue("resolvableAtDesignTime", designTime);
        return fd;
    }

    public static synchronized String[] split(Map<String, Object> appMap, String toSplit, String regex) {
        Map<String, Pattern> patternCache = Util.getPatternCache(appMap);
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern.split(toSplit, 0);
    }

    public static synchronized String[] split(ServletContext sc, String toSplit, String regex) {
        Map<String, Pattern> patternCache = Util.getPatternCache(sc);
        Pattern pattern = patternCache.get(regex);
        if (pattern == null) {
            pattern = Pattern.compile(regex);
            patternCache.put(regex, pattern);
        }
        return pattern.split(toSplit, 0);
    }

    public static String getFacesMapping(FacesContext context) {
        String pathInfo;
        String servletPath;
        if (context == null) {
            String message = MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "context");
            throw new NullPointerException(message);
        }
        ExternalContext extContext = context.getExternalContext();
        String mapping = (String)RequestStateManager.get(context, "com.sun.faces.INVOCATION_PATH");
        if (mapping == null && (mapping = Util.getMappingForRequest(servletPath = extContext.getRequestServletPath(), pathInfo = extContext.getRequestPathInfo())) == null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "jsf.faces_servlet_mapping_cannot_be_determined_error", new Object[]{servletPath});
        }
        if (mapping != null) {
            RequestStateManager.set(context, "com.sun.faces.INVOCATION_PATH", mapping);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "URL pattern of the FacesServlet executing the current request " + mapping);
        }
        return mapping;
    }

    private static String getMappingForRequest(String servletPath, String pathInfo) {
        if (servletPath == null) {
            return null;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "servletPath " + servletPath);
            LOGGER.log(Level.FINE, "pathInfo " + pathInfo);
        }
        if (servletPath.length() == 0) {
            return "/*";
        }
        if (pathInfo != null) {
            return servletPath;
        }
        if (servletPath.indexOf(46) < 0) {
            return servletPath;
        }
        return servletPath.substring(servletPath.lastIndexOf(46));
    }

    public static boolean isPrefixMapped(String mapping) {
        return mapping.charAt(0) == '/';
    }

    public static boolean isSpecialAttributeName(String name) {
        boolean isSpecialAttributeName = name.equals("action") || name.equals("actionListener") || name.equals("validator") || name.equals("valueChangeListener");
        return isSpecialAttributeName;
    }

    public static boolean isViewPopulated(FacesContext ctx, UIViewRoot viewToRender) {
        return ctx.getAttributes().containsKey(viewToRender);
    }

    public static void setViewPopulated(FacesContext ctx, UIViewRoot viewToRender) {
        ctx.getAttributes().put(viewToRender, Boolean.TRUE);
    }

    public static void checkIdUniqueness(FacesContext context, UIComponent component, Set<String> componentIds) {
        boolean uniquenessCheckDisabled = false;
        if (context.isProjectStage(ProjectStage.Production)) {
            WebConfiguration config = WebConfiguration.getInstance(context.getExternalContext());
            uniquenessCheckDisabled = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.DisableIdUniquenessCheck);
        }
        if (!uniquenessCheckDisabled) {
            Iterator kids = component.getFacetsAndChildren();
            while (kids.hasNext()) {
                UIComponent kid = (UIComponent)kids.next();
                String id = kid.getClientId(context);
                if (componentIds.add(id)) {
                    Util.checkIdUniqueness(context, kid, componentIds);
                    continue;
                }
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "jsf.duplicate_component_id_error", id);
                    FastStringWriter writer = new FastStringWriter(128);
                    DebugUtil.simplePrintTree((UIComponent)context.getViewRoot(), id, writer);
                    LOGGER.severe(writer.toString());
                }
                String message = MessageUtils.getExceptionMessageString("com.sun.faces.DUPLICATE_COMPONENT_ID_ERROR", id);
                throw new IllegalStateException(message);
            }
        }
    }
}

