/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ClientResourceInfo;
import com.sun.faces.application.resource.ContractInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.ZipDirectoryEntryScanner;
import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;

public class ClasspathResourceHelper
extends ResourceHelper {
    private static final String BASE_RESOURCE_PATH = "META-INF/resources";
    private boolean cacheTimestamp;
    private volatile ZipDirectoryEntryScanner libraryScanner;
    private boolean enableMissingResourceLibraryDetection;

    public ClasspathResourceHelper() {
        WebConfiguration webConfiguration = WebConfiguration.getInstance();
        this.cacheTimestamp = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.CacheResourceModificationTimestamp);
        this.enableMissingResourceLibraryDetection = webConfiguration.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.EnableMissingResourceLibraryDetection);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ClasspathResourceHelper classpathResourceHelper = (ClasspathResourceHelper)object;
        if (this.cacheTimestamp != classpathResourceHelper.cacheTimestamp) {
            return false;
        }
        return this.enableMissingResourceLibraryDetection == classpathResourceHelper.enableMissingResourceLibraryDetection;
    }

    public int hashCode() {
        int n = 5;
        n = 67 * n + (this.cacheTimestamp ? 1 : 0);
        n = 67 * n + (this.enableMissingResourceLibraryDetection ? 1 : 0);
        return n;
    }

    public String getBaseResourcePath() {
        return BASE_RESOURCE_PATH;
    }

    public String getBaseContractsPath() {
        return WebConfiguration.META_INF_CONTRACTS_DIR;
    }

    protected InputStream getNonCompressedInputStream(ResourceInfo resourceInfo, FacesContext facesContext) throws IOException {
        InputStream inputStream = null;
        if (facesContext.isProjectStage(ProjectStage.Development)) {
            String string;
            ClassLoader classLoader = Util.getCurrentLoader(this.getClass());
            if (classLoader.getResource(string = resourceInfo.getPath()) != null) {
                inputStream = classLoader.getResource(string).openStream();
            }
            if (inputStream == null && this.getClass().getClassLoader().getResource(string) != null) {
                inputStream = this.getClass().getClassLoader().getResource(string).openStream();
            }
        } else {
            String string;
            ClassLoader classLoader = Util.getCurrentLoader(this.getClass());
            inputStream = classLoader.getResourceAsStream(string = resourceInfo.getPath());
            if (inputStream == null) {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(string);
            }
        }
        return inputStream;
    }

    public URL getURL(ResourceInfo resourceInfo, FacesContext facesContext) {
        ClassLoader classLoader = Util.getCurrentLoader(this.getClass());
        URL uRL = classLoader.getResource(resourceInfo.getPath());
        if (uRL == null) {
            uRL = this.getClass().getClassLoader().getResource(resourceInfo.getPath());
        }
        return uRL;
    }

    public LibraryInfo findLibrary(String string, String string2, String string3, FacesContext facesContext) {
        ClassLoader classLoader = Util.getCurrentLoader(this);
        String string4 = string2 == null ? this.getBasePath(string3) + '/' + string + '/' : this.getBasePath(string3) + '/' + string2 + '/' + string + '/';
        URL uRL = classLoader.getResource(string4);
        if (uRL == null && (uRL = this.getClass().getClassLoader().getResource(string4)) == null) {
            return null;
        }
        return new LibraryInfo(string, null, string2, string3, this);
    }

    public LibraryInfo findLibraryWithZipDirectoryEntryScan(String string, String string2, String string3, FacesContext facesContext, boolean bl) {
        ClassLoader classLoader = Util.getCurrentLoader(this);
        String string4 = string2 == null ? this.getBasePath(string3) + '/' + string + '/' : this.getBasePath(string3) + '/' + string2 + '/' + string + '/';
        URL uRL = classLoader.getResource(string4);
        if (uRL == null && (uRL = this.getClass().getClassLoader().getResource(string4)) == null) {
            if (null != string2 && string.equals("javax.faces")) {
                return null;
            }
            if (this.enableMissingResourceLibraryDetection || bl) {
                if (null == this.libraryScanner) {
                    this.libraryScanner = new ZipDirectoryEntryScanner();
                }
                if (!this.libraryScanner.libraryExists(string, string2)) {
                    return null;
                }
            }
        }
        return new LibraryInfo(string, null, string2, string3, this);
    }

    public ResourceInfo findResource(LibraryInfo libraryInfo, String string, String string2, boolean bl, FacesContext facesContext) {
        ClientResourceInfo clientResourceInfo;
        string = this.trimLeadingSlash(string);
        ContractInfo[] contractInfoArray = new ContractInfo[]{null};
        String[] stringArray = new String[]{null};
        ClassLoader classLoader = Util.getCurrentLoader(this);
        URL uRL = this.findPathConsideringContracts(classLoader, libraryInfo, string, string2, contractInfoArray, stringArray, facesContext);
        String string3 = stringArray[0];
        if (null == uRL) {
            string3 = this.deriveBasePath(libraryInfo, string, string2);
            uRL = classLoader.getResource(string3);
        }
        if (null == uRL && (uRL = this.getClass().getClassLoader().getResource(string3)) == null) {
            string3 = libraryInfo != null ? libraryInfo.getPath(null) + '/' + string : this.getBaseResourcePath() + '/' + string;
            uRL = classLoader.getResource(string3);
            if (uRL == null && (uRL = this.getClass().getClassLoader().getResource(string3)) == null) {
                return null;
            }
            string2 = null;
        }
        if ((clientResourceInfo = libraryInfo != null ? new ClientResourceInfo(libraryInfo, contractInfoArray[0], string, null, bl, this.resourceSupportsEL(string, libraryInfo.getName(), facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp) : new ClientResourceInfo(contractInfoArray[0], string, null, string2, this, bl, this.resourceSupportsEL(string, null, facesContext), facesContext.isProjectStage(ProjectStage.Development), this.cacheTimestamp)).isCompressable()) {
            clientResourceInfo = this.handleCompression(clientResourceInfo);
        }
        return clientResourceInfo;
    }

    private String deriveBasePath(LibraryInfo libraryInfo, String string, String string2) {
        String string3 = null;
        string3 = libraryInfo != null ? libraryInfo.getPath(string2) + '/' + string : (string2 == null ? this.getBaseResourcePath() + '/' + string : this.getBaseResourcePath() + '/' + string2 + '/' + string);
        return string3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private URL findPathConsideringContracts(ClassLoader classLoader, LibraryInfo libraryInfo, String string, String string2, ContractInfo[] contractInfoArray, String[] stringArray, FacesContext facesContext) {
        String string3;
        UIViewRoot uIViewRoot = facesContext.getViewRoot();
        List<String> list = null;
        URL uRL = null;
        if (libraryInfo != null) {
            list = new ArrayList(1);
            list.add(libraryInfo.getContract());
        } else if (uIViewRoot == null) {
            string3 = (String)facesContext.getExternalContext().getRequestParameterMap().get("con");
            if (null == string3 || 0 >= string3.length()) return null;
            list = new ArrayList();
            list.add(string3);
        } else {
            list = facesContext.getResourceLibraryContracts();
        }
        string3 = null;
        for (String string4 : list) {
            string3 = libraryInfo != null ? libraryInfo.getPath(string2) + '/' + string : (string2 == null ? this.getBaseContractsPath() + '/' + string4 + '/' + string : this.getBaseContractsPath() + '/' + string4 + '/' + string2 + '/' + string);
            uRL = classLoader.getResource(string3);
            if (null != uRL) {
                contractInfoArray[0] = new ContractInfo(string4);
                stringArray[0] = string3;
                return uRL;
            }
            string3 = null;
        }
        return uRL;
    }
}

