/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.resource;

import com.sun.faces.application.resource.ContractInfo;
import com.sun.faces.application.resource.LibraryInfo;
import com.sun.faces.application.resource.ResourceHelper;
import com.sun.faces.application.resource.ResourceInfo;
import com.sun.faces.application.resource.VersionInfo;
import com.sun.faces.util.FacesLogger;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.context.FacesContext;

public class ClientResourceInfo
extends ResourceInfo {
    private static final Logger LOGGER = FacesLogger.RESOURCE.getLogger();
    private static final String COMPRESSED_CONTENT_DIRECTORY = "jsf-compressed";
    boolean cacheTimestamp;
    boolean isDevStage;
    String compressedPath;
    boolean compressible;
    boolean supportsEL;
    private volatile long lastModified = Long.MIN_VALUE;

    public ClientResourceInfo(LibraryInfo libraryInfo, ContractInfo contractInfo, String string, VersionInfo versionInfo, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(libraryInfo, contractInfo, string, versionInfo);
        this.compressible = bl;
        this.supportsEL = bl2;
        this.isDevStage = bl3;
        this.cacheTimestamp = !bl3 && bl4;
        this.initPath(bl3);
    }

    ClientResourceInfo(ContractInfo contractInfo, String string, VersionInfo versionInfo, String string2, ResourceHelper resourceHelper, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(contractInfo, string, versionInfo, resourceHelper);
        this.name = string;
        this.version = versionInfo;
        this.localePrefix = string2;
        this.helper = resourceHelper;
        this.compressible = bl;
        this.supportsEL = bl2;
        this.isDevStage = bl3;
        this.cacheTimestamp = !bl3 && bl4;
        this.initPath(bl3);
    }

    ClientResourceInfo(ClientResourceInfo clientResourceInfo, boolean bl) {
        super(clientResourceInfo, bl);
        this.cacheTimestamp = clientResourceInfo.cacheTimestamp;
        this.compressedPath = clientResourceInfo.compressedPath;
        this.compressible = clientResourceInfo.compressible;
        this.isDevStage = clientResourceInfo.isDevStage;
        this.lastModified = clientResourceInfo.lastModified;
        this.supportsEL = clientResourceInfo.supportsEL;
        this.initPath(this.isDevStage);
    }

    public void copy(ClientResourceInfo clientResourceInfo) {
        super.copy(clientResourceInfo);
        this.cacheTimestamp = clientResourceInfo.cacheTimestamp;
        this.compressedPath = clientResourceInfo.compressedPath;
        this.compressible = clientResourceInfo.compressible;
        this.isDevStage = clientResourceInfo.isDevStage;
        this.lastModified = clientResourceInfo.lastModified;
        this.supportsEL = clientResourceInfo.supportsEL;
    }

    public String getCompressedPath() {
        return this.compressedPath;
    }

    public boolean isCompressable() {
        return this.compressible;
    }

    public boolean supportsEL() {
        return this.supportsEL;
    }

    public void disableEL() {
        this.supportsEL = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastModified(FacesContext facesContext) {
        if (this.cacheTimestamp) {
            if (this.lastModified == Long.MIN_VALUE) {
                ClientResourceInfo clientResourceInfo = this;
                synchronized (clientResourceInfo) {
                    if (this.lastModified == Long.MIN_VALUE) {
                        this.lastModified = this.helper.getLastModified(this, facesContext);
                    }
                }
            }
            return this.lastModified;
        }
        return this.helper.getLastModified(this, facesContext);
    }

    public String toString() {
        return "ResourceInfo{name='" + this.name + '\'' + ", version='" + (this.version != null ? this.version : "NONE") + '\'' + ", libraryName='" + this.libraryName + '\'' + ", contractInfo='" + (this.contract != null ? this.contract.contract : "NONE") + '\'' + ", libraryVersion='" + (this.library != null ? this.library.getVersion() : "NONE") + '\'' + ", localePrefix='" + (this.localePrefix != null ? this.localePrefix : "NONE") + '\'' + ", path='" + this.path + '\'' + ", compressible='" + this.compressible + '\'' + ", compressedPath=" + this.compressedPath + '}';
    }

    private void initPath(boolean bl) {
        String string;
        StringBuilder stringBuilder = new StringBuilder(32);
        if (this.library != null) {
            stringBuilder.append(this.library.getPath());
        } else if (null != this.contract) {
            stringBuilder.append(this.helper.getBaseContractsPath());
            stringBuilder.append("/").append(this.contract);
        } else {
            stringBuilder.append(this.helper.getBaseResourcePath());
        }
        if (this.library == null && this.localePrefix != null) {
            stringBuilder.append('/').append(this.localePrefix);
        }
        if (bl && "javax.faces".equals(this.libraryName) && "jsf.js".equals(this.name)) {
            stringBuilder.append('/').append("jsf-uncompressed.js");
        } else {
            stringBuilder.append('/').append(this.name);
        }
        if (this.version != null) {
            stringBuilder.append('/').append(this.version.getVersion());
            string = this.version.getExtension();
            if (string != null) {
                stringBuilder.append('.').append(string);
            }
        }
        this.path = stringBuilder.toString();
        if (this.compressible && !this.supportsEL) {
            string = FacesContext.getCurrentInstance();
            File file = (File)string.getExternalContext().getApplicationMap().get("javax.servlet.context.tempdir");
            if (file == null || !file.isDirectory()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "File ({0}) referenced by javax.servlet.context.tempdir attribute is null, or was is not a directory.  Compression for {1} will be unavailable.", new Object[]{file == null ? "null" : file.toString(), this.path});
                }
                this.compressible = false;
            } else {
                String string2 = this.path.charAt(0) == '/' ? this.path : '/' + this.path;
                File file2 = new File(file, COMPRESSED_CONTENT_DIRECTORY + string2);
                try {
                    if (!file2.exists()) {
                        if (file2.mkdirs()) {
                            this.compressedPath = file2.getCanonicalPath();
                        } else {
                            this.compressible = false;
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, "jsf.application.resource.unable_to_create_compression_directory", file2.getCanonicalPath());
                            }
                        }
                    } else {
                        this.compressedPath = file2.getCanonicalPath();
                    }
                }
                catch (Exception exception) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, exception.toString(), exception);
                    }
                    this.compressible = false;
                }
            }
        }
    }
}

