/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseWebConfigResourceProvider
implements ConfigurationResourceProvider {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();

    @Override
    public Collection<URI> getResources(ServletContext servletContext) {
        WebConfiguration webConfiguration = WebConfiguration.getInstance(servletContext);
        String string = webConfiguration.getOptionValue(this.getParameter());
        LinkedHashSet<URI> linkedHashSet = new LinkedHashSet<URI>(6);
        if (string != null) {
            for (String string2 : Util.split(servletContext, string.trim(), this.getSeparatorRegex())) {
                String string3 = string2.trim();
                if (this.isExcluded(string3) || string3.length() == 0) continue;
                URI uRI = this.getContextURLForPath(servletContext, string3);
                if (uRI != null) {
                    linkedHashSet.add(uRI);
                    continue;
                }
                if (!LOGGER.isLoggable(Level.WARNING)) continue;
                LOGGER.log(Level.WARNING, "jsf.config.web_resource_not_found", new Object[]{string3, WebConfiguration.WebContextInitParameter.JavaxFacesConfigFiles.getQualifiedName()});
            }
        }
        return linkedHashSet;
    }

    protected abstract WebConfiguration.WebContextInitParameter getParameter();

    protected abstract String[] getExcludedResources();

    protected abstract String getSeparatorRegex();

    protected URI getContextURLForPath(ServletContext servletContext, String string) {
        URI uRI = null;
        try {
            URL uRL = servletContext.getResource(string);
            if (null != uRL) {
                String string2 = uRL.toExternalForm();
                string2 = string2.replaceAll(" ", "%20");
                uRI = new URI(string2);
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new FacesException((Throwable)malformedURLException);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new FacesException((Throwable)uRISyntaxException);
        }
        return uRI;
    }

    protected boolean isExcluded(String string) {
        return Arrays.binarySearch(this.getExcludedResources(), string) >= 0;
    }
}

