/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.config.ConfigurationException;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.Verifier;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.config.processor.ApplicationConfigProcessor;
import com.sun.faces.util.FacesLogger;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.servlet.ServletContext;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatorConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String VALIDATOR = "validator";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String VALIDATOR_CLASS = "validator-class";

    public void process(ServletContext servletContext, DocumentInfo[] documentInfoArray) throws Exception {
        this.processAnnotations(FacesValidator.class);
        for (int i = 0; i < documentInfoArray.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing validator elements for document: ''{0}''", documentInfoArray[i].getSourceURI()));
            }
            Document document = documentInfoArray[i].getDocument();
            String string = document.getDocumentElement().getNamespaceURI();
            NodeList nodeList = document.getDocumentElement().getElementsByTagNameNS(string, VALIDATOR);
            if (nodeList == null || nodeList.getLength() <= 0) continue;
            this.addValidators(nodeList, string);
        }
        this.processDefaultValidatorIds();
        this.invokeNext(servletContext, documentInfoArray);
    }

    private void processDefaultValidatorIds() {
        Application application = this.getApplication();
        Map map = application.getDefaultValidatorInfo();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            boolean bl = false;
            Object object = application.getValidatorIds();
            while (object.hasNext()) {
                if (!string.equals(object.next())) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            object = MessageFormat.format("Default validator ''{0}'' does not reference a registered validator.", string);
            throw new ConfigurationException((String)object);
        }
    }

    private void addValidators(NodeList nodeList, String string) throws XPathExpressionException {
        Application application = this.getApplication();
        Verifier verifier = Verifier.getCurrentInstance();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            int n2;
            Node node = nodeList.item(i);
            NodeList nodeList2 = ((Element)node).getElementsByTagNameNS(string, "*");
            String string2 = null;
            String string3 = null;
            int n3 = nodeList2.getLength();
            for (n2 = 0; n2 < n3; ++n2) {
                Node node2 = nodeList2.item(n2);
                if (node2.getNodeType() != 1) continue;
                if (VALIDATOR_ID.equals(node2.getLocalName())) {
                    string2 = this.getNodeText(node2);
                    continue;
                }
                if (!VALIDATOR_CLASS.equals(node2.getLocalName())) continue;
                string3 = this.getNodeText(node2);
            }
            if (string2 == null || string3 == null) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Calling Application.addValidator({0},{1})", string2, string3));
            }
            n2 = 1;
            if (string2.equals("javax.faces.Bean")) {
                n2 = ApplicationConfigProcessor.isBeanValidatorAvailable() ? 1 : 0;
            }
            if (n2 == 0) continue;
            if (verifier != null) {
                verifier.validateObject(Verifier.ObjectType.VALIDATOR, string3, Validator.class);
            }
            application.addValidator(string2, string3);
        }
    }
}

