/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.context.BaseContextMap;
import com.sun.faces.context.ExternalContextImpl;
import com.sun.faces.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestCookieMap
extends BaseContextMap<Object> {
    private final HttpServletRequest request;

    public RequestCookieMap(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
    }

    @Override
    public Object get(Object object) {
        Util.notNull("key", object);
        Cookie[] cookieArray = this.request.getCookies();
        if (null == cookieArray) {
            return null;
        }
        String string = object.toString();
        Cookie cookie = null;
        for (int i = 0; i < cookieArray.length; ++i) {
            if (!cookieArray[i].getName().equals(string)) continue;
            cookie = cookieArray[i];
            break;
        }
        return cookie;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableSet(super.entrySet());
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<Object> values() {
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public boolean equals(Object object) {
        return object != null && object.getClass() == ExternalContextImpl.theUnmodifiableMapClass && super.equals(object);
    }

    @Override
    public int hashCode() {
        int n = 7 * this.request.hashCode();
        Iterator<Map.Entry<String, Object>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += ((Object)iterator.next()).hashCode();
        }
        return n;
    }

    @Override
    protected Iterator<Map.Entry<String, Object>> getEntryIterator() {
        return new BaseContextMap.EntryIterator(new CookieArrayEnumerator(this.request.getCookies()));
    }

    @Override
    protected Iterator<String> getKeyIterator() {
        return new BaseContextMap.KeyIterator(new CookieArrayEnumerator(this.request.getCookies()));
    }

    @Override
    protected Iterator<Object> getValueIterator() {
        return new BaseContextMap.ValueIterator(new CookieArrayEnumerator(this.request.getCookies()));
    }

    private static class CookieArrayEnumerator
    implements Enumeration {
        Cookie[] cookies;
        int curIndex = -1;
        int upperBound;

        public CookieArrayEnumerator(Cookie[] cookieArray) {
            this.cookies = cookieArray;
            this.upperBound = this.cookies != null ? this.cookies.length : -1;
        }

        public boolean hasMoreElements() {
            return this.curIndex + 2 <= this.upperBound;
        }

        public Object nextElement() {
            ++this.curIndex;
            if (this.curIndex < this.upperBound) {
                return this.cookies[this.curIndex].getName();
            }
            throw new NoSuchElementException();
        }
    }
}

