/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.ClientWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UrlBuilder {
    public static final String QUERY_STRING_SEPARATOR = "?";
    public static final String PARAMETER_PAIR_SEPARATOR = "&";
    public static final String PARAMETER_NAME_VALUE_SEPARATOR = "=";
    public static final String FRAGMENT_SEPARATOR = "#";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final List<String> NULL_LIST = Arrays.asList(new String[]{null});
    private StringBuilder url;
    private String path;
    private String queryString;
    private String fragment;
    private Map<String, List<String>> parameters;
    private String encoding;

    public UrlBuilder(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Url cannot be empty");
        }
        this.url = new StringBuilder(string.length() * 2);
        this.extractSegments(string);
        this.encoding = string2;
    }

    public UrlBuilder(String string) {
        this(string, DEFAULT_ENCODING);
    }

    public UrlBuilder addParameters(String string, List<String> list) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Parameter name cannot be empty");
        }
        this.parseQueryString();
        this.addValuesToParameter(string.trim(), list, true);
        return this;
    }

    public UrlBuilder addParameters(Map<String, List<String>> map) {
        if (map != null && !map.isEmpty()) {
            this.parseQueryString();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                List<String> list;
                if (entry.getKey() == null || entry.getKey().trim().length() == 0) {
                    throw new IllegalArgumentException("Parameter name cannot be empty");
                }
                List<String> list2 = list = entry.getValue();
                this.addValuesToParameter(entry.getKey().trim(), list2, true);
            }
        }
        return this;
    }

    public UrlBuilder setPath(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Path cannot be empty");
        }
        this.path = string;
        return this;
    }

    public UrlBuilder setQueryString(String string) {
        this.queryString = string;
        this.cleanQueryString();
        return this;
    }

    public UrlBuilder setFragment(String string) {
        this.fragment = string;
        this.cleanFragment();
        return this;
    }

    public String createUrl() {
        this.appendPath();
        this.appendQueryString();
        this.appendFragment();
        return this.url.toString();
    }

    protected String getPath() {
        return this.path;
    }

    protected Map<String, List<String>> getParameters() {
        this.parseQueryString();
        return this.parameters;
    }

    protected void parseQueryString() {
        String[] stringArray;
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, List<String>>();
        }
        if (this.queryString == null) {
            return;
        }
        Map map = FacesContext.getCurrentInstance().getExternalContext().getApplicationMap();
        for (String string : stringArray = Util.split(map, this.queryString, PARAMETER_PAIR_SEPARATOR)) {
            String[] stringArray2 = Util.split(map, string, PARAMETER_NAME_VALUE_SEPARATOR);
            if (stringArray2.length != 2 || stringArray2[0].trim().length() == 0) continue;
            this.addValueToParameter(stringArray2[0], stringArray2[1], false);
        }
        this.queryString = null;
    }

    protected void appendPath() {
        this.url.append(this.path);
    }

    protected void appendQueryString() {
        boolean bl;
        String string;
        boolean bl2 = false;
        if (this.parameters != null) {
            this.parseQueryString();
            string = QUERY_STRING_SEPARATOR;
            for (Map.Entry entry : this.parameters.entrySet()) {
                for (Object object : (List)entry.getValue()) {
                    this.url.append(string);
                    this.url.append((String)entry.getKey());
                    this.url.append(PARAMETER_NAME_VALUE_SEPARATOR);
                    this.url.append((String)object);
                    string = PARAMETER_PAIR_SEPARATOR;
                }
            }
            bl2 = true;
        } else if (this.queryString != null) {
            this.url.append(QUERY_STRING_SEPARATOR).append(this.queryString);
            bl2 = true;
        }
        string = FacesContext.getCurrentInstance();
        ClientWindow clientWindow = string.getExternalContext().getClientWindow();
        boolean bl22 = false;
        if (null != clientWindow) {
            bl = clientWindow.isClientWindowRenderModeEnabled((FacesContext)string);
        }
        if (bl && -1 == this.url.indexOf("jfwid") && null != clientWindow) {
            Object object;
            String string2 = clientWindow.getId();
            if (!bl2) {
                this.url.append(QUERY_STRING_SEPARATOR);
            } else {
                this.url.append(PARAMETER_PAIR_SEPARATOR);
            }
            this.url.append("jfwid").append(PARAMETER_NAME_VALUE_SEPARATOR).append(string2);
            object = clientWindow.getQueryURLParameters((FacesContext)string);
            if (null != object) {
                for (Map.Entry entry : object.entrySet()) {
                    this.url.append(PARAMETER_NAME_VALUE_SEPARATOR);
                    this.url.append((String)entry.getKey()).append(PARAMETER_NAME_VALUE_SEPARATOR).append((String)entry.getValue());
                }
            }
        }
    }

    protected void appendFragment() {
        if (this.fragment != null) {
            this.url.append(FRAGMENT_SEPARATOR).append(this.fragment);
        }
    }

    protected void extractSegments(String string) {
        int n;
        int n2 = string.indexOf(FRAGMENT_SEPARATOR);
        if (n2 != -1) {
            this.fragment = string.substring(n2 + 1);
            this.cleanFragment();
            string = string.substring(0, n2);
        }
        if ((n = string.indexOf(QUERY_STRING_SEPARATOR)) != -1) {
            this.queryString = string.substring(n + 1);
            this.cleanQueryString();
            this.path = string.substring(0, n);
        } else {
            this.path = string;
        }
    }

    protected void addValueToParameter(String string, String string2, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>(string2 == null ? 0 : 1);
        if (string2 != null) {
            arrayList.add(string2);
        }
        this.addValuesToParameter(string, arrayList, bl);
    }

    protected void addValuesToParameter(String string, List<String> list, boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (String string2 : list) {
                if (this.encoding != null) {
                    try {
                        arrayList.add(URLEncoder.encode(string2, this.encoding));
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new RuntimeException(unsupportedEncodingException);
                    }
                }
                arrayList.add(string2);
            }
            arrayList.removeAll(NULL_LIST);
        }
        if (bl) {
            this.parameters.put(string, arrayList);
        } else {
            List<Object> list2 = this.parameters.get(string);
            if (list2 == null) {
                list2 = new ArrayList(1);
                this.parameters.put(string, list2);
            }
            list2.addAll(arrayList);
        }
    }

    private void cleanFragment() {
        if (this.fragment != null) {
            String string = this.fragment;
            if ((string = string.trim()).startsWith(FRAGMENT_SEPARATOR)) {
                string = string.substring(1);
            }
            if (string.length() == 0) {
                string = null;
            }
            this.fragment = string;
        }
    }

    private void cleanQueryString() {
        if (this.queryString != null) {
            String string = this.queryString;
            if ((string = string.trim()).startsWith(QUERY_STRING_SEPARATOR)) {
                string = string.substring(1);
            }
            if (string.length() == 0) {
                string = null;
            }
            this.queryString = string;
        }
    }
}

