/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets;

import com.sun.faces.facelets.util.FastWriter;
import java.io.IOException;
import java.io.Writer;

final class StateWriter
extends Writer {
    private int initialSize;
    private Writer out;
    private FastWriter fast;
    private boolean writtenState;
    private static final ThreadLocal CURRENT_WRITER = new ThreadLocal();

    public static StateWriter getCurrentInstance() {
        return (StateWriter)CURRENT_WRITER.get();
    }

    public StateWriter(Writer writer, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Initial Size cannot be less than 0");
        }
        this.initialSize = n;
        this.out = writer;
        CURRENT_WRITER.set(this);
    }

    public void writingState() {
        if (!this.writtenState) {
            this.writtenState = true;
            this.fast = new FastWriter(this.initialSize);
            this.out = this.fast;
        }
    }

    public boolean isStateWritten() {
        return this.writtenState;
    }

    public void close() throws IOException {
    }

    public void flush() throws IOException {
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        this.out.write(cArray, n, n2);
    }

    public void write(char[] cArray) throws IOException {
        this.out.write(cArray);
    }

    public void write(int n) throws IOException {
        this.out.write(n);
    }

    public void write(String string, int n, int n2) throws IOException {
        this.out.write(string, n, n2);
    }

    public void write(String string) throws IOException {
        this.out.write(string);
    }

    public String getAndResetBuffer() {
        if (!this.writtenState) {
            throw new IllegalStateException("Did not write state;  no buffer is available");
        }
        String string = this.fast.toString();
        this.fast.reset();
        return string;
    }

    public void release() {
        CURRENT_WRITER.set(null);
    }
}

