/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.compiler;

import com.sun.faces.facelets.compiler.Instruction;
import com.sun.faces.facelets.el.ELText;
import java.io.IOException;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

final class AttributeInstruction
implements Instruction {
    private final String alias;
    private final String attr;
    private final ELText txt;

    public AttributeInstruction(String string, String string2, ELText eLText) {
        this.alias = string;
        this.attr = string2;
        this.txt = eLText;
    }

    public void write(FacesContext facesContext) throws IOException {
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        try {
            ELContext eLContext = facesContext.getELContext();
            String string = this.txt.toString(eLContext);
            if (string != null && string.length() != 0) {
                responseWriter.writeAttribute(this.attr, (Object)string, null);
            }
        }
        catch (ELException eLException) {
            throw new ELException(this.alias + ": " + eLException.getMessage(), eLException.getCause());
        }
        catch (Exception exception) {
            throw new ELException(this.alias + ": " + exception.getMessage(), (Throwable)exception);
        }
    }

    public Instruction apply(ExpressionFactory expressionFactory, ELContext eLContext) {
        ELText eLText = this.txt.apply(expressionFactory, eLContext);
        if (eLText == this.txt) {
            return this;
        }
        return new AttributeInstruction(this.alias, this.attr, eLText);
    }

    public boolean isLiteral() {
        return this.txt.isLiteral();
    }
}

