/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributeException;

final class BeanPropertyTagRule
extends MetaRule {
    public static final BeanPropertyTagRule Instance = new BeanPropertyTagRule();

    BeanPropertyTagRule() {
    }

    public Metadata applyRule(String string, TagAttribute tagAttribute, MetadataTarget metadataTarget) {
        Method method = metadataTarget.getWriteMethod(string);
        if (method != null) {
            if (tagAttribute.isLiteral()) {
                return new LiteralPropertyMetadata(method, tagAttribute);
            }
            return new DynamicPropertyMetadata(method, tagAttribute);
        }
        return null;
    }

    static final class DynamicPropertyMetadata
    extends Metadata {
        private final Method method;
        private final TagAttribute attribute;
        private final Class type;

        public DynamicPropertyMetadata(Method method, TagAttribute tagAttribute) {
            this.method = method;
            this.type = method.getParameterTypes()[0];
            this.attribute = tagAttribute;
        }

        public void applyMetadata(FaceletContext faceletContext, Object object) {
            try {
                this.method.invoke(object, this.attribute.getObject(faceletContext, this.type));
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TagAttributeException(this.attribute, invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw new TagAttributeException(this.attribute, (Throwable)exception);
            }
        }
    }

    static final class LiteralPropertyMetadata
    extends Metadata {
        private final Method method;
        private final TagAttribute attribute;
        private Object[] value;

        public LiteralPropertyMetadata(Method method, TagAttribute tagAttribute) {
            this.method = method;
            this.attribute = tagAttribute;
        }

        public void applyMetadata(FaceletContext faceletContext, Object object) {
            if (this.value == null) {
                String string = this.attribute.getValue();
                this.value = new Object[]{faceletContext.getExpressionFactory().coerceToType((Object)string, this.method.getParameterTypes()[0])};
            }
            try {
                this.method.invoke(object, this.value);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new TagAttributeException(this.attribute, invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw new TagAttributeException(this.attribute, (Throwable)exception);
            }
        }
    }
}

