/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.composite;

import com.sun.faces.facelets.el.TagValueExpression;
import com.sun.faces.facelets.tag.composite.PropertyHandler;
import com.sun.faces.facelets.tag.composite.TypedPropertyHandler;
import com.sun.faces.util.Util;
import java.beans.FeatureDescriptor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.ProjectStage;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyHandlerManager {
    private static final Map<String, PropertyHandler> ALL_HANDLERS = new HashMap<String, PropertyHandler>(12, 1.0f);
    private static final String[] DEV_ONLY_ATTRIBUTES;
    private Map<String, PropertyHandler> managedHandlers;
    private PropertyHandler genericHandler = new ObjectValueExpressionPropertyHandler();

    private PropertyHandlerManager(Map<String, PropertyHandler> map) {
        this.managedHandlers = map;
    }

    static PropertyHandlerManager getInstance(String[] stringArray) {
        HashMap<String, PropertyHandler> hashMap = new HashMap<String, PropertyHandler>(stringArray.length, 1.0f);
        for (String string : stringArray) {
            hashMap.put(string, ALL_HANDLERS.get(string));
        }
        return new PropertyHandlerManager(hashMap);
    }

    PropertyHandler getHandler(FaceletContext faceletContext, String string) {
        if (!faceletContext.getFacesContext().isProjectStage(ProjectStage.Development) && Arrays.binarySearch(DEV_ONLY_ATTRIBUTES, string) >= 0) {
            return null;
        }
        PropertyHandler propertyHandler = this.managedHandlers.get(string);
        return propertyHandler != null ? propertyHandler : this.genericHandler;
    }

    static {
        ALL_HANDLERS.put("targets", new StringValueExpressionPropertyHandler());
        ALL_HANDLERS.put("targetAttributeName", new StringValueExpressionPropertyHandler());
        ALL_HANDLERS.put("method-signature", new StringValueExpressionPropertyHandler());
        ALL_HANDLERS.put("type", new StringValueExpressionPropertyHandler());
        ALL_HANDLERS.put("default", new DefaultPropertyHandler());
        ALL_HANDLERS.put("displayName", new DisplayNamePropertyHandler());
        ALL_HANDLERS.put("shortDescription", new ShortDescriptionPropertyHandler());
        ALL_HANDLERS.put("expert", new ExpertPropertyHandler());
        ALL_HANDLERS.put("hidden", new HiddenPropertyHandler());
        ALL_HANDLERS.put("preferred", new PreferredPropertyHandler());
        ALL_HANDLERS.put("required", new BooleanValueExpressionPropertyHandler());
        ALL_HANDLERS.put("name", new NamePropertyHandler());
        ALL_HANDLERS.put("componentType", new ComponentTypePropertyHandler());
        DEV_ONLY_ATTRIBUTES = new String[]{"displayName", "shortDescription", "export", "hidden", "preferred"};
        Arrays.sort(DEV_ONLY_ATTRIBUTES);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BooleanValueExpressionPropertyHandler
    extends TypedValueExpressionPropertyHandler {
        private BooleanValueExpressionPropertyHandler() {
        }

        @Override
        public Class<?> getEvalType() {
            return Boolean.class;
        }
    }

    private static final class DisplayNamePropertyHandler
    extends StringFeatureDescriptorPropertyHandler {
        private DisplayNamePropertyHandler() {
        }

        public void apply(FaceletContext faceletContext, String string, FeatureDescriptor featureDescriptor, TagAttribute tagAttribute) {
            ValueExpression valueExpression = tagAttribute.getValueExpression(faceletContext, this.getEvalType());
            featureDescriptor.setDisplayName((String)valueExpression.getValue((ELContext)faceletContext));
        }
    }

    private static final class ExpertPropertyHandler
    extends BooleanFeatureDescriptorPropertyHandler {
        private ExpertPropertyHandler() {
        }

        public void apply(FaceletContext faceletContext, String string, FeatureDescriptor featureDescriptor, TagAttribute tagAttribute) {
            ValueExpression valueExpression = tagAttribute.getValueExpression(faceletContext, this.getEvalType());
            featureDescriptor.setExpert((Boolean)valueExpression.getValue((ELContext)faceletContext));
        }
    }

    private static final class HiddenPropertyHandler
    extends BooleanFeatureDescriptorPropertyHandler {
        private HiddenPropertyHandler() {
        }

        public void apply(FaceletContext faceletContext, String string, FeatureDescriptor featureDescriptor, TagAttribute tagAttribute) {
            ValueExpression valueExpression = tagAttribute.getValueExpression(faceletContext, this.getEvalType());
            featureDescriptor.setHidden((Boolean)valueExpression.getValue((ELContext)faceletContext));
        }
    }

    private static final class PreferredPropertyHandler
    extends BooleanFeatureDescriptorPropertyHandler {
        private PreferredPropertyHandler() {
        }

        public void apply(FaceletContext faceletContext, String string, FeatureDescriptor featureDescriptor, TagAttribute tagAttribute) {
            ValueExpression valueExpression = tagAttribute.getValueExpression(faceletContext, this.getEvalType());
            featureDescriptor.setPreferred((Boolean)valueExpression.getValue((ELContext)faceletContext));
        }
    }

    private static class ComponentTypePropertyHandler
    extends StringValueExpressionPropertyHandler {
        private ComponentTypePropertyHandler() {
        }

        public void apply(FaceletContext faceletContext, String string, FeatureDescriptor featureDescriptor, TagAttribute tagAttribute) {
            super.apply(faceletContext, "javax.faces.component.COMPOSITE_COMPONENT_TYPE", featureDescriptor, tagAttribute);
        }
    }

    private static class DefaultPropertyHandler
    implements PropertyHandler {
        private DefaultPropertyHandler() {
        }

        public void apply(FaceletContext faceletContext, String string, FeatureDescriptor featureDescriptor, TagAttribute tagAttribute) {
            Class clazz = Object.class;
            Object object = featureDescriptor.getValue("type");
            if (null != object && !(object instanceof Class)) {
                TagValueExpression tagValueExpression = (TagValueExpression)object;
                Object object2 = tagValueExpression.getValue((ELContext)faceletContext);
                if (object2 instanceof Class) {
                    clazz = (Class)object2;
                } else if (object2 != null) {
                    try {
                        clazz = Util.loadClass(String.valueOf(object2), this);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new IllegalArgumentException(classNotFoundException);
                    }
                }
            } else {
                clazz = null != object ? (Class)object : Object.class;
            }
            featureDescriptor.setValue(string, tagAttribute.getValueExpression(faceletContext, clazz));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectValueExpressionPropertyHandler
    extends TypedValueExpressionPropertyHandler {
        private ObjectValueExpressionPropertyHandler() {
        }

        @Override
        public Class<?> getEvalType() {
            return Object.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StringValueExpressionPropertyHandler
    extends TypedValueExpressionPropertyHandler {
        private StringValueExpressionPropertyHandler() {
        }

        @Override
        public Class<?> getEvalType() {
            return String.class;
        }
    }

    private static final class ShortDescriptionPropertyHandler
    extends StringFeatureDescriptorPropertyHandler {
        private ShortDescriptionPropertyHandler() {
        }

        public void apply(FaceletContext faceletContext, String string, FeatureDescriptor featureDescriptor, TagAttribute tagAttribute) {
            ValueExpression valueExpression = tagAttribute.getValueExpression(faceletContext, this.getEvalType());
            String string2 = (String)valueExpression.getValue((ELContext)faceletContext);
            if (string2 != null) {
                featureDescriptor.setShortDescription((String)valueExpression.getValue((ELContext)faceletContext));
            }
        }
    }

    private static final class NamePropertyHandler
    extends StringFeatureDescriptorPropertyHandler {
        private NamePropertyHandler() {
        }

        public void apply(FaceletContext faceletContext, String string, FeatureDescriptor featureDescriptor, TagAttribute tagAttribute) {
            ValueExpression valueExpression = tagAttribute.getValueExpression(faceletContext, this.getEvalType());
            String string2 = (String)valueExpression.getValue((ELContext)faceletContext);
            if (string2 != null) {
                featureDescriptor.setShortDescription((String)valueExpression.getValue((ELContext)faceletContext));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TypedValueExpressionPropertyHandler
    implements TypedPropertyHandler {
        private TypedValueExpressionPropertyHandler() {
        }

        @Override
        public void apply(FaceletContext faceletContext, String string, FeatureDescriptor featureDescriptor, TagAttribute tagAttribute) {
            featureDescriptor.setValue(string, tagAttribute.getValueExpression(faceletContext, this.getEvalType()));
        }

        @Override
        public abstract Class<?> getEvalType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class StringFeatureDescriptorPropertyHandler
    implements TypedPropertyHandler {
        private StringFeatureDescriptorPropertyHandler() {
        }

        @Override
        public Class<?> getEvalType() {
            return String.class;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BooleanFeatureDescriptorPropertyHandler
    implements TypedPropertyHandler {
        private BooleanFeatureDescriptorPropertyHandler() {
        }

        @Override
        public Class<?> getEvalType() {
            return Boolean.class;
        }
    }
}

