/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.facelets.el.LegacyValueBinding;
import com.sun.faces.util.FacesLogger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.el.ValueBinding;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRule;
import javax.faces.view.facelets.Metadata;
import javax.faces.view.facelets.MetadataTarget;
import javax.faces.view.facelets.TagAttribute;

final class ComponentRule
extends MetaRule {
    private static final Logger log = FacesLogger.FACELETS_COMPONENT.getLogger();
    public static final ComponentRule Instance = new ComponentRule();

    public Metadata applyRule(String string, TagAttribute tagAttribute, MetadataTarget metadataTarget) {
        if (metadataTarget.isTargetInstanceOf(UIComponent.class)) {
            if (!tagAttribute.isLiteral()) {
                Class<Object> clazz = metadataTarget.getPropertyType(string);
                if (clazz == null) {
                    clazz = Object.class;
                }
                return new ValueExpressionMetadata(string, clazz, tagAttribute);
            }
            if (metadataTarget.getWriteMethod(string) == null) {
                ComponentRule.warnAttr(tagAttribute, metadataTarget.getTargetClass(), string);
                return new LiteralAttributeMetadata(string, tagAttribute.getValue());
            }
        }
        return null;
    }

    private static void warnAttr(TagAttribute tagAttribute, Class clazz, String string) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(tagAttribute + " Property '" + string + "' is not on type: " + clazz.getName());
        }
    }

    static final class ValueBindingMetadata
    extends Metadata {
        private final String name;
        private final TagAttribute attr;
        private final Class type;

        public ValueBindingMetadata(String string, Class clazz, TagAttribute tagAttribute) {
            this.name = string;
            this.attr = tagAttribute;
            this.type = clazz;
        }

        public void applyMetadata(FaceletContext faceletContext, Object object) {
            ((UIComponent)object).setValueBinding(this.name, (ValueBinding)new LegacyValueBinding(this.attr.getValueExpression(faceletContext, this.type)));
        }
    }

    static final class ValueExpressionMetadata
    extends Metadata {
        private final String name;
        private final TagAttribute attr;
        private final Class type;

        public ValueExpressionMetadata(String string, Class clazz, TagAttribute tagAttribute) {
            this.name = string;
            this.attr = tagAttribute;
            this.type = clazz;
        }

        public void applyMetadata(FaceletContext faceletContext, Object object) {
            ((UIComponent)object).setValueExpression(this.name, this.attr.getValueExpression(faceletContext, this.type));
        }
    }

    static final class LiteralAttributeMetadata
    extends Metadata {
        private final String name;
        private final String value;

        public LiteralAttributeMetadata(String string, String string2) {
            this.value = string2;
            this.name = string;
        }

        public void applyMetadata(FaceletContext faceletContext, Object object) {
            ((UIComponent)object).getAttributes().put(this.name, this.value);
        }
    }
}

