/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.flow;

import com.sun.faces.flow.FlowCDIContext;
import com.sun.faces.flow.FlowImpl;
import com.sun.faces.util.Util;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.flow.Flow;
import javax.faces.flow.FlowCallNode;
import javax.faces.flow.FlowHandler;
import javax.faces.flow.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowHandlerImpl
extends FlowHandler {
    public static final String ABANDONED_FLOW = "javax.faces.flow.AbandonedFlow";
    private boolean flowFeatureIsEnabled = false;
    private Map<String, Map<String, Flow>> flows = new ConcurrentHashMap<String, Map<String, Flow>>();
    private Map<String, List<Flow>> flowsByFlowId = new ConcurrentHashMap<String, List<Flow>>();
    public static final String FLOW_RETURN_DEPTH_PARAM_NAME = "jffrd";

    public Map<Object, Object> getCurrentFlowScope() {
        return FlowCDIContext.getCurrentFlowScopeAndUpdateSession();
    }

    public Flow getFlow(FacesContext facesContext, String string, String string2) {
        Util.notNull("context", facesContext);
        Util.notNull("definingDocumentId", string);
        Util.notNull("id", string2);
        Flow flow = null;
        Map<String, Flow> map = this.flows.get(string);
        if (null != map) {
            flow = map.get(string2);
        }
        return flow;
    }

    public void addFlow(FacesContext facesContext, Flow flow) {
        Flow flow2;
        Util.notNull("context", facesContext);
        Util.notNull("toAdd", flow);
        String string = flow.getId();
        if (null == string || 0 == string.length()) {
            throw new IllegalArgumentException("The id of the flow may not be null or zero-length.");
        }
        String string2 = flow.getDefiningDocumentId();
        if (null == string2) {
            throw new IllegalArgumentException("The definingDocumentId of the flow may not be null.");
        }
        Map<String, Flow> map = this.flows.get(string2);
        if (null == map) {
            map = new ConcurrentHashMap<String, Flow>();
            this.flows.put(flow.getDefiningDocumentId(), map);
        }
        if (null != (flow2 = map.put(string, flow))) {
            String string3 = MessageFormat.format("Flow with id \"{0}\" and definingDocumentId \"{1}\" already exists.", string, string2);
            throw new IllegalStateException(string3);
        }
        List<Flow> list = this.flowsByFlowId.get(string);
        if (null == list) {
            list = new CopyOnWriteArrayList<Flow>();
            this.flowsByFlowId.put(string, list);
        }
        list.add(flow);
        NavigationHandler navigationHandler = facesContext.getApplication().getNavigationHandler();
        if (navigationHandler instanceof ConfigurableNavigationHandler) {
            ((ConfigurableNavigationHandler)navigationHandler).inspectFlow(facesContext, flow);
        }
        this.flowFeatureIsEnabled = true;
    }

    public boolean isActive(FacesContext facesContext, String string, String string2) {
        Util.notNull("context", facesContext);
        Util.notNull("definingDocumentId", string);
        Util.notNull("id", string2);
        boolean bl = false;
        FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
        for (Flow flow : flowDeque) {
            if (!string2.equals(flow.getId()) || !string.equals(flow.getDefiningDocumentId())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public Flow getCurrentFlow(FacesContext facesContext) {
        Util.notNull("context", facesContext);
        if (!this.flowFeatureIsEnabled) {
            return null;
        }
        Flow flow = null;
        if (null == facesContext.getExternalContext().getSession(false)) {
            return null;
        }
        FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
        int n = flowDeque.getReturnDepth();
        if (flowDeque.size() <= n) {
            return null;
        }
        if (0 < n) {
            Iterator<Flow> iterator = flowDeque.iterator();
            int n2 = 0;
            iterator.next();
            if (iterator.hasNext()) {
                do {
                    flow = iterator.next();
                } while (++n2 < n);
            }
        } else {
            flow = this.getFlowStack(facesContext).peekFirst();
        }
        return flow;
    }

    public String getLastDisplayedViewId(FacesContext facesContext) {
        Util.notNull("context", facesContext);
        String string = null;
        FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
        string = flowDeque.peekLastDisplayedViewId();
        return string;
    }

    public int getAndClearReturnModeDepth(FacesContext facesContext) {
        int n = 0;
        FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
        n = ((FlowDeque)flowDeque).getAndClearMaxReturnDepth(facesContext);
        return n;
    }

    public void pushReturnMode(FacesContext facesContext) {
        Util.notNull("context", facesContext);
        FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
        flowDeque.pushReturnMode();
    }

    public void popReturnMode(FacesContext facesContext) {
        Util.notNull("context", facesContext);
        FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
        flowDeque.popReturnMode();
    }

    public void transition(FacesContext facesContext, Flow flow, Flow flow2, FlowCallNode flowCallNode, String string) {
        Util.notNull("context", facesContext);
        Util.notNull("toViewId", string);
        if (!this.flowFeatureIsEnabled) {
            return;
        }
        if (!this.flowsEqual(flow, flow2)) {
            String string2;
            Object object;
            Map map;
            Map map2;
            HashMap<String, Object> hashMap = null;
            if (null != flowCallNode) {
                map2 = flowCallNode.getOutboundParameters();
                map = flow2.getInboundParameters();
                if (null != map2 && !map2.isEmpty() && null != map && !map.isEmpty()) {
                    object = facesContext.getELContext();
                    for (Map.Entry entry : map2.entrySet()) {
                        string2 = (String)entry.getKey();
                        if (!map.containsKey(string2)) continue;
                        if (null == hashMap) {
                            hashMap = new HashMap<String, Object>();
                        }
                        hashMap.put(string2, ((Parameter)entry.getValue()).getValue().getValue(object));
                    }
                }
            }
            this.performPops(facesContext, flow, flow2);
            if (null != flow2 && !flow2.equals(FlowImpl.ABANDONED_FLOW)) {
                this.pushFlow(facesContext, flow2, string);
            }
            if (null != hashMap) {
                map2 = flow2.getInboundParameters();
                map = facesContext.getELContext();
                for (Map.Entry entry : hashMap.entrySet()) {
                    object = (String)entry.getKey();
                    assert (map2.containsKey(object));
                    string2 = ((Parameter)map2.get(object)).getValue();
                    string2.setValue((ELContext)map, entry.getValue());
                }
            }
        }
    }

    public void clientWindowTransition(FacesContext facesContext) {
        Map map = facesContext.getExternalContext().getRequestParameterMap();
        String string = (String)map.get("jftfdi");
        String string2 = (String)map.get("jffi");
        if (null != string) {
            FlowHandler flowHandler = facesContext.getApplication().getFlowHandler();
            Flow flow = flowHandler.getCurrentFlow(facesContext);
            Flow flow2 = null;
            FlowCallNode flowCallNode = null;
            if (null != string2 && !"javax.faces.flow.NullFlow".equals(string)) {
                flow2 = flowHandler.getFlow(facesContext, string, string2);
                if (null != flow2 && null != flow) {
                    flowCallNode = flow.getFlowCall(flow2);
                }
            } else {
                String string3 = (String)map.get(FLOW_RETURN_DEPTH_PARAM_NAME);
                int n = Integer.valueOf(string3);
                FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
                ((FlowDeque)flowDeque).setMaxReturnDepth(facesContext, n);
            }
            flowHandler.transition(facesContext, flow, flow2, flowCallNode, facesContext.getViewRoot().getViewId());
        }
    }

    private void performPops(FacesContext facesContext, Flow flow, Flow flow2) {
        if (null == flow) {
            assert (null == this.peekFlow(facesContext));
            return;
        }
        if (null == flow2) {
            FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
            int n = ((FlowDeque)flowDeque).getAndClearMaxReturnDepth(facesContext);
            for (int i = 0; i < n; ++i) {
                this.popFlow(facesContext);
            }
            return;
        }
        if (FlowImpl.ABANDONED_FLOW.equals(flow2)) {
            FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
            int n = flowDeque.size();
            for (int i = 0; i < n; ++i) {
                this.popFlow(facesContext);
            }
            return;
        }
        if (null == flow.getFlowCall(flow2)) {
            this.popFlow(facesContext);
        }
    }

    private boolean flowsEqual(Flow flow, Flow flow2) {
        boolean bl = false;
        bl = flow == flow2 ? true : (null == flow || null == flow2 ? false : flow.equals(flow2));
        return bl;
    }

    private void pushFlow(FacesContext facesContext, Flow flow, String string) {
        FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
        flowDeque.addFirst(flow, string);
        FlowCDIContext.flowEntered();
        MethodExpression methodExpression = flow.getInitializer();
        if (null != methodExpression) {
            methodExpression.invoke(facesContext.getELContext(), null);
        }
        this.forceSessionUpdateForFlowStack(facesContext, flowDeque);
    }

    private Flow peekFlow(FacesContext facesContext) {
        FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
        return flowDeque.peekFirst();
    }

    private Flow popFlow(FacesContext facesContext) {
        FlowDeque<Flow> flowDeque = this.getFlowStack(facesContext);
        Flow flow = this.peekFlow(facesContext);
        if (null != flow) {
            this.callFinalizer(facesContext, flow);
        }
        Flow flow2 = flowDeque.pollFirst();
        this.forceSessionUpdateForFlowStack(facesContext, flowDeque);
        return flow2;
    }

    private void callFinalizer(FacesContext facesContext, Flow flow) {
        MethodExpression methodExpression = flow.getFinalizer();
        if (null != methodExpression) {
            methodExpression.invoke(facesContext.getELContext(), null);
        }
        FlowCDIContext.flowExited();
    }

    private FlowDeque<Flow> getFlowStack(FacesContext facesContext) {
        FlowDeque flowDeque = null;
        ExternalContext externalContext = facesContext.getExternalContext();
        String string = externalContext.getClientWindow().getId() + "_flowStack";
        Map map = externalContext.getSessionMap();
        flowDeque = (FlowDeque)map.get(string);
        if (null == flowDeque) {
            flowDeque = new FlowDeque(string);
            map.put(string, flowDeque);
        }
        return flowDeque;
    }

    private void forceSessionUpdateForFlowStack(FacesContext facesContext, FlowDeque<Flow> flowDeque) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Map map = externalContext.getSessionMap();
        map.put(flowDeque.getSessionKey(), flowDeque);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FlowDeque<E>
    implements Iterable<E>,
    Serializable {
        private static final long serialVersionUID = 7915803727932706270L;
        private int returnDepth = 0;
        private ArrayDeque<E> data = new ArrayDeque();
        private ArrayDeque<RideAlong> rideAlong = new ArrayDeque();
        private final String sessionKey;

        public FlowDeque(String string) {
            this.sessionKey = string;
        }

        public String getSessionKey() {
            return this.sessionKey;
        }

        public int size() {
            return this.data.size();
        }

        @Override
        public Iterator<E> iterator() {
            return this.data.iterator();
        }

        public void addFirst(E e, String string) {
            this.rideAlong.addFirst(new RideAlong(string));
            this.data.addFirst(e);
        }

        public E pollFirst() {
            this.rideAlong.pollFirst();
            return this.data.pollFirst();
        }

        public E peekFirst() {
            return this.data.peekFirst();
        }

        public String peekLastDisplayedViewId() {
            String string = null;
            RideAlong rideAlong = null;
            int n = this.getReturnDepth();
            if (0 < n) {
                Iterator<RideAlong> iterator = this.rideAlong.iterator();
                iterator.next();
                int n2 = 0;
                if (iterator.hasNext()) {
                    do {
                        rideAlong = iterator.next();
                    } while (++n2 < n);
                }
            } else {
                rideAlong = this.rideAlong.peekFirst();
            }
            if (null != rideAlong) {
                string = rideAlong.lastDisplayedViewId;
            }
            return string;
        }

        public int getReturnDepth() {
            return this.returnDepth;
        }

        private void setMaxReturnDepth(FacesContext facesContext, int n) {
            Map map = facesContext.getAttributes();
            map.put(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME, n);
        }

        private int getAndClearMaxReturnDepth(FacesContext facesContext) {
            Map map = facesContext.getAttributes();
            int n = 0;
            if (map.containsKey(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME)) {
                n = (Integer)map.remove(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME);
            }
            return n;
        }

        private void incrementMaxReturnDepth() {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            Map map = facesContext.getAttributes();
            if (!map.containsKey(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME)) {
                map.put(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME, 1);
            } else {
                Integer n = (Integer)map.get(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME);
                map.put(FlowHandlerImpl.FLOW_RETURN_DEPTH_PARAM_NAME, n + 1);
            }
        }

        public void pushReturnMode() {
            this.incrementMaxReturnDepth();
            ++this.returnDepth;
        }

        public void popReturnMode() {
            --this.returnDepth;
        }

        private static class RideAlong
        implements Serializable {
            String lastDisplayedViewId;

            public RideAlong(String string) {
                this.lastDisplayedViewId = string;
            }
        }
    }
}

