/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class Base64InputStream
extends InputStream {
    private static final int[] IA = new int[256];
    private static final char[] CA = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public Base64InputStream(String string) {
        this.buf = this.decode(string);
        this.pos = 0;
        this.count = this.buf.length;
    }

    public int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) {
        this.mark = this.pos;
    }

    public void reset() {
        this.pos = this.mark;
    }

    public void close() throws IOException {
    }

    private byte[] decode(String string) {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 == 0) {
            return new byte[0];
        }
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n4 && IA[string.charAt(n2) & 0xFF] < 0; ++n2) {
        }
        while (n4 > 0 && IA[string.charAt(n4) & 0xFF] < 0) {
            --n4;
        }
        int n5 = string.charAt(n4) == '=' ? (string.charAt(n4 - 1) == '=' ? 2 : 1) : 0;
        int n6 = n4 - n2 + 1;
        int n7 = n3 > 76 ? (string.charAt(76) == '\r' ? n6 / 78 : 0) << 1 : 0;
        int n8 = ((n6 - n7) * 6 >> 3) - n5;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        int n10 = n8 / 3 * 3;
        while (n9 < n10) {
            n = IA[string.charAt(n2++)] << 18 | IA[string.charAt(n2++)] << 12 | IA[string.charAt(n2++)] << 6 | IA[string.charAt(n2++)];
            byArray[n9++] = (byte)(n >> 16);
            byArray[n9++] = (byte)(n >> 8);
            byArray[n9++] = (byte)n;
        }
        if (n9 < n8) {
            n10 = 0;
            n = 0;
            while (n2 <= n4 - n5) {
                n10 |= IA[string.charAt(n2++)] << 18 - n * 6;
                ++n;
            }
            n = 16;
            while (n9 < n8) {
                byArray[n9++] = (byte)(n10 >> n);
                n -= 8;
            }
        }
        return byArray;
    }

    static {
        Arrays.fill(IA, -1);
        int n = CA.length;
        for (int i = 0; i < n; ++i) {
            Base64InputStream.IA[Base64InputStream.CA[i]] = i;
        }
        Base64InputStream.IA[61] = 0;
    }
}

