/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.LifecycleImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifecycleFactoryImpl
extends LifecycleFactory {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();
    protected ConcurrentHashMap<String, Lifecycle> lifecycleMap = new ConcurrentHashMap();

    public LifecycleFactoryImpl() {
        this.lifecycleMap.put("DEFAULT", new LifecycleImpl(FacesContext.getCurrentInstance()));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Created Default Lifecycle");
        }
    }

    public void addLifecycle(String string, Lifecycle lifecycle) {
        if (string == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycleId"));
        }
        if (lifecycle == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycle"));
        }
        if (null != this.lifecycleMap.get(string)) {
            Object[] objectArray = new Object[]{string};
            String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", objectArray);
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning(MessageUtils.getExceptionMessageString("com.sun.faces.LIFECYCLE_ID_ALREADY_ADDED", objectArray));
            }
            throw new IllegalArgumentException(string2);
        }
        this.lifecycleMap.put(string, lifecycle);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("addedLifecycle: " + string + " " + lifecycle);
        }
    }

    public Lifecycle getLifecycle(String string) throws FacesException {
        if (null == string) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycleId"));
        }
        if (null == this.lifecycleMap.get(string)) {
            Object[] objectArray = new Object[]{string};
            String string2 = MessageUtils.getExceptionMessageString("com.sun.faces.CANT_CREATE_LIFECYCLE_ERROR", objectArray);
            throw new IllegalArgumentException(string2);
        }
        Lifecycle lifecycle = this.lifecycleMap.get(string);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getLifecycle: " + string + " " + lifecycle);
        }
        return lifecycle;
    }

    public Iterator<String> getLifecycleIds() {
        return this.lifecycleMap.keySet().iterator();
    }
}

