/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.renderkit.html_basic;

import com.sun.faces.renderkit.Attribute;
import com.sun.faces.renderkit.AttributeManager;
import com.sun.faces.renderkit.html_basic.BaseTableRenderer;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIColumn;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRenderer
extends BaseTableRenderer {
    private static final Attribute[] ATTRIBUTES = AttributeManager.getAttributes(AttributeManager.Key.DATATABLE);

    public void encodeBegin(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        UIData uIData = (UIData)uIComponent;
        uIData.setRowIndex(-1);
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        this.renderTableStart(facesContext, uIComponent, responseWriter, ATTRIBUTES);
        this.renderCaption(facesContext, (UIComponent)uIData, responseWriter);
        this.renderColumnGroups(facesContext, (UIComponent)uIData);
        this.renderHeader(facesContext, uIComponent, responseWriter);
        this.renderFooter(facesContext, uIComponent, responseWriter);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncodeChildren(uIComponent)) {
            return;
        }
        UIData uIData = (UIData)uIComponent;
        ResponseWriter responseWriter = facesContext.getResponseWriter();
        BaseTableRenderer.TableMetaInfo tableMetaInfo = this.getMetaInfo(facesContext, (UIComponent)uIData);
        if (tableMetaInfo.columns.isEmpty()) {
            this.renderEmptyTableBody(responseWriter, (UIComponent)uIData);
            return;
        }
        int n = 0;
        int n2 = uIData.getFirst() - 1;
        int n3 = uIData.getRows();
        List<Integer> list = this.getBodyRows(facesContext.getExternalContext().getApplicationMap(), uIData);
        boolean bl = list != null && !list.isEmpty();
        boolean bl2 = false;
        if (!bl) {
            this.renderTableBodyStart(facesContext, uIComponent, responseWriter);
        }
        boolean bl3 = false;
        while (n3 <= 0 || ++n <= n3) {
            uIData.setRowIndex(++n2);
            if (!uIData.isRowAvailable()) break;
            if (bl && list.contains(uIData.getRowIndex())) {
                if (bl2) {
                    responseWriter.endElement("tbody");
                }
                responseWriter.startElement("tbody", (UIComponent)uIData);
                bl2 = true;
            }
            this.renderRowStart(facesContext, uIComponent, responseWriter);
            this.renderRow(facesContext, uIComponent, null, responseWriter);
            this.renderRowEnd(facesContext, uIComponent, responseWriter);
            bl3 = true;
        }
        if (!bl3) {
            this.renderEmptyTableRow(responseWriter, (UIComponent)uIData);
        }
        this.renderTableBodyEnd(facesContext, uIComponent, responseWriter);
        uIData.setRowIndex(-1);
    }

    @Override
    public void encodeEnd(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        this.rendererParamsNotNull(facesContext, uIComponent);
        if (!this.shouldEncode(uIComponent)) {
            return;
        }
        this.clearMetaInfo(facesContext, uIComponent);
        ((UIData)uIComponent).setRowIndex(-1);
        this.renderTableEnd(facesContext, uIComponent, facesContext.getResponseWriter());
    }

    @Override
    public boolean getRendersChildren() {
        return true;
    }

    private List<Integer> getBodyRows(Map<String, Object> map, UIData uIData) {
        String[] stringArray;
        ArrayList<Integer> arrayList = null;
        String string = (String)uIData.getAttributes().get("bodyrows");
        if (string != null && (stringArray = Util.split(map, string, ",")) != null) {
            arrayList = new ArrayList<Integer>(stringArray.length);
            for (String string2 : stringArray) {
                arrayList.add(Integer.valueOf(string2));
            }
        }
        return arrayList;
    }

    protected void renderColumnGroups(FacesContext facesContext, UIComponent uIComponent) throws IOException {
        UIComponent uIComponent2 = this.getFacet(uIComponent, "colgroups");
        if (uIComponent2 != null) {
            this.encodeRecursive(facesContext, uIComponent2);
        }
    }

    @Override
    protected void renderFooter(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
        BaseTableRenderer.TableMetaInfo tableMetaInfo = this.getMetaInfo(facesContext, uIComponent);
        UIComponent uIComponent2 = this.getFacet(uIComponent, "footer");
        if (uIComponent2 == null && !tableMetaInfo.hasFooterFacets) {
            return;
        }
        String string = (String)uIComponent.getAttributes().get("footerClass");
        responseWriter.startElement("tfoot", uIComponent);
        responseWriter.writeText((Object)"\n", uIComponent, null);
        if (tableMetaInfo.hasFooterFacets) {
            responseWriter.startElement("tr", uIComponent);
            responseWriter.writeText((Object)"\n", uIComponent, null);
            for (UIColumn uIColumn : tableMetaInfo.columns) {
                String string2 = (String)uIColumn.getAttributes().get("footerClass");
                responseWriter.startElement("td", (UIComponent)uIColumn);
                if (string2 != null) {
                    responseWriter.writeAttribute("class", (Object)string2, "columnFooterClass");
                } else if (string != null) {
                    responseWriter.writeAttribute("class", (Object)string, "footerClass");
                }
                UIComponent uIComponent3 = this.getFacet((UIComponent)uIColumn, "footer");
                if (uIComponent3 != null) {
                    responseWriter.writeText((Object)"", uIComponent, null);
                    this.encodeRecursive(facesContext, uIComponent3);
                }
                responseWriter.endElement("td");
                responseWriter.writeText((Object)"\n", uIComponent, null);
            }
            this.renderRowEnd(facesContext, uIComponent, responseWriter);
        }
        if (uIComponent2 != null) {
            responseWriter.startElement("tr", uIComponent2);
            responseWriter.startElement("td", uIComponent2);
            if (string != null) {
                responseWriter.writeAttribute("class", (Object)string, "footerClass");
            }
            if (tableMetaInfo.columns.size() > 1) {
                responseWriter.writeAttribute("colspan", (Object)String.valueOf(tableMetaInfo.columns.size()), null);
            }
            this.encodeRecursive(facesContext, uIComponent2);
            responseWriter.endElement("td");
            this.renderRowEnd(facesContext, uIComponent, responseWriter);
        }
        responseWriter.endElement("tfoot");
        responseWriter.writeText((Object)"\n", uIComponent, null);
    }

    @Override
    protected void renderHeader(FacesContext facesContext, UIComponent uIComponent, ResponseWriter responseWriter) throws IOException {
        BaseTableRenderer.TableMetaInfo tableMetaInfo = this.getMetaInfo(facesContext, uIComponent);
        UIComponent uIComponent2 = this.getFacet(uIComponent, "header");
        if (uIComponent2 == null && !tableMetaInfo.hasHeaderFacets) {
            return;
        }
        String string = (String)uIComponent.getAttributes().get("headerClass");
        responseWriter.startElement("thead", uIComponent);
        responseWriter.writeText((Object)"\n", uIComponent, null);
        if (uIComponent2 != null) {
            responseWriter.startElement("tr", uIComponent2);
            responseWriter.startElement("th", uIComponent2);
            if (string != null) {
                responseWriter.writeAttribute("class", (Object)string, "headerClass");
            }
            if (tableMetaInfo.columns.size() > 1) {
                responseWriter.writeAttribute("colspan", (Object)String.valueOf(tableMetaInfo.columns.size()), null);
            }
            responseWriter.writeAttribute("scope", (Object)"colgroup", null);
            this.encodeRecursive(facesContext, uIComponent2);
            responseWriter.endElement("th");
            this.renderRowEnd(facesContext, uIComponent, responseWriter);
        }
        if (tableMetaInfo.hasHeaderFacets) {
            responseWriter.startElement("tr", uIComponent);
            responseWriter.writeText((Object)"\n", uIComponent, null);
            for (UIColumn uIColumn : tableMetaInfo.columns) {
                String string2 = (String)uIColumn.getAttributes().get("headerClass");
                responseWriter.startElement("th", (UIComponent)uIColumn);
                if (string2 != null) {
                    responseWriter.writeAttribute("class", (Object)string2, "columnHeaderClass");
                } else if (string != null) {
                    responseWriter.writeAttribute("class", (Object)string, "headerClass");
                }
                responseWriter.writeAttribute("scope", (Object)"col", null);
                UIComponent uIComponent3 = this.getFacet((UIComponent)uIColumn, "header");
                if (uIComponent3 != null) {
                    this.encodeRecursive(facesContext, uIComponent3);
                }
                responseWriter.endElement("th");
                responseWriter.writeText((Object)"\n", uIComponent, null);
            }
            this.renderRowEnd(facesContext, uIComponent, responseWriter);
        }
        responseWriter.endElement("thead");
        responseWriter.writeText((Object)"\n", uIComponent, null);
    }

    @Override
    protected void renderRow(FacesContext facesContext, UIComponent uIComponent, UIComponent uIComponent2, ResponseWriter responseWriter) throws IOException {
        BaseTableRenderer.TableMetaInfo tableMetaInfo = this.getMetaInfo(facesContext, uIComponent);
        tableMetaInfo.newRow();
        for (UIColumn uIColumn : tableMetaInfo.columns) {
            boolean bl = false;
            Object v = uIColumn.getAttributes().get("rowHeader");
            if (null != v) {
                bl = Boolean.valueOf(v.toString());
            }
            if (bl) {
                responseWriter.startElement("th", (UIComponent)uIColumn);
                responseWriter.writeAttribute("scope", (Object)"row", null);
            } else {
                responseWriter.startElement("td", (UIComponent)uIColumn);
            }
            String string = tableMetaInfo.getCurrentColumnClass();
            if (string != null) {
                responseWriter.writeAttribute("class", (Object)string, "columnClasses");
            }
            Iterator<UIComponent> iterator = this.getChildren((UIComponent)uIColumn);
            while (iterator.hasNext()) {
                this.encodeRecursive(facesContext, iterator.next());
            }
            if (bl) {
                responseWriter.endElement("th");
            } else {
                responseWriter.endElement("td");
            }
            responseWriter.writeText((Object)"\n", uIComponent, null);
        }
    }

    private void renderEmptyTableBody(ResponseWriter responseWriter, UIComponent uIComponent) throws IOException {
        responseWriter.startElement("tbody", uIComponent);
        this.renderEmptyTableRow(responseWriter, uIComponent);
        responseWriter.endElement("tbody");
    }

    private void renderEmptyTableRow(ResponseWriter responseWriter, UIComponent uIComponent) throws IOException {
        responseWriter.startElement("tr", uIComponent);
        List<UIColumn> list = this.getColumns(uIComponent);
        for (UIColumn uIColumn : list) {
            if (!uIColumn.isRendered()) continue;
            responseWriter.startElement("td", uIComponent);
            responseWriter.endElement("td");
        }
        responseWriter.endElement("tr");
    }

    private List<UIColumn> getColumns(UIComponent uIComponent) {
        int n = uIComponent.getChildCount();
        if (n > 0) {
            ArrayList<UIColumn> arrayList = new ArrayList<UIColumn>(n);
            for (UIComponent uIComponent2 : uIComponent.getChildren()) {
                if (!(uIComponent2 instanceof UIColumn) || !uIComponent2.isRendered()) continue;
                arrayList.add((UIColumn)uIComponent2);
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

