/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.util.FacesLogger;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.faces.FacesException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.xml.bind.DatatypeConverter;

public final class ByteArrayGuardAESCTR {
    private static final Logger LOGGER = FacesLogger.RENDERKIT.getLogger();
    private static final int KEY_LENGTH = 128;
    private static final int IV_LENGTH = 16;
    private static final String KEY_ALGORITHM = "AES";
    private static final String CIPHER_CODE = "AES/CTR/NoPadding";
    private SecretKey sk;
    private IvParameterSpec ivspec;
    private Charset utf8;

    public ByteArrayGuardAESCTR() {
        try {
            this.setupKeyAndCharset();
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", exception);
            }
            System.err.println("ERROR: Initializing Ciphers");
        }
    }

    public String encrypt(String string) {
        String string2 = null;
        byte[] byArray = string.getBytes(this.utf8);
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_CODE);
            cipher.init(1, (Key)this.sk, this.ivspec);
            byte[] byArray2 = cipher.doFinal(byArray);
            string2 = DatatypeConverter.printBase64Binary((byte[])byArray2);
        }
        catch (Exception exception) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unexpected exception initializing encryption.  No encryption will be performed.", exception);
            }
            return null;
        }
        return string2;
    }

    public String decrypt(String string) throws InvalidKeyException {
        byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
        try {
            byte[] byArray2;
            Cipher cipher = Cipher.getInstance(CIPHER_CODE);
            cipher.init(2, (Key)this.sk, this.ivspec);
            for (byte by : byArray2 = cipher.doFinal(byArray)) {
                if (by >= 0 && by <= 127) continue;
                throw new InvalidKeyException("Invalid characters in decrypted value");
            }
            return new String(byArray2, this.utf8);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new InvalidKeyException(noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException);
        }
    }

    private void setupKeyAndCharset() {
        byte[] byArray;
        Object object;
        Object object2;
        try {
            object2 = new InitialContext();
            object = (String)((InitialContext)object2).lookup("java:comp/env/jsf/FlashSecretKey");
            if (null != object) {
                byArray = DatatypeConverter.parseBase64Binary((String)object);
                if (byArray.length < 17) {
                    throw new FacesException("key must be at least 16 bytes long.");
                }
                this.sk = new SecretKeySpec(byArray, KEY_ALGORITHM);
                byte[] byArray2 = new byte[16];
                System.arraycopy(byArray, 0, byArray2, 0, 16);
                this.ivspec = new IvParameterSpec(byArray2);
            }
        }
        catch (NamingException namingException) {
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.log(Level.FINEST, "Unable to find the encoded key.", namingException);
            }
        }
        catch (Exception exception) {
            throw new FacesException((Throwable)exception);
        }
        if (null == this.sk) {
            try {
                object2 = KeyGenerator.getInstance(KEY_ALGORITHM);
                ((KeyGenerator)object2).init(128);
                this.sk = ((KeyGenerator)object2).generateKey();
                object = new SecureRandom();
                byArray = new byte[16];
                ((SecureRandom)object).nextBytes(byArray);
                this.ivspec = new IvParameterSpec(byArray);
            }
            catch (Exception exception) {
                throw new FacesException((Throwable)exception);
            }
        }
        if ((object2 = Charset.availableCharsets()).containsKey("UTF-8")) {
            this.utf8 = (Charset)object2.get("UTF-8");
        } else if (object2.containsKey("UTF8")) {
            this.utf8 = (Charset)object2.get("UTF8");
        } else {
            throw new FacesException("Unable to get UTF-8 Charset.");
        }
    }
}

