/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mojarra.action;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.mojarra.action.ActionMapping;
import org.eclipse.mojarra.action.ActionMappingMatch;
import org.eclipse.mojarra.action.ActionMappingMatcher;
import org.eclipse.mojarra.action.ActionMappingType;

@ApplicationScoped
public class DefaultActionMappingMatcher
implements ActionMappingMatcher {
    private ActionMappingMatch determineActionMappingMatch(FacesContext facesContext, Bean<?> bean) {
        ActionMappingMatch result = null;
        Class clazz = bean.getBeanClass();
        AnnotatedType annotatedType = CDI.current().getBeanManager().createAnnotatedType(clazz);
        Set annotatedMethodSet = annotatedType.getMethods();
        for (AnnotatedMethod method : annotatedMethodSet) {
            block6: {
                String pathInfo;
                String mapping;
                block7: {
                    block8: {
                        if (!method.isAnnotationPresent(ActionMapping.class)) break block6;
                        ActionMapping requestMapping = (ActionMapping)method.getAnnotation(ActionMapping.class);
                        mapping = requestMapping.value();
                        pathInfo = facesContext.getExternalContext().getRequestPathInfo();
                        if (pathInfo == null) break block6;
                        if (pathInfo.equals(mapping)) {
                            result = new ActionMappingMatch();
                            result.setBean(bean);
                            result.setMethod(method.getJavaMember());
                            result.setActionMapping(mapping);
                            result.setMappingType(ActionMappingType.EXACT);
                            result.setPathInfo(pathInfo);
                            break;
                        }
                        if (!mapping.endsWith("*")) break block7;
                        if (!pathInfo.startsWith(mapping = mapping.substring(0, mapping.length() - 1))) break block6;
                        if (result != null) break block8;
                        result = new ActionMappingMatch();
                        result.setBean(bean);
                        result.setMethod(method.getJavaMember());
                        result.setActionMapping(mapping);
                        result.setMappingType(ActionMappingType.PREFIX);
                        result.setPathInfo(pathInfo);
                        break block6;
                    }
                    if (mapping.length() <= result.getLength()) break block6;
                    result.setBean(bean);
                    result.setMethod(method.getJavaMember());
                    result.setActionMapping(mapping);
                    result.setMappingType(ActionMappingType.PREFIX);
                    result.setPathInfo(pathInfo);
                    break block6;
                }
                if (mapping.startsWith("*")) {
                    if (pathInfo.endsWith(mapping = mapping.substring(1))) {
                        result = new ActionMappingMatch();
                        result.setBean(bean);
                        result.setMethod(method.getJavaMember());
                        result.setActionMapping(mapping);
                        result.setMappingType(ActionMappingType.EXTENSION);
                        result.setPathInfo(pathInfo);
                        break;
                    }
                } else if (mapping.startsWith("regex:") && Pattern.matches(mapping = mapping.substring("regex:".length()), pathInfo)) {
                    result = new ActionMappingMatch();
                    result.setBean(bean);
                    result.setMethod(method.getJavaMember());
                    result.setActionMapping(mapping);
                    result.setMappingType(ActionMappingType.REGEX);
                    result.setPathInfo(pathInfo);
                    break;
                }
            }
            if (result == null || !result.getMappingType().equals((Object)ActionMappingType.EXACT) && !result.getMappingType().equals((Object)ActionMappingType.EXTENSION)) continue;
            break;
        }
        return result;
    }

    private Iterator<Bean<?>> getBeans() {
        Set beans = CDI.current().getBeanManager().getBeans(Object.class, new Annotation[]{Any.Literal.INSTANCE});
        return beans.iterator();
    }

    @Override
    public ActionMappingMatch match(FacesContext facesContext) {
        ActionMappingMatch match = null;
        Iterator<Bean<?>> beans = this.getBeans();
        while (beans.hasNext()) {
            Bean<?> bean = beans.next();
            ActionMappingMatch candidate = this.determineActionMappingMatch(facesContext, bean);
            if (match == null) {
                match = candidate;
                continue;
            }
            if (candidate == null || candidate.getLength() <= match.getLength()) continue;
            match = candidate;
        }
        return match;
    }
}

