/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.Japex;
import com.sun.japex.JapexClassLoader;
import com.sun.japex.JapexException;
import com.sun.japex.XmlConfigurationWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.configuration.PlexusConfiguration;

public class JapexMojo
extends AbstractMojo {
    private File reportDirectory;
    private PlexusConfiguration japexConfig;
    private File[] japexConfigFiles;
    private boolean html;
    private boolean verbose;
    private boolean silent;
    private MavenProject project;
    private ArtifactRepository localRepository;

    public void execute() throws MojoExecutionException {
        URL[] testClasspathUrls;
        StringWriter japexOutput = new StringWriter();
        PrintWriter printWriter = new PrintWriter(japexOutput);
        Japex japex = new Japex();
        japex.setOutputWriter(printWriter);
        japex.setHtml(this.html);
        Japex.silent = this.silent;
        Japex.verbose = this.verbose;
        japex.setOutputDirectory(this.reportDirectory);
        try {
            List pathlist = this.project.getTestClasspathElements();
            testClasspathUrls = new URL[pathlist.size()];
            for (int x = 0; x < pathlist.size(); ++x) {
                String path = (String)pathlist.get(x);
                this.getLog().debug((CharSequence)("test classpath entry: " + path));
                testClasspathUrls[x] = new File(path).toURI().toURL();
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error resolving test classpath", (Exception)((Object)e));
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Error in URL from test classpath", (Exception)e);
        }
        JapexClassLoader classLoader = new JapexClassLoader(testClasspathUrls);
        japex.getNamedClasspaths().put("maven.test.classpath", classLoader);
        if (this.japexConfig != null) {
            File configFile;
            StringWriter writer = new StringWriter();
            XmlConfigurationWriter xmlWriter = new XmlConfigurationWriter();
            xmlWriter.setLocalRepositoryPathname(this.localRepository.getBasedir());
            try {
                xmlWriter.write(this.japexConfig, writer);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write config to temp string", (Exception)e);
            }
            catch (XMLStreamException e) {
                throw new MojoExecutionException("Failed to write config to temp string", (Exception)e);
            }
            String config = writer.toString();
            try {
                configFile = File.createTempFile("japex", ".xml");
                FileUtils.writeStringToFile((File)configFile, (String)config, (String)"utf-8");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to write config to temp file", (Exception)e);
            }
            this.japexConfigFiles = new File[]{configFile};
        }
        if (this.japexConfigFiles == null || this.japexConfigFiles.length == 0) {
            this.getLog().info((CharSequence)"No japex config files and no inline japexConfig; skipping");
            return;
        }
        ArrayList<String> configFileStrings = new ArrayList<String>();
        for (int x = 0; x < this.japexConfigFiles.length; ++x) {
            configFileStrings.add(this.japexConfigFiles[x].getAbsolutePath());
        }
        try {
            japex.run(configFileStrings);
        }
        catch (JapexException je) {
            printWriter.close();
            this.getLog().error((CharSequence)"Error running driver", (Throwable)je);
            this.getLog().error((CharSequence)japexOutput.toString());
            return;
        }
        printWriter.close();
        this.getLog().info((CharSequence)japexOutput.toString());
    }
}

