/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex;

import com.sun.japex.JapexException;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.codehaus.plexus.configuration.PlexusConfiguration;

class XmlConfigurationWriter {
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private String localRepositoryPathname;

    XmlConfigurationWriter() {
    }

    private String fixValue(String value) {
        return value.replaceAll("\\$\\{settings.localRepository\\}", this.localRepositoryPathname);
    }

    public void write(PlexusConfiguration configuration, Writer writer) throws IOException, XMLStreamException {
        XMLStreamWriter staxWriter = xmlOutputFactory.createXMLStreamWriter(writer);
        staxWriter.writeStartDocument();
        if (configuration.getChildCount() != 1) {
            throw new JapexException("There must be one <testSuite/> child element of japexConfig");
        }
        PlexusConfiguration suiteConfig = configuration.getChild(0);
        this.write(suiteConfig, staxWriter, 0);
        staxWriter.writeEndDocument();
    }

    private void write(PlexusConfiguration c, XMLStreamWriter w, int depth) throws IOException, XMLStreamException {
        int count = c.getChildCount();
        if (count == 0) {
            this.writeTag(c, w, depth);
        } else {
            w.writeStartElement(c.getName());
            this.writeAttributes(c, w);
            for (int i = 0; i < count; ++i) {
                PlexusConfiguration child = c.getChild(i);
                this.write(child, w, depth + 1);
            }
            w.writeEndElement();
        }
    }

    private void writeTag(PlexusConfiguration c, XMLStreamWriter w, int depth) throws IOException, XMLStreamException {
        w.writeStartElement(c.getName());
        this.writeAttributes(c, w);
        String value = c.getValue(null);
        if (value != null) {
            w.writeCharacters(this.fixValue(value));
        }
        w.writeEndElement();
    }

    private void writeAttributes(PlexusConfiguration c, XMLStreamWriter w) throws IOException, XMLStreamException {
        String[] names = c.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            w.writeAttribute(names[i], this.fixValue(c.getAttribute(names[i], null)));
        }
    }

    public void setLocalRepositoryPathname(String localRepositoryPathname) {
        this.localRepositoryPathname = localRepositoryPathname;
    }

    public String getLocalRepositoryPathname() {
        return this.localRepositoryPathname;
    }
}

