/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.verifier.structurals;

import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.ATHROW;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.CodeExceptionGen;
import com.sun.org.apache.bcel.internal.generic.GotoInstruction;
import com.sun.org.apache.bcel.internal.generic.IndexedInstruction;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.JsrInstruction;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.RET;
import com.sun.org.apache.bcel.internal.generic.ReturnInstruction;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.verifier.exc.AssertionViolatedException;
import com.sun.org.apache.bcel.internal.verifier.exc.StructuralCodeConstraintException;
import com.sun.org.apache.bcel.internal.verifier.structurals.Subroutine;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;

public class Subroutines {
    private Hashtable subroutines = new Hashtable();
    public final Subroutine TOPLEVEL;

    public Subroutines(MethodGen mg) {
        InstructionHandle[] all = mg.getInstructionList().getInstructionHandles();
        CodeExceptionGen[] handlers = mg.getExceptionHandlers();
        this.TOPLEVEL = new SubroutineImpl();
        HashSet<InstructionHandle> sub_leaders = new HashSet<InstructionHandle>();
        InstructionHandle ih = all[0];
        for (int i = 0; i < all.length; ++i) {
            Instruction inst = all[i].getInstruction();
            if (!(inst instanceof JsrInstruction)) continue;
            sub_leaders.add(((JsrInstruction)inst).getTarget());
        }
        Iterator iter = sub_leaders.iterator();
        while (iter.hasNext()) {
            SubroutineImpl sr = new SubroutineImpl();
            InstructionHandle astore = (InstructionHandle)iter.next();
            sr.setLocalVariable(((ASTORE)astore.getInstruction()).getIndex());
            this.subroutines.put(astore, sr);
        }
        this.subroutines.put(all[0], this.TOPLEVEL);
        sub_leaders.add(all[0]);
        for (int i = 0; i < all.length; ++i) {
            Instruction inst = all[i].getInstruction();
            if (!(inst instanceof JsrInstruction)) continue;
            InstructionHandle leader = ((JsrInstruction)inst).getTarget();
            ((SubroutineImpl)this.getSubroutine(leader)).addEnteringJsrInstruction(all[i]);
        }
        HashSet<InstructionHandle> instructions_assigned = new HashSet<InstructionHandle>();
        Hashtable<InstructionHandle, Color> colors = new Hashtable<InstructionHandle, Color>();
        for (InstructionHandle actual : sub_leaders) {
            for (int i = 0; i < all.length; ++i) {
                colors.put(all[i], Color.white);
            }
            colors.put(actual, Color.gray);
            ArrayList<InstructionHandle> Q = new ArrayList<InstructionHandle>();
            Q.add(actual);
            if (actual == all[0]) {
                for (int j = 0; j < handlers.length; ++j) {
                    colors.put(handlers[j].getHandlerPC(), Color.gray);
                    Q.add(handlers[j].getHandlerPC());
                }
            }
            while (Q.size() != 0) {
                InstructionHandle u = (InstructionHandle)Q.remove(0);
                InstructionHandle[] successors = Subroutines.getSuccessors(u);
                for (int i = 0; i < successors.length; ++i) {
                    if ((Color)colors.get(successors[i]) != Color.white) continue;
                    colors.put(successors[i], Color.gray);
                    Q.add(successors[i]);
                }
                colors.put(u, Color.black);
            }
            for (int i = 0; i < all.length; ++i) {
                if (colors.get(all[i]) != Color.black) continue;
                ((SubroutineImpl)(actual == all[0] ? this.getTopLevel() : this.getSubroutine(actual))).addInstruction(all[i]);
                if (instructions_assigned.contains(all[i])) {
                    throw new StructuralCodeConstraintException("Instruction '" + all[i] + "' is part of more than one subroutine (or of the top level and a subroutine).");
                }
                instructions_assigned.add(all[i]);
            }
            if (actual == all[0]) continue;
            ((SubroutineImpl)this.getSubroutine(actual)).setLeavingRET();
        }
        for (int i = 0; i < handlers.length; ++i) {
            for (InstructionHandle _protected = handlers[i].getStartPC(); _protected != handlers[i].getEndPC().getNext(); _protected = _protected.getNext()) {
                Enumeration subs = this.subroutines.elements();
                while (subs.hasMoreElements()) {
                    Subroutine sub = (Subroutine)subs.nextElement();
                    if (sub == this.subroutines.get(all[0]) || !sub.contains(_protected)) continue;
                    throw new StructuralCodeConstraintException("Subroutine instruction '" + _protected + "' is protected by an exception handler, '" + handlers[i] + "'. This is forbidden by the JustIce verifier due to its clear definition of subroutines.");
                }
            }
        }
        this.noRecursiveCalls(this.getTopLevel(), new HashSet());
    }

    private void noRecursiveCalls(Subroutine sub, HashSet set) {
        Subroutine[] subs = sub.subSubs();
        for (int i = 0; i < subs.length; ++i) {
            int index = ((RET)subs[i].getLeavingRET().getInstruction()).getIndex();
            if (!set.add(new Integer(index))) {
                SubroutineImpl si = (SubroutineImpl)subs[i];
                throw new StructuralCodeConstraintException("Subroutine with local variable '" + si.localVariable + "', JSRs '" + si.theJSRs + "', RET '" + si.theRET + "' is called by a subroutine which uses the same local variable index as itself; maybe even a recursive call? JustIce's clean definition of a subroutine forbids both.");
            }
            this.noRecursiveCalls(subs[i], set);
            set.remove(new Integer(index));
        }
    }

    public Subroutine getSubroutine(InstructionHandle leader) {
        Subroutine ret = (Subroutine)this.subroutines.get(leader);
        if (ret == null) {
            throw new AssertionViolatedException("Subroutine requested for an InstructionHandle that is not a leader of a subroutine.");
        }
        if (ret == this.TOPLEVEL) {
            throw new AssertionViolatedException("TOPLEVEL special subroutine requested; use getTopLevel().");
        }
        return ret;
    }

    public Subroutine subroutineOf(InstructionHandle any) {
        for (Subroutine s : this.subroutines.values()) {
            if (!s.contains(any)) continue;
            return s;
        }
        System.err.println("DEBUG: Please verify '" + any + "' lies in dead code.");
        return null;
    }

    public Subroutine getTopLevel() {
        return this.TOPLEVEL;
    }

    private static InstructionHandle[] getSuccessors(InstructionHandle instruction) {
        InstructionHandle[] empty = new InstructionHandle[]{};
        InstructionHandle[] single = new InstructionHandle[1];
        InstructionHandle[] pair = new InstructionHandle[2];
        Instruction inst = instruction.getInstruction();
        if (inst instanceof RET) {
            return empty;
        }
        if (inst instanceof ReturnInstruction) {
            return empty;
        }
        if (inst instanceof ATHROW) {
            return empty;
        }
        if (inst instanceof JsrInstruction) {
            single[0] = instruction.getNext();
            return single;
        }
        if (inst instanceof GotoInstruction) {
            single[0] = ((GotoInstruction)inst).getTarget();
            return single;
        }
        if (inst instanceof BranchInstruction) {
            if (inst instanceof Select) {
                InstructionHandle[] matchTargets = ((Select)inst).getTargets();
                InstructionHandle[] ret = new InstructionHandle[matchTargets.length + 1];
                ret[0] = ((Select)inst).getTarget();
                System.arraycopy(matchTargets, 0, ret, 1, matchTargets.length);
                return ret;
            }
            pair[0] = instruction.getNext();
            pair[1] = ((BranchInstruction)inst).getTarget();
            return pair;
        }
        single[0] = instruction.getNext();
        return single;
    }

    public String toString() {
        return "---\n" + this.subroutines.toString() + "\n---\n";
    }

    private class SubroutineImpl
    implements Subroutine {
        private final int UNSET = -1;
        private int localVariable = -1;
        private HashSet instructions = new HashSet();
        private HashSet theJSRs = new HashSet();
        private InstructionHandle theRET;

        @Override
        public boolean contains(InstructionHandle inst) {
            return this.instructions.contains(inst);
        }

        public String toString() {
            int i;
            String ret = "Subroutine: Local variable is '" + this.localVariable + "', JSRs are '" + this.theJSRs + "', RET is '" + this.theRET + "', Instructions: '" + this.instructions.toString() + "'.";
            ret = ret + " Accessed local variable slots: '";
            int[] alv = this.getAccessedLocalsIndices();
            for (i = 0; i < alv.length; ++i) {
                ret = ret + alv[i] + " ";
            }
            ret = ret + "'.";
            ret = ret + " Recursively (via subsub...routines) accessed local variable slots: '";
            alv = this.getRecursivelyAccessedLocalsIndices();
            for (i = 0; i < alv.length; ++i) {
                ret = ret + alv[i] + " ";
            }
            ret = ret + "'.";
            return ret;
        }

        void setLeavingRET() {
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("setLeavingRET() called for top-level 'subroutine' or forgot to set local variable first.");
            }
            Iterator iter = this.instructions.iterator();
            InstructionHandle ret = null;
            while (iter.hasNext()) {
                InstructionHandle actual = (InstructionHandle)iter.next();
                if (!(actual.getInstruction() instanceof RET)) continue;
                if (ret != null) {
                    throw new StructuralCodeConstraintException("Subroutine with more then one RET detected: '" + ret + "' and '" + actual + "'.");
                }
                ret = actual;
            }
            if (ret == null) {
                throw new StructuralCodeConstraintException("Subroutine without a RET detected.");
            }
            if (((RET)ret.getInstruction()).getIndex() != this.localVariable) {
                throw new StructuralCodeConstraintException("Subroutine uses '" + ret + "' which does not match the correct local variable '" + this.localVariable + "'.");
            }
            this.theRET = ret;
        }

        @Override
        public InstructionHandle[] getEnteringJsrInstructions() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            InstructionHandle[] jsrs = new InstructionHandle[this.theJSRs.size()];
            return this.theJSRs.toArray(jsrs);
        }

        public void addEnteringJsrInstruction(InstructionHandle jsrInst) {
            if (jsrInst == null || !(jsrInst.getInstruction() instanceof JsrInstruction)) {
                throw new AssertionViolatedException("Expecting JsrInstruction InstructionHandle.");
            }
            if (this.localVariable == -1) {
                throw new AssertionViolatedException("Set the localVariable first!");
            }
            if (this.localVariable != ((ASTORE)((JsrInstruction)jsrInst.getInstruction()).getTarget().getInstruction()).getIndex()) {
                throw new AssertionViolatedException("Setting a wrong JsrInstruction.");
            }
            this.theJSRs.add(jsrInst);
        }

        @Override
        public InstructionHandle getLeavingRET() {
            if (this == Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("getLeavingRET() called on top level pseudo-subroutine.");
            }
            return this.theRET;
        }

        @Override
        public InstructionHandle[] getInstructions() {
            InstructionHandle[] ret = new InstructionHandle[this.instructions.size()];
            return this.instructions.toArray(ret);
        }

        void addInstruction(InstructionHandle ih) {
            if (this.theRET != null) {
                throw new AssertionViolatedException("All instructions must have been added before invoking setLeavingRET().");
            }
            this.instructions.add(ih);
        }

        @Override
        public int[] getRecursivelyAccessedLocalsIndices() {
            HashSet<Integer> s = new HashSet<Integer>();
            int[] lvs = this.getAccessedLocalsIndices();
            for (int j = 0; j < lvs.length; ++j) {
                s.add(new Integer(lvs[j]));
            }
            this._getRecursivelyAccessedLocalsIndicesHelper(s, this.subSubs());
            int[] ret = new int[s.size()];
            Iterator i = s.iterator();
            int j = -1;
            while (i.hasNext()) {
                ret[++j] = (Integer)i.next();
            }
            return ret;
        }

        private void _getRecursivelyAccessedLocalsIndicesHelper(HashSet s, Subroutine[] subs) {
            for (int i = 0; i < subs.length; ++i) {
                int[] lvs = subs[i].getAccessedLocalsIndices();
                for (int j = 0; j < lvs.length; ++j) {
                    s.add(new Integer(lvs[j]));
                }
                if (subs[i].subSubs().length == 0) continue;
                this._getRecursivelyAccessedLocalsIndicesHelper(s, subs[i].subSubs());
            }
        }

        @Override
        public int[] getAccessedLocalsIndices() {
            HashSet<Integer> acc = new HashSet<Integer>();
            if (this.theRET == null && this != Subroutines.this.TOPLEVEL) {
                throw new AssertionViolatedException("This subroutine object must be built up completely before calculating accessed locals.");
            }
            for (InstructionHandle ih : this.instructions) {
                if (!(ih.getInstruction() instanceof LocalVariableInstruction) && !(ih.getInstruction() instanceof RET)) continue;
                int idx = ((IndexedInstruction)((Object)ih.getInstruction())).getIndex();
                acc.add(new Integer(idx));
                try {
                    int s;
                    if (!(ih.getInstruction() instanceof LocalVariableInstruction) || (s = ((LocalVariableInstruction)ih.getInstruction()).getType(null).getSize()) != 2) continue;
                    acc.add(new Integer(idx + 1));
                }
                catch (RuntimeException re) {
                    throw new AssertionViolatedException("Oops. BCEL did not like NULL as a ConstantPoolGen object.");
                }
            }
            int[] ret = new int[acc.size()];
            Iterator i = acc.iterator();
            int j = -1;
            while (i.hasNext()) {
                ret[++j] = (Integer)i.next();
            }
            return ret;
        }

        @Override
        public Subroutine[] subSubs() {
            HashSet<Subroutine> h = new HashSet<Subroutine>();
            Iterator i = this.instructions.iterator();
            while (i.hasNext()) {
                Instruction inst = ((InstructionHandle)i.next()).getInstruction();
                if (!(inst instanceof JsrInstruction)) continue;
                InstructionHandle targ = ((JsrInstruction)inst).getTarget();
                h.add(Subroutines.this.getSubroutine(targ));
            }
            Subroutine[] ret = new Subroutine[h.size()];
            return h.toArray(ret);
        }

        void setLocalVariable(int i) {
            if (this.localVariable != -1) {
                throw new AssertionViolatedException("localVariable set twice.");
            }
            this.localVariable = i;
        }
    }
}

