/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.local;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.pipe.ContentType;
import com.sun.xml.ws.api.pipe.Fiber;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractTubeImpl;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.transport.http.HttpAdapter;
import com.sun.xml.ws.transport.http.WSHTTPConnection;
import com.sun.xml.ws.transport.local.ClosedCallback;
import com.sun.xml.ws.transport.local.LocalConnectionImpl;
import com.sun.xml.ws.transport.local.LocalTransportTube;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalAsyncTransportTube
extends AbstractTubeImpl {
    private final HttpAdapter adapter;
    private final Codec codec;
    private final URI baseURI;
    private final Map<String, List<String>> reqHeaders = new HashMap<String, List<String>>();
    private static final boolean dump;
    private static final boolean async;

    public LocalAsyncTransportTube(URI baseURI, WSEndpoint endpoint, Codec codec) {
        this(baseURI, HttpAdapter.createAlone((WSEndpoint)endpoint), codec);
    }

    private LocalAsyncTransportTube(URI baseURI, HttpAdapter adapter, Codec codec) {
        this.adapter = adapter;
        this.codec = codec;
        this.baseURI = baseURI;
        assert (codec != null && adapter != null);
    }

    private LocalAsyncTransportTube(LocalAsyncTransportTube that, TubeCloner cloner) {
        this(that.baseURI, that.adapter, that.codec.copy());
        cloner.add((Tube)that, (Tube)this);
    }

    @NotNull
    public NextAction processException(@NotNull Throwable t) {
        return this.doThrow(t);
    }

    private void checkFIConnegIntegrity(ContentNegotiation conneg, String requestContentType, String requestAccept, String responseContentType) {
        String string = requestAccept = requestAccept == null ? "" : requestAccept;
        if (requestContentType.contains("fastinfoset")) {
            if (!responseContentType.contains("fastinfoset")) {
                throw new RuntimeException("Request is encoded using Fast Infoset but response (" + responseContentType + ") is not");
            }
            if (conneg == ContentNegotiation.none) {
                throw new RuntimeException("Request is encoded but Fast Infoset content negotiation is set to none");
            }
        } else if (requestAccept.contains("fastinfoset")) {
            if (!responseContentType.contains("fastinfoset")) {
                throw new RuntimeException("Fast Infoset is acceptable but response is not encoded in Fast Infoset");
            }
            if (conneg == ContentNegotiation.none) {
                throw new RuntimeException("Fast Infoset is acceptable but Fast Infoset content negotiation is set to none");
            }
        } else {
            if (conneg == ContentNegotiation.pessimistic) {
                throw new RuntimeException("Content negotitaion is set to pessimistic but Fast Infoset is not acceptable");
            }
            if (conneg == ContentNegotiation.optimistic) {
                throw new RuntimeException("Content negotitaion is set to optimistic but the request (" + requestContentType + ") is not encoded using Fast Infoset");
            }
        }
    }

    private String getResponseContentType(LocalConnectionImpl con) {
        List<String> c;
        Map<String, List<String>> rsph = con.getResponseHeaders();
        if (rsph != null && (c = rsph.get("Content-Type")) != null && !c.isEmpty()) {
            return c.get(0);
        }
        return null;
    }

    @NotNull
    public NextAction processRequest(@NotNull Packet request) {
        try {
            String requestContentType;
            this.reqHeaders.clear();
            Map rh = (Map)request.invocationProperties.get("javax.xml.ws.http.request.headers");
            if (rh != null) {
                this.reqHeaders.putAll(rh);
            }
            MyClosedCallback callback = new MyClosedCallback(request);
            LocalConnectionImpl con = new LocalConnectionImpl(this.baseURI, this.reqHeaders, callback);
            callback.setConnection(con);
            ContentType contentType = this.codec.getStaticContentType(request);
            if (contentType != null) {
                requestContentType = contentType.getContentType();
                this.codec.encode(request, con.getOutput());
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                contentType = this.codec.encode(request, (OutputStream)baos);
                requestContentType = contentType.getContentType();
                baos.writeTo(con.getOutput());
            }
            callback.setContentType(contentType);
            this.reqHeaders.put("Content-Type", Collections.singletonList(requestContentType));
            String requestAccept = contentType.getAcceptHeader();
            if (contentType.getAcceptHeader() != null) {
                this.reqHeaders.put("Accept", Collections.singletonList(requestAccept));
            }
            if (dump) {
                this.dump(con, "request", this.reqHeaders);
            }
            this.adapter.invokeAsync((WSHTTPConnection)con);
            return this.doSuspend();
        }
        catch (IOException ioe) {
            throw new WebServiceException((Throwable)ioe);
        }
    }

    @NotNull
    public NextAction processResponse(@NotNull Packet response) {
        return this.doReturnWith(response);
    }

    public void preDestroy() {
    }

    public LocalAsyncTransportTube copy(TubeCloner cloner) {
        return new LocalAsyncTransportTube(this, cloner);
    }

    private void dump(LocalConnectionImpl con, String caption, Map<String, List<String>> headers) {
        System.out.println("---[" + caption + "]---");
        if (headers != null) {
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                if (header.getValue().isEmpty()) {
                    System.out.println(header.getValue());
                    continue;
                }
                for (String value : header.getValue()) {
                    System.out.println(header.getKey() + ": " + value);
                }
            }
        }
        System.out.println(con.toString());
        System.out.println("--------------------");
    }

    static {
        boolean b;
        try {
            b = Boolean.getBoolean(LocalTransportTube.class.getName() + ".dump");
        }
        catch (Throwable t) {
            b = false;
        }
        dump = b;
        try {
            b = Boolean.getBoolean(LocalTransportTube.class.getName() + ".async");
        }
        catch (Throwable t) {
            b = false;
        }
        async = b;
    }

    private class MyClosedCallback
    implements ClosedCallback {
        final Fiber fiber;
        LocalConnectionImpl con;
        String requestContentType;
        String requestAccept;
        final Packet request;

        MyClosedCallback(Packet request) {
            this.request = request;
            this.requestContentType = this.requestContentType;
            this.requestAccept = this.requestAccept;
            this.fiber = Fiber.current();
        }

        void setConnection(LocalConnectionImpl con) {
            this.con = con;
        }

        void setContentType(ContentType ct) {
            this.requestContentType = ct.getContentType();
            this.requestAccept = ct.getAcceptHeader();
        }

        public void onClosed() {
            String responseContentType = LocalAsyncTransportTube.this.getResponseContentType(this.con);
            if (this.con.getStatus() == 202) {
                Packet reply = this.request.createClientResponse(null);
                this.fiber.resume(reply);
                return;
            }
            LocalAsyncTransportTube.this.checkFIConnegIntegrity(this.request.contentNegotiation, this.requestContentType, this.requestAccept, responseContentType);
            Packet reply = this.request.createClientResponse(null);
            try {
                LocalAsyncTransportTube.this.codec.decode(this.con.getInput(), responseContentType, reply);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.fiber.resume(reply);
        }
    }
}

