/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Distribution License v. 1.0, which is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

package com.sun.tools.ws.resources;

import java.util.Locale;
import java.util.ResourceBundle;
import com.sun.istack.localization.Localizable;
import com.sun.istack.localization.LocalizableMessageFactory;
import com.sun.istack.localization.LocalizableMessageFactory.ResourceBundleSupplier;
import com.sun.istack.localization.Localizer;


/**
 * Defines string formatting method for each constant in the resource file
 * 
 */
public final class ConfigurationMessages {

    private final static String BUNDLE_NAME = "com.sun.tools.ws.resources.configuration";
    private final static LocalizableMessageFactory MESSAGE_FACTORY = new LocalizableMessageFactory(BUNDLE_NAME, new ConfigurationMessages.BundleSupplier());
    private final static Localizer LOCALIZER = new Localizer();

    public static Localizable localizableCONFIGURATION_NOT_BINDING_FILE(Object arg0) {
        return MESSAGE_FACTORY.getMessage("configuration.notBindingFile", arg0);
    }

    /**
     * Ignoring: binding file "{0}". It is not a jaxws or a jaxb binding file.
     * 
     */
    public static String CONFIGURATION_NOT_BINDING_FILE(Object arg0) {
        return LOCALIZER.localize(localizableCONFIGURATION_NOT_BINDING_FILE(arg0));
    }

    private static class BundleSupplier
        implements ResourceBundleSupplier
    {


        public ResourceBundle getResourceBundle(Locale locale) {
            return ResourceBundle.getBundle(BUNDLE_NAME, locale);
        }

    }

}
