/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.addressing.policy;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import com.sun.xml.ws.policy.jaxws.spi.ModelConfiguratorProvider;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;

public class AddressingModelConfiguratorProvider
implements ModelConfiguratorProvider {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(AddressingModelConfiguratorProvider.class);
    private static final QName[] ADDRESSING_ASSERTIONS = new QName[]{new QName(AddressingVersion.MEMBER.policyNsUri, "UsingAddressing"), new QName(AddressingVersion.W3C.policyNsUri, "UsingAddressing")};

    public void configure(WSDLModel model, PolicyMap policyMap) throws PolicyException {
        LOGGER.entering(model, policyMap);
        if (null == model || null == policyMap) {
            LOGGER.exiting();
            return;
        }
        for (WSDLService service : model.getServices().values()) {
            for (WSDLPort port : service.getPorts()) {
                PolicyMapKey key = PolicyMap.createWsdlEndpointScopeKey(service.getName(), port.getName());
                Policy policy = policyMap.getEndpointEffectivePolicy(key);
                for (QName addressingAssertionQName : ADDRESSING_ASSERTIONS) {
                    if (null == policy || !policy.contains(addressingAssertionQName)) continue;
                    for (AssertionSet assertionSet : policy) {
                        for (PolicyAssertion assertion : assertionSet) {
                            if (!assertion.getName().equals(addressingAssertionQName)) continue;
                            WebServiceFeature feature = AddressingVersion.getFeature((String)addressingAssertionQName.getNamespaceURI(), (boolean)true, (!assertion.isOptional() ? 1 : 0) != 0);
                            port.addFeature(feature);
                            if (!LOGGER.isLoggable(Level.FINE)) continue;
                            LOGGER.fine("Added addressing feature \"" + feature + "\" to port \"" + port + "\"");
                        }
                    }
                }
                if (policy == null || !policy.contains(new QName("http://www.w3.org/2007/05/addressing/metadata", "Addressing"))) continue;
                for (AssertionSet assertions : policy) {
                    for (PolicyAssertion assertion : assertions) {
                        if (!assertion.getName().equals(new QName("http://www.w3.org/2007/05/addressing/metadata", "Addressing"))) continue;
                        AddressingFeature feature = new AddressingFeature(true, !assertion.isOptional());
                        port.addFeature((WebServiceFeature)feature);
                        if (!LOGGER.isLoggable(Level.FINE)) continue;
                        LOGGER.fine("Added addressing feature \"" + feature + "\" to port \"" + port + "\"");
                    }
                }
            }
        }
        LOGGER.exiting();
    }
}

