/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws;

import com.sun.xml.ws.api.ResourceLoader;
import com.sun.xml.ws.api.model.wsdl.WSDLModel;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.api.server.SDDocumentSource;
import com.sun.xml.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.ws.api.wsdl.parser.XMLEntityResolver;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapMutator;
import com.sun.xml.ws.policy.jaxws.PolicyConfigResolver;
import com.sun.xml.ws.policy.jaxws.PolicyWSDLParserExtension;
import com.sun.xml.ws.policy.jaxws.WSDLPolicyMapWrapper;
import com.sun.xml.ws.policy.jaxws.privateutil.LocalizationMessages;
import com.sun.xml.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.ws.policy.privateutil.PolicyUtils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.SAXException;

public final class PolicyConfigParser {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(PolicyConfigParser.class);
    private static final String SERVLET_CONTEXT_CLASSNAME = "javax.servlet.ServletContext";
    private static final String JAR_PREFIX = "META-INF/";
    private static final String WAR_PREFIX = "/WEB-INF/";

    private PolicyConfigParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyMap parse(String configFileIdentifier, Container container, PolicyMapMutator ... mutators) throws PolicyException {
        LOGGER.entering(configFileIdentifier, container, mutators);
        PolicyMap map = null;
        try {
            PolicyMap policyMap = map = PolicyConfigParser.extractPolicyMap(PolicyConfigParser.parseModel(configFileIdentifier, container, mutators));
            LOGGER.exiting(map);
            return policyMap;
        }
        catch (Throwable throwable) {
            LOGGER.exiting(map);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyMap parse(URL configFileUrl, boolean isClient, PolicyMapMutator ... mutators) throws PolicyException, IllegalArgumentException {
        LOGGER.entering(configFileUrl, isClient, mutators);
        PolicyMap map = null;
        try {
            PolicyMap policyMap = map = PolicyConfigParser.extractPolicyMap(PolicyConfigParser.parseModel(configFileUrl, isClient, mutators));
            LOGGER.exiting(map);
            return policyMap;
        }
        catch (Throwable throwable) {
            LOGGER.exiting(map);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolicyMap extractPolicyMap(WSDLModel model) {
        LOGGER.entering(model);
        PolicyMap result = null;
        try {
            WSDLPolicyMapWrapper wrapper;
            if (model != null && (wrapper = (WSDLPolicyMapWrapper)model.getExtension(WSDLPolicyMapWrapper.class)) != null) {
                result = wrapper.getPolicyMap();
            }
            PolicyMap policyMap = result;
            return policyMap;
        }
        finally {
            LOGGER.exiting(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WSDLModel parseModel(String configFileIdentifier, Container container, PolicyMapMutator ... mutators) throws PolicyException {
        LOGGER.entering(configFileIdentifier, container, mutators);
        WSDLModel model = null;
        try {
            String configFileName = PolicyUtils.ConfigFile.generateFullName(configFileIdentifier);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest(LocalizationMessages.WSP_1037_CONFIG_FILE_IS(configFileName));
            }
            String examinedPath = null;
            boolean isClientConfig = "client".equals(configFileIdentifier);
            URL configFileUrl = PolicyConfigParser.loadResource(container, configFileName);
            if (configFileUrl == null && (configFileUrl = PolicyUtils.ConfigFile.loadFromClasspath(examinedPath = JAR_PREFIX + configFileName)) == null && isClientConfig) {
                examinedPath = examinedPath + File.pathSeparator + configFileName;
                configFileUrl = PolicyUtils.ConfigFile.loadFromClasspath(configFileName);
            }
            if (configFileUrl == null) {
                if (LOGGER.isLoggable(Level.CONFIG)) {
                    LOGGER.config(LocalizationMessages.WSP_1035_COULD_NOT_LOCATE_WSIT_CFG_FILE(configFileIdentifier, examinedPath));
                }
            } else {
                model = PolicyConfigParser.parseModel(configFileUrl, isClientConfig, mutators);
                LOGGER.info(LocalizationMessages.WSP_1049_LOADED_WSIT_CFG_FILE(configFileUrl.toExternalForm()));
            }
            WSDLModel wSDLModel = model;
            LOGGER.exiting(model);
            return wSDLModel;
        }
        catch (Throwable throwable) {
            LOGGER.exiting(model);
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static WSDLModel parseModel(URL configFileUrl, boolean isClient, PolicyMapMutator ... mutators) throws PolicyException, IllegalArgumentException {
        LOGGER.entering(configFileUrl, isClient, mutators);
        WSDLModel model = null;
        try {
            if (null == configFileUrl) {
                throw LOGGER.logSevereException(new IllegalArgumentException(LocalizationMessages.WSP_1028_FAILED_TO_READ_NULL_WSIT_CFG()));
            }
            SDDocumentSource doc = SDDocumentSource.create((URL)configFileUrl);
            XMLEntityResolver.Parser parser = new XMLEntityResolver.Parser(doc);
            WSDLModel wSDLModel = model = WSDLModel.WSDLParser.parse((XMLEntityResolver.Parser)parser, (XMLEntityResolver)new PolicyConfigResolver(), (boolean)isClient, (WSDLParserExtension[])new WSDLParserExtension[]{new PolicyWSDLParserExtension(true, mutators)});
            LOGGER.exiting(model);
            return wSDLModel;
        }
        catch (XMLStreamException ex) {
            try {
                throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_1002_WSIT_CFG_FILE_PROCESSING_FAILED(configFileUrl.toString()), ex));
                catch (IOException ex2) {
                    throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_1002_WSIT_CFG_FILE_PROCESSING_FAILED(configFileUrl.toString()), ex2));
                }
                catch (SAXException ex3) {
                    throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_1002_WSIT_CFG_FILE_PROCESSING_FAILED(configFileUrl.toString()), ex3));
                }
            }
            catch (Throwable throwable) {
                LOGGER.exiting(model);
                throw throwable;
            }
        }
    }

    private static URL loadResource(Container container, String resourceName) throws PolicyException {
        Object context;
        URL resource;
        block10: {
            LOGGER.entering(container, resourceName);
            resource = null;
            if (container == null) {
                LOGGER.exiting(resource);
                return resource;
            }
            ResourceLoader loader = (ResourceLoader)container.getSPI(ResourceLoader.class);
            if (loader != null) {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(LocalizationMessages.WSP_1053_RESOURCE_FROM_LOADER(resourceName, loader));
                    }
                    resource = loader.getResource(resourceName);
                }
                catch (MalformedURLException e) {
                    throw LOGGER.logSevereException(new PolicyException(LocalizationMessages.WSP_1054_FAILED_RESOURCE_FROM_LOADER(resourceName, loader), e));
                }
            }
            context = null;
            try {
                Class<?> contextClass = Class.forName(SERVLET_CONTEXT_CLASSNAME);
                context = container.getSPI(contextClass);
                if (context != null) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(LocalizationMessages.WSP_1055_RESOURCE_FROM_CONTEXT(resourceName, context));
                    }
                    resource = PolicyUtils.ConfigFile.loadFromContext(WAR_PREFIX + resourceName, context);
                }
            }
            catch (ClassNotFoundException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block10;
                LOGGER.fine(LocalizationMessages.WSP_1043_CAN_NOT_FIND_CLASS(SERVLET_CONTEXT_CLASSNAME));
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(LocalizationMessages.WSP_1036_CONTEXT_IS(context));
        }
        LOGGER.exiting(resource);
        return resource;
    }
}

