/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rm.jaxws.runtime.client;

import com.sun.xml.ws.rm.RmException;
import com.sun.xml.ws.rm.jaxws.runtime.client.RMSource;
import com.sun.xml.ws.rm.localization.RmLogger;
import java.util.Timer;
import java.util.TimerTask;

public class RetryTimer {
    private static final RmLogger LOGGER = RmLogger.getLogger(RetryTimer.class);
    private static final long DELAY = 2000L;
    private static final long PERIOD = 2000L;
    private final RMSource source;
    private Timer timer;

    public RetryTimer(RMSource source) {
        this.source = source;
    }

    public void start() {
        if (this.timer != null) {
            throw LOGGER.logSevereException(new IllegalStateException("RetryTimer is already running!"));
        }
        this.timer = new Timer(true);
        this.timer.schedule((TimerTask)new RetryTask(), 2000L, 2000L);
    }

    public void stop() {
        if (this.timer == null) {
            throw LOGGER.logSevereException(new IllegalStateException("RetryTimer is not running currently!"));
        }
        this.timer.cancel();
        this.timer = null;
    }

    private class RetryTask
    extends TimerTask {
        private RetryTask() {
        }

        public void run() {
            try {
                RetryTimer.this.source.doMaintenanceTasks();
            }
            catch (RmException e) {
                LOGGER.finer("Unexpected exception occured while performing maintenance tasks on RMSource instance", e);
            }
        }
    }
}

