/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.api.addressing.AddressingVersion;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.PolicyModelGenerator;
import com.sun.xml.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.ws.policy.sourcemodel.XmlPolicyModelMarshaller;
import com.sun.xml.ws.security.policy.AlgorithmSuiteValue;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.ws.WebServiceException;
import org.w3c.dom.Document;

public class PolicyUtil {
    public static boolean isSecurityPolicyNS(PolicyAssertion pa, SecurityPolicyVersion spVersion) {
        return spVersion.namespaceUri.equals(pa.getName().getNamespaceURI()) || "http://schemas.microsoft.com/ws/2005/07/securitypolicy".equalsIgnoreCase(pa.getName().getNamespaceURI());
    }

    public static boolean isSunPolicyNS(PolicyAssertion pa) {
        return "http://schemas.sun.com/2006/03/wss/server".equals(pa.getName().getNamespaceURI()) || "http://schemas.sun.com/2006/03/wss/client".equals(pa.getName().getNamespaceURI());
    }

    public static boolean isAddressingNS(PolicyAssertion pa) {
        if (AddressingVersion.MEMBER.getNsUri().equals(pa.getName().getNamespaceURI())) {
            return true;
        }
        return AddressingVersion.W3C.getNsUri().equals(pa.getName().getNamespaceURI());
    }

    public static boolean isTrustNS(PolicyAssertion pa) {
        return "http://schemas.xmlsoap.org/ws/2005/02/trust".equals(pa.getName().getNamespaceURI()) || "http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(pa.getName().getNamespaceURI());
    }

    public static boolean isMEXNS(PolicyAssertion assertion) {
        return "http://schemas.xmlsoap.org/ws/2004/09/mex".equals(assertion.getName().getNamespaceURI());
    }

    public static boolean isUtilityNS(PolicyAssertion pa) {
        return "http://docs.oasis-open.org/wss/2004/01/oasis- 200401-wss-wssecurity-utility-1.0.xsd".equals(pa.getName().getNamespaceURI());
    }

    public static boolean isXpathNS(PolicyAssertion pa) {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116".equals(pa.getName().getNamespaceURI());
    }

    public static boolean isAlgorithmAssertion(PolicyAssertion pa, SecurityPolicyVersion spVersion) {
        return PolicyUtil.isSecurityPolicyNS(pa, spVersion) && pa.getName().getLocalPart().equals("AlgorithmSuite");
    }

    public static boolean isToken(PolicyAssertion pa, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(pa, spVersion)) {
            return false;
        }
        if (pa.getName().getLocalPart().equals("EncryptionToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("SignatureToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("InitiatorToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("HttpsToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("IssuedToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("KerberosToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("ProtectionToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("RecipientToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("SupportingTokens")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("SC10SecurityContextToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("SamlToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("UsernameToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("X509Token")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("SecureConversationToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("TransportToken")) {
            return true;
        }
        if (pa.getName().getLocalPart().equals("RsaToken")) {
            return true;
        }
        return pa.getName().getLocalPart().equals("KeyValueToken");
    }

    public static boolean isBootstrapPolicy(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("BootstrapPolicy");
    }

    public static boolean isTarget(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        String name = assertion.getName().getLocalPart();
        return name.equals("EncryptedParts") || name.equals("SignedParts") || name.equals("SignedElements") || name.equals("EncryptedElements");
    }

    public static boolean isXPath(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("XPath");
    }

    public static boolean isXPathFilter20(PolicyAssertion assertion) {
        if (!PolicyUtil.isXpathNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("XPathFilter20");
    }

    public static boolean isRequiredKey(PolicyAssertion assertion) {
        return false;
    }

    public static boolean isTokenType(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        if (assertion.getName().getLocalPart().equals("WssX509V1Token10")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("WssX509V3Token10")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("WssX509Pkcs7Token10")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("WssX509PkiPathV1Token10")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("WssX509V1Token11")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("WssX509V3Token11")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("WssX509Pkcs7Token11")) {
            return true;
        }
        return assertion.getName().getLocalPart().equals("WssX509PkiPathV1Token11");
    }

    public static boolean isTokenReferenceType(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        if (assertion.getName().getLocalPart().equals("RequireKeyIdentifierReference")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("RequireThumbprintReference")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("RequireEmbeddedTokenReference")) {
            return true;
        }
        return assertion.getName().getLocalPart().equals("RequireIssuerSerialReference");
    }

    public static boolean isUsernameTokenType(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("WssUsernameToken10") || assertion.getName().getLocalPart().equals("WssUsernameToken11");
    }

    public static boolean isHttpsToken(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("HttpsToken");
    }

    public static boolean isSecurityContextToken(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        return token.getName().getLocalPart().equals("SecurityContextToken");
    }

    public static boolean isSecurityContextTokenType(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        String localPart = token.getName().getLocalPart();
        return localPart.equals("SC10SecurityContextToken");
    }

    public static boolean isKerberosToken(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        return token.getName().getLocalPart().equals("KerberosToken");
    }

    public static boolean isKerberosTokenType(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        String localPart = token.getName().getLocalPart();
        if (localPart.equals("WssKerberosV5ApReqToken11")) {
            return true;
        }
        return localPart.equals("WssGssKerberosV5ApReqToken11");
    }

    public static boolean isKeyValueTokenType(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        String localPart = token.getName().getLocalPart();
        return localPart.equals("RsaKeyValue") && SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(spVersion.namespaceUri);
    }

    public static boolean isRelToken(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        return token.getName().getLocalPart().equals("RelToken");
    }

    public static boolean isRelTokenType(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        String localPart = token.getName().getLocalPart();
        if (localPart.equals("WssRelV10Token10")) {
            return true;
        }
        if (localPart.equals("WssRelV10Token11")) {
            return true;
        }
        if (localPart.equals("WssRelV20Token10")) {
            return true;
        }
        return localPart.equals("WssRelV20Token11");
    }

    public static boolean isIncludeTimestamp(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("IncludeTimestamp");
    }

    public static boolean disableTimestampSigning(PolicyAssertion assertion) {
        if (!PolicyUtil.isSunPolicyNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("DisableTimestampSigning");
    }

    public static boolean isEncryptBeforeSign(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("EncryptBeforeSigning");
    }

    public static boolean isSignBeforeEncrypt(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("SignBeforeEncrypting");
    }

    public static boolean isContentOnlyAssertion(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("OnlySignEntireHeadersAndBody");
    }

    public static boolean isMessageLayout(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Layout");
    }

    public static boolean isEncryptParts(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("EncryptedParts");
    }

    public static boolean isEncryptedElements(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("EncryptedElements");
    }

    public static boolean isSignedParts(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("SignedParts");
    }

    public static boolean isSignedElements(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("SignedElements");
    }

    public static boolean isSignedSupportingToken(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        return policyAssertion.getName().getLocalPart().equals("SignedSupportingTokens");
    }

    public static boolean isEndorsedSupportingToken(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        return policyAssertion.getName().getLocalPart().equals("EndorsingSupportingTokens");
    }

    public static boolean isSignedEndorsingSupportingToken(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        return policyAssertion.getName().getLocalPart().equals("SignedEndorsingSupportingTokens");
    }

    public static boolean isSignedEncryptedSupportingToken(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        return policyAssertion.getName().getLocalPart().equals("SignedEncryptedSupportingTokens") && policyAssertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isEncryptedSupportingToken(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        return policyAssertion.getName().getLocalPart().equals("EncryptedSupportingTokens") && policyAssertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isEndorsingEncryptedSupportingToken(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        return policyAssertion.getName().getLocalPart().equals("EndorsingEncryptedSupportingTokens") && policyAssertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isSignedEndorsingEncryptedSupportingToken(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        return policyAssertion.getName().getLocalPart().equals("SignedEndorsingEncryptedSupportingTokens") && policyAssertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isBinding(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        String name = policyAssertion.getName().getLocalPart();
        return name.equals("SymmetricBinding") || name.equals("AsymmetricBinding") || name.equals("TransportBinding");
    }

    public static boolean isUsernameToken(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        return token.getName().getLocalPart().equals("UsernameToken");
    }

    public static boolean isSamlToken(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        return token.getName().getLocalPart().equals("SamlToken");
    }

    public static boolean isSamlTokenType(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        String localPart = token.getName().getLocalPart();
        if (localPart.equals("WssSamlV10Token10")) {
            return true;
        }
        if (localPart.equals("WssSamlV10Token11")) {
            return true;
        }
        if (localPart.equals("WssSamlV11Token10")) {
            return true;
        }
        if (localPart.equals("WssSamlV20Token11")) {
            return true;
        }
        return localPart.equals("WssSamlV11Token11");
    }

    public static boolean isIssuedToken(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        return token.getName().getLocalPart().equals("IssuedToken");
    }

    public static boolean isSecureConversationToken(PolicyAssertion token, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(token, spVersion)) {
            return false;
        }
        return token.getName().getLocalPart().equals("SecureConversationToken");
    }

    public static boolean isX509Token(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        return policyAssertion.getName().getLocalPart().equals("X509Token");
    }

    public static boolean isKeyValueToken(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        return policyAssertion.getName().getLocalPart().equals("KeyValueToken") && SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(spVersion.namespaceUri);
    }

    public static boolean isRsaToken(PolicyAssertion policyAssertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(policyAssertion, spVersion)) {
            return false;
        }
        return policyAssertion.getName().getLocalPart().equals("RsaToken") && SecurityPolicyVersion.MS_SECURITYPOLICY200507.namespaceUri.equals(spVersion.namespaceUri);
    }

    public static boolean isAsymmetricBinding(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("AsymmetricBinding");
    }

    public static boolean isAsymmetricBinding(QName assertion, SecurityPolicyVersion spVersion) {
        return assertion.getLocalPart().equals("AsymmetricBinding") && assertion.getNamespaceURI().equals(spVersion.namespaceUri);
    }

    public static boolean isTransportBinding(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("TransportBinding");
    }

    public static boolean isTransportBinding(QName assertion, SecurityPolicyVersion spVersion) {
        return assertion.getLocalPart().equals("TransportBinding") && assertion.getNamespaceURI().equals(spVersion.namespaceUri);
    }

    public static boolean isSymmetricBinding(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("SymmetricBinding");
    }

    public static boolean isSymmetricBinding(QName assertion, SecurityPolicyVersion spVersion) {
        return assertion.getLocalPart().equals("SymmetricBinding") && assertion.getNamespaceURI().equals(spVersion.namespaceUri);
    }

    public static boolean isSupportingTokens(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return PolicyUtil.isSignedSupportingToken(assertion, spVersion) || PolicyUtil.isEndorsedSupportingToken(assertion, spVersion) || PolicyUtil.isSignedEndorsingSupportingToken(assertion, spVersion) || PolicyUtil.isSupportingToken(assertion, spVersion) || PolicyUtil.isSignedEncryptedSupportingToken(assertion, spVersion) || PolicyUtil.isEncryptedSupportingToken(assertion, spVersion) || PolicyUtil.isEndorsingEncryptedSupportingToken(assertion, spVersion) || PolicyUtil.isSignedEndorsingEncryptedSupportingToken(assertion, spVersion);
    }

    public static boolean isSupportingToken(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("SupportingTokens");
    }

    public static boolean isSupportClientChallenge(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("MustSupportClientChallenge");
    }

    public static boolean isSupportServerChallenge(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("MustSupportServerChallenge");
    }

    public static boolean isWSS10PolicyContent(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        if (assertion.getName().getLocalPart().equals("MustSupportRefKeyIdentifier")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("MustSupportRefIssuerSerial")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("RequireExternalUriReference")) {
            return true;
        }
        return assertion.getName().getLocalPart().equals("RequireEmbeddedTokenReference");
    }

    public static boolean isWSS11PolicyContent(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        if (assertion.getName().getLocalPart().equals("MustSupportRefKeyIdentifier")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("MustSupportRefIssuerSerial")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("MustSupportRefThumbprint")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("MustSupportRefEncryptedKey")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("RequireSignatureConfirmation")) {
            return true;
        }
        if (assertion.getName().getLocalPart().equals("RequireExternalUriReference")) {
            return true;
        }
        return assertion.getName().getLocalPart().equals("RequireEmbeddedTokenReference");
    }

    public static boolean isRequireClientCertificate(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequireClientCertificate") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isHttpBasicAuthentication(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("HttpBasicAuthentication") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isHttpDigestAuthentication(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("HttpDigestAuthentication") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isRequireClientEntropy(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequireClientEntropy");
    }

    public static boolean isRequireServerEntropy(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequireServerEntropy");
    }

    public static boolean isSupportIssuedTokens(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("MustSupportIssuedTokens");
    }

    public static boolean isRequestSecurityTokenCollection(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequireRequestSecurityTokenCollection") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isAppliesTo(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequireAppliesTo") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isIssuer(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Issuer");
    }

    public static boolean isIssuerName(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("IssuerName") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isWSS10(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Wss10");
    }

    public static boolean isWSS11(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Wss11");
    }

    public static boolean isTrust10(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Trust10") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri);
    }

    public static boolean isTrust13(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Trust13") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isMustNotSendCancel(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("MustNotSendCancel") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isMustNotSendRenew(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("MustNotSendRenew") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isBody(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Body");
    }

    public static boolean isAttachments(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Attachments") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isAttachmentCompleteTransform(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("AttachmentCompleteSignatureTransform") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isAttachmentContentTransform(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("ContentSignatureTransform") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static boolean isRequireDerivedKeys(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return "RequireDerivedKeys".toString().equals(assertion.getName().getLocalPart().toString());
    }

    public static AlgorithmSuiteValue isValidAlgorithmSuiteValue(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return null;
        }
        if (assertion.getName().getLocalPart().equals("Basic256")) {
            return AlgorithmSuiteValue.Basic256;
        }
        if (assertion.getName().getLocalPart().equals("Basic192")) {
            return AlgorithmSuiteValue.Basic192;
        }
        if (assertion.getName().getLocalPart().equals("Basic128")) {
            return AlgorithmSuiteValue.Basic128;
        }
        if (assertion.getName().getLocalPart().equals("TripleDes")) {
            return AlgorithmSuiteValue.TripleDes;
        }
        if (assertion.getName().getLocalPart().equals("Basic256Rsa15")) {
            return AlgorithmSuiteValue.Basic256Rsa15;
        }
        if (assertion.getName().getLocalPart().equals("Basic192Rsa15")) {
            return AlgorithmSuiteValue.Basic192Rsa15;
        }
        if (assertion.getName().getLocalPart().equals("Basic128Rsa15")) {
            return AlgorithmSuiteValue.Basic128Rsa15;
        }
        if (assertion.getName().getLocalPart().equals("TripleDesRsa15")) {
            return AlgorithmSuiteValue.TripleDesRsa15;
        }
        if (assertion.getName().getLocalPart().equals("Basic256Sha256")) {
            return AlgorithmSuiteValue.Basic256Sha256;
        }
        if (assertion.getName().getLocalPart().equals("Basic192Sha256")) {
            return AlgorithmSuiteValue.Basic192Sha256;
        }
        if (assertion.getName().getLocalPart().equals("Basic128Sha256")) {
            return AlgorithmSuiteValue.Basic128Sha256;
        }
        if (assertion.getName().getLocalPart().equals("TripleDesSha256")) {
            return AlgorithmSuiteValue.TripleDesSha256;
        }
        if (assertion.getName().getLocalPart().equals("Basic256Sha256Rsa15")) {
            return AlgorithmSuiteValue.Basic256Sha256Rsa15;
        }
        if (assertion.getName().getLocalPart().equals("Basic192Sha256Rsa15")) {
            return AlgorithmSuiteValue.Basic192Sha256Rsa15;
        }
        if (assertion.getName().getLocalPart().equals("Basic128Sha256Rsa15")) {
            return AlgorithmSuiteValue.Basic128Sha256Rsa15;
        }
        if (assertion.getName().getLocalPart().equals("TripleDesSha256Rsa15")) {
            return AlgorithmSuiteValue.TripleDesSha256Rsa15;
        }
        return null;
    }

    public static boolean isInclusiveC14N(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("InclusiveC14N");
    }

    public static boolean isInclusiveC14NWithComments(PolicyAssertion assertion) {
        if (!PolicyUtil.isSunPolicyNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("InclusiveC14NWithComments");
    }

    public static boolean isInclusiveC14NWithCommentsForTransforms(PolicyAssertion assertion) {
        if (!PolicyUtil.isSunPolicyNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("InclusiveC14NWithComments") && "true".equals(assertion.getAttributeValue(new QName("http://schemas.sun.com/2006/03/wss/server", "forTransforms")));
    }

    public static boolean isInclusiveC14NWithCommentsForCm(PolicyAssertion assertion) {
        if (!PolicyUtil.isSunPolicyNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("InclusiveC14NWithComments") && "true".equals(assertion.getAttributeValue(new QName("http://schemas.sun.com/2006/03/wss/server", "forCm")));
    }

    public static boolean isExclusiveC14NWithComments(PolicyAssertion assertion) {
        if (!PolicyUtil.isSunPolicyNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("ExclusiveC14NWithComments");
    }

    public static boolean isExclusiveC14NWithCommentsForTransforms(PolicyAssertion assertion) {
        if (!PolicyUtil.isSunPolicyNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("ExclusiveC14NWithComments") && "true".equals(assertion.getAttributeValue(new QName("http://schemas.sun.com/2006/03/wss/server", "forTransforms")));
    }

    public static boolean isExclusiveC14NWithCommentsForCm(PolicyAssertion assertion) {
        if (!PolicyUtil.isSunPolicyNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("ExclusiveC14NWithComments") && "true".equals(assertion.getAttributeValue(new QName("http://schemas.sun.com/2006/03/wss/server", "forCm")));
    }

    public static boolean isSTRTransform10(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("STRTransform10");
    }

    public static boolean isInitiatorToken(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("InitiatorToken");
    }

    public static boolean isRecipientToken(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RecipientToken");
    }

    public static boolean isProtectTokens(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("ProtectTokens");
    }

    public static boolean isEncryptSignature(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("EncryptSignature");
    }

    public static boolean isCreated(PolicyAssertion assertion) {
        if (!PolicyUtil.isUtilityNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Created");
    }

    public static boolean isExpires(PolicyAssertion assertion) {
        if (!PolicyUtil.isUtilityNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Expires");
    }

    public static boolean isSignatureToken(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("SignatureToken");
    }

    public static boolean isEncryptionToken(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("EncryptionToken");
    }

    public static boolean isProtectionToken(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("ProtectionToken");
    }

    public static boolean isAddress(PolicyAssertion assertion) {
        if (!PolicyUtil.isAddressingNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Address");
    }

    public static boolean isAddressingMetadata(PolicyAssertion assertion) {
        if (!PolicyUtil.isAddressingNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Metadata");
    }

    public static boolean isMetadata(PolicyAssertion assertion) {
        if (!PolicyUtil.isMEXNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Metadata");
    }

    public static boolean isMetadataSection(PolicyAssertion assertion) {
        if (!PolicyUtil.isMEXNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("MetadataSection");
    }

    public static boolean isMetadataReference(PolicyAssertion assertion) {
        if (!PolicyUtil.isMEXNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("MetadataReference");
    }

    public static boolean isRequestSecurityTokenTemplate(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequestSecurityTokenTemplate");
    }

    public static boolean isRequireExternalUriReference(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequireExternalUriReference");
    }

    public static boolean isRequireExternalReference(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequireExternalReference");
    }

    public static boolean isRequireInternalReference(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequireInternalReference");
    }

    public static boolean isEndpointReference(PolicyAssertion assertion) {
        if (!PolicyUtil.isAddressingNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("EndpointReference");
    }

    public static boolean isLax(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Lax");
    }

    public static boolean isLaxTsFirst(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("LaxTsFirst");
    }

    public static boolean isLaxTsLast(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("LaxTsLast");
    }

    public static boolean isStrict(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Strict");
    }

    public static boolean isKeyType(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("KeyType");
    }

    public static boolean isKeySize(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("KeySize");
    }

    public static boolean isUseKey(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("UseKey");
    }

    public static boolean isEncryption(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Encryption");
    }

    public static boolean isProofEncryption(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("ProofEncryption");
    }

    public static boolean isLifeTime(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Lifetime");
    }

    public static boolean isHeader(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("Header");
    }

    public static boolean isRequireKeyIR(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequireKeyIdentifierReference");
    }

    public static boolean isSignWith(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "SignWith".equals(assertion.getName().getLocalPart());
    }

    public static boolean isEncryptWith(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "EncryptWith".equals(assertion.getName().getLocalPart());
    }

    public static boolean isRequestType(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "RequestType".equals(assertion.getName().getLocalPart());
    }

    public static boolean isSignatureAlgorithm(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "SignatureAlgorithm".equals(assertion.getName().getLocalPart());
    }

    public static boolean isComputedKeyAlgorithm(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "ComputedKeyAlgorithm".equals(assertion.getName().getLocalPart());
    }

    public static boolean isCanonicalizationAlgorithm(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "CanonicalizationAlgorithm".equals(assertion.getName().getLocalPart());
    }

    public static boolean isEncryptionAlgorithm(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "EncryptionAlgorithm".equals(assertion.getName().getLocalPart());
    }

    public static boolean isAuthenticationType(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "AuthenticationType".equals(assertion.getName().getLocalPart());
    }

    public static boolean isKeyWrapAlgorithm(PolicyAssertion assertion) {
        if (!"http://docs.oasis-open.org/ws-sx/ws-trust/200512".equals(assertion.getName().getNamespaceURI())) {
            return false;
        }
        return "KeyWrapAlgorithm".equals(assertion.getName().getLocalPart());
    }

    public static boolean isSC10SecurityContextToken(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("SC10SecurityContextToken");
    }

    public static boolean isConfigPolicyAssertion(PolicyAssertion assertion) {
        String uri = assertion.getName().getNamespaceURI();
        return "http://schemas.sun.com/ws/2006/05/sc/client".equals(uri) || "http://schemas.sun.com/ws/2006/05/trust/client".equals(uri) || "http://schemas.sun.com/ws/2006/05/sc/server".equals(uri) || "http://schemas.sun.com/ws/2006/05/trust/server".equals(uri) || "http://schemas.sun.com/2006/03/wss/client".equals(uri) || "http://schemas.sun.com/2006/03/wss/server".equals(uri);
    }

    public static boolean isTrustTokenType(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "TokenType".equals(assertion.getName().getLocalPart());
    }

    public static boolean isPortType(PolicyAssertion assertion) {
        if (!PolicyUtil.isAddressingNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("PortType");
    }

    public static boolean isReferenceParameters(PolicyAssertion assertion) {
        if (!PolicyUtil.isAddressingNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("ReferenceParameters");
    }

    public static boolean isReferenceProperties(PolicyAssertion assertion) {
        if (!PolicyUtil.isAddressingNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("ReferenceProperties");
    }

    public static boolean isServiceName(PolicyAssertion assertion) {
        if (!PolicyUtil.isAddressingNS(assertion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("ServiceName");
    }

    public static boolean isRequiredElements(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("RequiredElements");
    }

    public static boolean isClaimsElement(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "Claims".equals(assertion.getName().getLocalPart());
    }

    public static boolean isEntropyElement(PolicyAssertion assertion) {
        if (!PolicyUtil.isTrustNS(assertion)) {
            return false;
        }
        return "Entropy".equals(assertion.getName().getLocalPart());
    }

    public static boolean hasPassword(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("NoPassword");
    }

    public static boolean isHashPassword(PolicyAssertion assertion, SecurityPolicyVersion spVersion) {
        if (!PolicyUtil.isSecurityPolicyNS(assertion, spVersion)) {
            return false;
        }
        return assertion.getName().getLocalPart().equals("HashPassword") && assertion.getName().getNamespaceURI().equals(SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri);
    }

    public static String randomUUID() {
        UUID uid = UUID.randomUUID();
        String id = "uuid_" + uid.toString();
        return id;
    }

    public static byte[] policyAssertionToBytes(PolicyAssertion token) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLOutputFactory xof = XMLOutputFactory.newInstance();
            XMLStreamWriter writer = xof.createXMLStreamWriter(baos);
            AssertionSet set = AssertionSet.createAssertionSet(Arrays.asList(token));
            Policy policy = Policy.createPolicy(Arrays.asList(set));
            PolicySourceModel sourceModel = PolicyModelGenerator.getGenerator().translate(policy);
            XmlPolicyModelMarshaller pm = (XmlPolicyModelMarshaller)XmlPolicyModelMarshaller.getXmlMarshaller((boolean)true);
            pm.marshal(sourceModel, (Object)writer);
            writer.close();
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public static Document policyAssertionToDoc(PolicyAssertion token) {
        try {
            byte[] byteArray = PolicyUtil.policyAssertionToBytes(token);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(new ByteArrayInputStream(byteArray));
            return doc;
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
    }

    public static SecurityPolicyVersion getSecurityPolicyVersion(String nsUri) {
        SecurityPolicyVersion spVersion = null;
        if (SecurityPolicyVersion.SECURITYPOLICY200507.namespaceUri.equals(nsUri)) {
            spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
        } else if (SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(nsUri)) {
            spVersion = SecurityPolicyVersion.SECURITYPOLICY12NS;
        } else if (SecurityPolicyVersion.SECURITYPOLICY200512.namespaceUri.equals(nsUri)) {
            spVersion = SecurityPolicyVersion.SECURITYPOLICY200512;
        } else if (SecurityPolicyVersion.MS_SECURITYPOLICY200507.namespaceUri.equals(nsUri)) {
            spVersion = SecurityPolicyVersion.MS_SECURITYPOLICY200507;
        }
        return spVersion;
    }
}

