/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.policy.mls;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.AlgorithmSuite;
import com.sun.xml.wss.impl.MessageLayout;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.WSSAssertion;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionPolicy;
import com.sun.xml.wss.impl.policy.mls.EncryptionTarget;
import com.sun.xml.wss.impl.policy.mls.SignatureConfirmationPolicy;
import com.sun.xml.wss.impl.policy.mls.SignaturePolicy;
import com.sun.xml.wss.impl.policy.mls.SignatureTarget;
import com.sun.xml.wss.impl.policy.mls.Target;
import com.sun.xml.wss.impl.policy.mls.WSSPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessagePolicy
implements SecurityPolicy {
    protected static final Logger log = Logger.getLogger("com.sun.xml.wss.logging.impl.configuration", "com.sun.xml.wss.logging.impl.configuration.LogStrings");
    private ArrayList info;
    private ArrayList optionals;
    private boolean dumpMessages = false;
    private boolean enableDynamicPolicyFlag = false;
    private boolean bsp = false;
    private boolean enableWSS11PolicyFlag = false;
    private boolean enableSignatureConfirmation = false;
    private WSSAssertion wssAssertion;
    private MessageLayout layout = MessageLayout.Lax;
    private boolean onSSL = false;
    private int optimizedType = -1;
    private AlgorithmSuite algoSuite;

    public MessagePolicy() {
        this.info = new ArrayList();
        this.optionals = new ArrayList();
    }

    public int getOptimizedType() throws XWSSecurityException {
        if (this.optimizedType != -1) {
            return this.optimizedType;
        }
        if (this.enableDynamicPolicy()) {
            this.optimizedType = 0;
            return this.optimizedType;
        }
        StringBuffer securityOperation = new StringBuffer();
        securityOperation.append("_BODY");
        StringBuffer tmpBuffer = new StringBuffer("");
        SignatureTarget sigTarget = null;
        EncryptionTarget encTarget = null;
        WSSPolicy policy = null;
        String targetValue = null;
        int secureHeaders = -1;
        int secureAttachments = -1;
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList primaryPolicies = this.getPrimaryPolicies();
        ArrayList secondaryPolicies = this.getSecondaryPolicies();
        int size = primaryPolicies.size();
        int secondaryPoliciesSize = secondaryPolicies.size();
        if (size == 0 && secondaryPoliciesSize > 0) {
            this.optimizedType = 4;
            return this.optimizedType;
        }
        int iterator = 0;
        for (iterator = 0; iterator < secondaryPoliciesSize; ++iterator) {
            policy = (WSSPolicy)secondaryPolicies.get(iterator);
            if (policy.getType().intern() != "uri") continue;
            if (PolicyTypeUtil.usernameTokenPolicy(policy)) {
                map.put("UsernameToken", policy.getUUID());
                continue;
            }
            if (PolicyTypeUtil.timestampPolicy(policy)) {
                map.put("Timestamp", policy.getUUID());
                continue;
            }
            if (!PolicyTypeUtil.samlTokenPolicy(policy)) continue;
            map.put("Assertion", policy.getUUID());
        }
        for (iterator = 0; iterator < size; ++iterator) {
            int targetIterator;
            int targetBindingSize;
            WSSPolicy featureBinding;
            policy = (WSSPolicy)primaryPolicies.get(iterator);
            if (PolicyTypeUtil.signaturePolicy(policy)) {
                tmpBuffer.delete(0, tmpBuffer.length());
                featureBinding = (SignaturePolicy.FeatureBinding)policy.getFeatureBinding();
                targetBindingSize = ((SignaturePolicy.FeatureBinding)featureBinding).getTargetBindings().size();
                for (targetIterator = 0; targetIterator < targetBindingSize; ++targetIterator) {
                    SignatureTarget.Transform transform;
                    sigTarget = (SignatureTarget)((SignaturePolicy.FeatureBinding)featureBinding).getTargetBindings().get(targetIterator);
                    if (sigTarget == null) {
                        throw new XWSSecurityException("Signature Target is null.");
                    }
                    if (sigTarget != null && sigTarget.getTransforms().size() > 1) {
                        this.optimizedType = 0;
                        return this.optimizedType;
                    }
                    if (sigTarget.getTransforms().size() == 1 && (transform = (SignatureTarget.Transform)sigTarget.getTransforms().get(0)) != null && transform.getTransform().intern() != "http://www.w3.org/2001/10/xml-exc-c14n#") {
                        this.optimizedType = 0;
                        return this.optimizedType;
                    }
                    if (sigTarget.getType().intern() == "qname") {
                        targetValue = sigTarget.getQName().getLocalPart().intern();
                    } else if (sigTarget.getType().intern() == "uri") {
                        if (map.containsKey(sigTarget.getValue())) {
                            targetValue = map.get(sigTarget.getValue()).toString();
                        } else if (sigTarget.getValue().intern() == "attachmentRef:attachment" || sigTarget.getValue().startsWith("cid:")) {
                            targetValue = "Attachment";
                        }
                    } else if (sigTarget.getType().intern() == "xpath") {
                        this.optimizedType = 0;
                        return this.optimizedType;
                    }
                    if (targetValue == "Body") {
                        if (tmpBuffer.indexOf("_SIGN") != -1) continue;
                        tmpBuffer.append("_SIGN");
                        if (secureHeaders == 1 || secureHeaders == -1) {
                            secureHeaders = 0;
                        }
                        if (secureAttachments != 1 && secureAttachments != -1) continue;
                        secureAttachments = 0;
                        continue;
                    }
                    if (targetValue == "Timestamp" || targetValue == "UsernameToken" || targetValue == "Assertion") {
                        if (secureHeaders != -1) continue;
                        secureHeaders = 1;
                        continue;
                    }
                    if (targetValue == "Attachment") {
                        if (secureAttachments != -1) continue;
                        secureAttachments = 1;
                        continue;
                    }
                    return 0;
                }
                securityOperation.insert(securityOperation.indexOf("_BODY"), tmpBuffer.toString());
                continue;
            }
            if (!PolicyTypeUtil.encryptionPolicy(policy)) continue;
            tmpBuffer.delete(0, tmpBuffer.length());
            featureBinding = (EncryptionPolicy.FeatureBinding)policy.getFeatureBinding();
            targetBindingSize = ((EncryptionPolicy.FeatureBinding)featureBinding).getTargetBindings().size();
            for (targetIterator = 0; targetIterator < targetBindingSize; ++targetIterator) {
                encTarget = (EncryptionTarget)((EncryptionPolicy.FeatureBinding)featureBinding).getTargetBindings().get(targetIterator);
                if (encTarget.getType().intern() == "qname") {
                    targetValue = encTarget.getQName().getLocalPart().intern();
                } else if (encTarget.getType().intern() == "uri") {
                    if (map.containsKey(encTarget.getValue())) {
                        targetValue = map.get(encTarget.getValue()).toString();
                    } else if (encTarget.getValue().intern() == "attachmentRef:attachment" || encTarget.getValue().startsWith("cid:")) {
                        targetValue = "Attachment";
                    }
                } else if (encTarget.getType().intern() == "xpath") {
                    this.optimizedType = 0;
                    return this.optimizedType;
                }
                if (targetValue == "Body") {
                    if (tmpBuffer.indexOf("_ENCRYPT") != -1) continue;
                    tmpBuffer.append("_ENCRYPT");
                    if (secureHeaders == 1 || secureHeaders == -1) {
                        secureHeaders = 0;
                    }
                    if (secureAttachments != 1 && secureAttachments != -1) continue;
                    secureAttachments = 0;
                    continue;
                }
                if (targetValue == "Timestamp" || targetValue == "UsernameToken" || targetValue == "Assertion") {
                    if (secureHeaders != -1) continue;
                    secureHeaders = 1;
                    continue;
                }
                if (targetValue == "Attachment") {
                    if (secureAttachments != -1) continue;
                    secureAttachments = 1;
                    continue;
                }
                return 0;
            }
            securityOperation.insert(securityOperation.indexOf("_BODY"), tmpBuffer.toString());
        }
        if (secureHeaders == 1 && secureAttachments != 1) {
            this.optimizedType = 4;
            return this.optimizedType;
        }
        if (secureAttachments == 1 && secureAttachments != 1) {
            this.optimizedType = 6;
            return this.optimizedType;
        }
        if (secureHeaders == 1 && secureAttachments == 1) {
            this.optimizedType = 7;
            return this.optimizedType;
        }
        String type = securityOperation.toString().intern();
        if (type == "_SIGN_BODY") {
            this.optimizedType = 1;
        } else if (type == "_SIGN_ENCRYPT_BODY") {
            this.optimizedType = 2;
        } else if (type == "_ENCRYPT_SIGN_BODY") {
            this.optimizedType = 0;
        } else if (type == "_ENCRYPT_BODY") {
            this.optimizedType = 0;
        }
        return this.optimizedType;
    }

    public void append(SecurityPolicy item) throws PolicyGenerationException {
        this.info.add(item);
    }

    public void prepend(SecurityPolicy item) throws PolicyGenerationException {
        SecurityPolicy sp;
        int i = 0;
        for (i = 0; i < this.info.size() && (sp = (SecurityPolicy)this.info.get(i)).getType().equals("SignatureConfirmationPolicy"); ++i) {
        }
        this.info.add(i, item);
    }

    public void appendAll(Collection items) throws PolicyGenerationException {
        for (SecurityPolicy securityPolicy : items) {
        }
        this.info.addAll(items);
    }

    public void removeAll() {
        this.info.clear();
    }

    public int size() {
        return this.info.size();
    }

    public SecurityPolicy get(int index) throws Exception {
        if (!this.optionals.isEmpty()) {
            this.addOptionals();
        }
        return (SecurityPolicy)this.info.get(index);
    }

    public Iterator iterator() {
        if (!this.optionals.isEmpty()) {
            this.addOptionals();
        }
        return this.info.iterator();
    }

    public boolean isEmpty() {
        return this.info.isEmpty();
    }

    public void remove(SecurityPolicy item) {
        int i = this.info.indexOf(item);
        if (i == -1) {
            return;
        }
        this.info.remove(i);
    }

    public void insertBefore(SecurityPolicy existing, SecurityPolicy additional) throws PolicyGenerationException {
        int i = this.info.indexOf(existing);
        if (i == -1) {
            return;
        }
        this.info.add(i, additional);
    }

    public void dumpMessages(boolean dump) {
        this.dumpMessages = dump;
    }

    public boolean dumpMessages() {
        return this.dumpMessages;
    }

    public void enableDynamicPolicy(boolean flag) {
        this.enableDynamicPolicyFlag = flag;
    }

    public boolean enableDynamicPolicy() {
        return this.enableDynamicPolicyFlag;
    }

    public void setWSSAssertion(WSSAssertion wssAssertion) throws PolicyGenerationException {
        this.wssAssertion = wssAssertion;
        if ("1.1".equals(this.wssAssertion.getType())) {
            this.enableWSS11PolicyFlag = true;
        }
        if (this.wssAssertion.getRequiredProperties().contains("RequireSignatureConfirmation")) {
            this.enableSignatureConfirmation = true;
        }
        if (this.enableSignatureConfirmation) {
            SignatureConfirmationPolicy signConfirmPolicy = new SignatureConfirmationPolicy();
            String id = SecurityUtil.generateUUID();
            signConfirmPolicy.setUUID(id);
            this.prepend(signConfirmPolicy);
        }
    }

    public WSSAssertion getWSSAssertion() {
        return this.wssAssertion;
    }

    public void enableSignatureConfirmation(boolean flag) throws PolicyGenerationException {
        this.enableSignatureConfirmation = flag;
        if (this.enableSignatureConfirmation) {
            SignatureConfirmationPolicy signConfirmPolicy = new SignatureConfirmationPolicy();
            String id = SecurityUtil.generateUUID();
            signConfirmPolicy.setUUID(id);
            this.append(signConfirmPolicy);
        }
    }

    public boolean enableSignatureConfirmation() {
        return this.enableSignatureConfirmation;
    }

    public void enableWSS11Policy(boolean flag) {
        this.enableWSS11PolicyFlag = flag;
    }

    public boolean enableWSS11Policy() {
        return this.enableWSS11PolicyFlag;
    }

    public void isBSP(boolean flag) {
        this.bsp = flag;
    }

    public boolean isBSP() {
        return this.bsp;
    }

    public void removeOptionalTargets() {
        this.optionals.clear();
    }

    public void addOptionalTargets(ArrayList optionls) throws XWSSecurityException {
        Iterator i = optionls.iterator();
        while (i.hasNext()) {
            try {
                Target target = (Target)i.next();
                target.setEnforce(false);
            }
            catch (ClassCastException cce) {
                String message = "Target should be of types: com.sun.xml.wss.impl.policy.mls.SignatureTarget OR com.sun.xml.wss.impl.policy.mls.EncryptionTarget";
                log.log(Level.SEVERE, "WSS1100.classcast.target", new Object[]{message});
                throw new XWSSecurityException(message, cce);
            }
        }
        this.optionals.addAll(optionls);
    }

    public void addOptionalTarget(Target target) {
        target.setEnforce(false);
        this.optionals.add(target);
    }

    public boolean equals(MessagePolicy policy) {
        boolean assrt;
        boolean bl = assrt = policy.dumpMessages() && policy.enableDynamicPolicy();
        if (assrt) {
            ArrayList primary0 = this.getPrimaryPolicies();
            ArrayList secdary0 = this.getSecondaryPolicies();
            ArrayList primary1 = policy.getPrimaryPolicies();
            ArrayList secdary1 = policy.getSecondaryPolicies();
            if (primary0.equals(primary1) && secdary0.equals(secdary1)) {
                assrt = true;
            }
        }
        return assrt;
    }

    public ArrayList getPrimaryPolicies() {
        ArrayList<SecurityPolicy> list = new ArrayList<SecurityPolicy>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            SecurityPolicy policy = (SecurityPolicy)i.next();
            if (!PolicyTypeUtil.encryptionPolicy(policy) && !PolicyTypeUtil.signaturePolicy(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    public ArrayList getSecondaryPolicies() {
        ArrayList<SecurityPolicy> list = new ArrayList<SecurityPolicy>();
        Iterator i = this.iterator();
        while (i.hasNext()) {
            SecurityPolicy policy = (SecurityPolicy)i.next();
            if (!PolicyTypeUtil.authenticationTokenPolicy(policy) && !PolicyTypeUtil.timestampPolicy(policy)) continue;
            list.add(policy);
        }
        return list;
    }

    private void addOptionals() {
        for (SecurityPolicy policy : this.info) {
            if (!(policy instanceof WSSPolicy)) continue;
            this.processWSSPolicy((WSSPolicy)policy);
        }
        this.optionals.clear();
    }

    private void processWSSPolicy(WSSPolicy policy) {
        block3: {
            block2: {
                if (!PolicyTypeUtil.signaturePolicy(policy)) break block2;
                SignaturePolicy sPolicy = (SignaturePolicy)policy;
                SignaturePolicy.FeatureBinding fBinding = (SignaturePolicy.FeatureBinding)sPolicy.getFeatureBinding();
                Iterator it = this.optionals.iterator();
                while (it.hasNext()) {
                    fBinding.addTargetBinding((Target)it.next());
                }
                break block3;
            }
            if (!PolicyTypeUtil.encryptionPolicy(policy)) break block3;
            EncryptionPolicy ePolicy = (EncryptionPolicy)policy;
            EncryptionPolicy.FeatureBinding fBinding = (EncryptionPolicy.FeatureBinding)ePolicy.getFeatureBinding();
            Iterator it = this.optionals.iterator();
            while (it.hasNext()) {
                fBinding.addTargetBinding((Target)it.next());
            }
        }
    }

    public String getType() {
        return "MessagePolicy";
    }

    public void setAlgorithmSuite(AlgorithmSuite algSuite) {
        this.algoSuite = algSuite;
    }

    public AlgorithmSuite getAlgorithmSuite() {
        return this.algoSuite;
    }

    public MessageLayout getLayout() {
        return this.layout;
    }

    public void setLayout(MessageLayout layout) {
        this.layout = layout;
    }

    public void setSSL(boolean value) {
        this.onSSL = value;
    }

    public boolean isSSL() {
        return this.onSSL;
    }
}

