/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.CachedDirectory;
import com.swoval.files.CachedDirectoryImpl;
import com.swoval.files.DirectoryRegistry;
import com.swoval.files.Entries;
import com.swoval.files.FileTreeDataViews;
import com.swoval.files.FileTreeViews;
import com.swoval.files.NioPathWatcherService;
import com.swoval.files.Observers;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import com.swoval.files.RegisterableWatchService;
import com.swoval.files.RootDirectories;
import com.swoval.files.TypedPath;
import com.swoval.files.TypedPaths;
import com.swoval.files.WatchedDirectories;
import com.swoval.files.WatchedDirectory;
import com.swoval.functional.Consumer;
import com.swoval.functional.Either;
import com.swoval.functional.Filter;
import com.swoval.functional.Filters;
import com.swoval.logging.Logger;
import com.swoval.logging.Loggers;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

class NioPathWatcher
implements PathWatcher<PathWatchers.Event>,
AutoCloseable {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Observers<PathWatchers.Event> observers = new Observers();
    private final RootDirectories rootDirectories = new RootDirectories();
    private final DirectoryRegistry directoryRegistry;
    private final FileTreeDataViews.Converter<WatchedDirectory> converter;
    private final Logger logger;
    private final NioPathWatcherService service;

    private FileTreeDataViews.CacheObserver<WatchedDirectory> updateCacheObserver(final List<PathWatchers.Event> list) {
        return new FileTreeDataViews.CacheObserver<WatchedDirectory>(){

            @Override
            public void onCreate(FileTreeDataViews.Entry<WatchedDirectory> entry) {
                list.add(new PathWatchers.Event(entry.getTypedPath(), PathWatchers.Event.Kind.Create));
                try {
                    for (TypedPath typedPath : FileTreeViews.list(entry.getTypedPath().getPath(), 0, (Filter<? super TypedPath>)new Filter<TypedPath>(){

                        @Override
                        public boolean accept(TypedPath typedPath) {
                            return NioPathWatcher.this.directoryRegistry.accept(typedPath.getPath());
                        }
                    })) {
                        list.add(new PathWatchers.Event(typedPath, PathWatchers.Event.Kind.Create));
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }

            @Override
            public void onDelete(FileTreeDataViews.Entry<WatchedDirectory> entry) {
                if (entry.getValue().isRight()) {
                    if (Loggers.shouldLog(NioPathWatcher.this.logger, Loggers.Level.DEBUG)) {
                        NioPathWatcher.this.logger.debug(this + " closing key for " + entry.getTypedPath().getPath());
                    }
                    entry.getValue().get().close();
                }
                list.add(new PathWatchers.Event(entry.getTypedPath(), PathWatchers.Event.Kind.Delete));
            }

            @Override
            public void onUpdate(FileTreeDataViews.Entry<WatchedDirectory> entry, FileTreeDataViews.Entry<WatchedDirectory> entry2) {
            }

            @Override
            public void onError(IOException iOException) {
            }
        };
    }

    NioPathWatcher(DirectoryRegistry directoryRegistry, RegisterableWatchService registerableWatchService, Logger logger) throws InterruptedException {
        this.directoryRegistry = directoryRegistry;
        this.logger = logger;
        this.service = new NioPathWatcherService(new Consumer<Either<PathWatchers.Overflow, PathWatchers.Event>>(){

            @Override
            public void accept(Either<PathWatchers.Overflow, PathWatchers.Event> either) {
                if (!NioPathWatcher.this.closed.get()) {
                    if (either.isRight()) {
                        PathWatchers.Event event = either.get();
                        NioPathWatcher.this.handleEvent(event);
                    } else {
                        NioPathWatcher.this.handleOverflow(Either.leftProjection(either).getValue());
                    }
                }
            }
        }, registerableWatchService, logger);
        this.converter = new FileTreeDataViews.Converter<WatchedDirectory>(){

            @Override
            public WatchedDirectory apply(TypedPath typedPath) {
                return typedPath.isDirectory() && !typedPath.isSymbolicLink() ? Either.getOrElse(NioPathWatcher.this.service.register(typedPath.getPath()), WatchedDirectories.INVALID) : WatchedDirectories.INVALID;
            }
        };
    }

    void add(TypedPath typedPath, List<PathWatchers.Event> list) {
        CachedDirectory<WatchedDirectory> cachedDirectory;
        if ((this.directoryRegistry.maxDepthFor(typedPath.getPath()) >= 0 || this.directoryRegistry.acceptPrefix(typedPath.getPath())) && (cachedDirectory = this.getOrAdd(typedPath.getPath())) != null) {
            this.update(cachedDirectory, typedPath, list, true);
        }
    }

    private void remove(Path path, List<PathWatchers.Event> list) {
        CachedDirectory<WatchedDirectory> cachedDirectory;
        CachedDirectory<WatchedDirectory> cachedDirectory2 = (CachedDirectory<WatchedDirectory>)this.rootDirectories.remove(path);
        CachedDirectory<WatchedDirectory> cachedDirectory3 = cachedDirectory = cachedDirectory2 == null ? this.find(path) : cachedDirectory2;
        if (cachedDirectory != null) {
            this.remove(cachedDirectory, path, list);
        }
    }

    private void remove(CachedDirectory<WatchedDirectory> cachedDirectory, Path path, List<PathWatchers.Event> list) {
        List list2 = cachedDirectory.remove(path);
        if (path == null || path == cachedDirectory.getPath()) {
            list2.add(cachedDirectory.getEntry());
        }
        for (FileTreeDataViews.Entry entry : list2) {
            Either either = entry.getValue();
            if (!either.isRight()) continue;
            if (list != null) {
                TypedPath typedPath = TypedPaths.get(entry.getTypedPath().getPath(), TypedPaths.getKind(entry.getTypedPath()) | 0x10);
                list.add(new PathWatchers.Event(typedPath, PathWatchers.Event.Kind.Delete));
            }
            ((WatchedDirectory)either.get()).close();
        }
    }

    @Override
    public Either<IOException, Boolean> register(Path path, int n) {
        Iterable<Path> iterable;
        Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        int n2 = this.directoryRegistry.maxDepthFor(path2);
        boolean bl = n2 < n;
        TypedPath typedPath = TypedPaths.get(path2);
        if (bl) {
            this.directoryRegistry.addDirectory(path2, n);
        }
        CachedDirectory<WatchedDirectory> cachedDirectory = this.getOrAdd(path2);
        ArrayList<PathWatchers.Event> arrayList = new ArrayList<PathWatchers.Event>();
        if (cachedDirectory != null) {
            FileTreeDataViews.Entry<WatchedDirectory> entry2;
            iterable = typedPath.getPath();
            Path path3 = cachedDirectory.getEntry().getTypedPath().getPath();
            Path path4 = path3.relativize((Path)iterable);
            Path path5 = path3;
            List<FileTreeDataViews.Entry<WatchedDirectory>> list = cachedDirectory.listEntries(path3, path4.getNameCount() + 1, Filters.AllPass);
            for (FileTreeDataViews.Entry<WatchedDirectory> entry2 : list) {
                Path path6 = entry2.getTypedPath().getPath();
                if (!iterable.startsWith(path6) || path6.toString().length() <= path5.toString().length()) continue;
                path5 = path6;
            }
            entry2 = cachedDirectory.listEntries(path5, -1, Filters.AllPass);
            if (bl || entry2.isEmpty() || ((FileTreeDataViews.Entry)entry2.get(0)).getValue().isRight()) {
                this.update(cachedDirectory, TypedPaths.get(path5), arrayList, true);
            }
        }
        iterable = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            if (((PathWatchers.Event)arrayList.get(i)).getKind() == PathWatchers.Event.Kind.Create) continue;
            iterable.add(arrayList.get(i));
        }
        this.runCallbacks((List<PathWatchers.Event>)iterable);
        if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
            this.logger.debug(this + " registered " + path + " with max depth " + n);
        }
        return Either.right(bl);
    }

    private CachedDirectory<WatchedDirectory> find(Path path) {
        return this.find(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedDirectory<WatchedDirectory> find(Path path, List<Path> list) {
        Path path2;
        Path path3 = path2 = path == null ? this.getRoot() : path;
        assert (path2 != null);
        if (this.rootDirectories.lock()) {
            try {
                Map.Entry entry;
                Iterator iterator = this.rootDirectories.iterator();
                Object object = null;
                while (object == null && iterator.hasNext()) {
                    entry = iterator.next();
                    Path path4 = (Path)entry.getKey();
                    if (path2.startsWith(path4)) {
                        object = (CachedDirectory)entry.getValue();
                        continue;
                    }
                    if (list == null || !path4.startsWith(path2) || path2.equals(path4)) continue;
                    list.add(path4);
                }
                entry = object;
                return entry;
            }
            finally {
                this.rootDirectories.unlock();
            }
        }
        return null;
    }

    private Path getRoot() {
        Iterator<Path> iterator = FileSystems.getDefault().getRootDirectories().iterator();
        return iterator.next();
    }

    private CachedDirectory<WatchedDirectory> findOrAddRoot(Path path) {
        Object object;
        ArrayList<Path> arrayList = new ArrayList<Path>();
        CachedDirectory<WatchedDirectory> cachedDirectory = this.find(path, arrayList);
        if (cachedDirectory == null) {
            Object object2;
            object = path.getParent();
            Object object3 = object2 = object == null ? this.getRoot() : object;
            assert (object2 != null);
            boolean bl = false;
            while (!bl && object2 != null) {
                try {
                    cachedDirectory = new CachedDirectoryImpl<WatchedDirectory>(TypedPaths.get((Path)object2), this.converter, Integer.MAX_VALUE, (Filter<? super TypedPath>)new Filter<TypedPath>(){

                        @Override
                        public boolean accept(TypedPath typedPath) {
                            return typedPath.isDirectory() && !typedPath.isSymbolicLink() && NioPathWatcher.this.directoryRegistry.acceptPrefix(typedPath.getPath());
                        }
                    }, false).init();
                    bl = true;
                    this.rootDirectories.put(object2, cachedDirectory);
                }
                catch (IOException iOException) {
                    object2 = object2.getParent();
                }
            }
        }
        object = arrayList.iterator();
        while (object.hasNext()) {
            this.rootDirectories.remove(object.next());
        }
        return cachedDirectory;
    }

    private CachedDirectory<WatchedDirectory> getOrAdd(Path path) {
        CachedDirectory<WatchedDirectory> cachedDirectory = null;
        if (this.rootDirectories.lock()) {
            try {
                if (!this.closed.get()) {
                    cachedDirectory = this.findOrAddRoot(path);
                }
            }
            finally {
                this.rootDirectories.unlock();
            }
        }
        return cachedDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(Path path) {
        Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        this.directoryRegistry.removeDirectory(path2);
        if (this.rootDirectories.lock()) {
            try {
                CachedDirectory<WatchedDirectory> cachedDirectory = this.find(path2);
                if (cachedDirectory != null) {
                    int n = cachedDirectory.getPath().relativize(path2).getNameCount();
                    List<FileTreeDataViews.Entry<WatchedDirectory>> list = cachedDirectory.listEntries(n, new Filter<FileTreeDataViews.Entry<WatchedDirectory>>(){

                        @Override
                        public boolean accept(FileTreeDataViews.Entry<WatchedDirectory> entry) {
                            return !NioPathWatcher.this.directoryRegistry.acceptPrefix(entry.getTypedPath().getPath());
                        }
                    });
                    for (FileTreeDataViews.Entry<WatchedDirectory> entry : list) {
                        if (this.directoryRegistry.acceptPrefix(entry.getTypedPath().getPath())) continue;
                        this.remove(cachedDirectory, entry.getTypedPath().getPath(), null);
                    }
                    this.rootDirectories.remove(cachedDirectory.getPath());
                }
            }
            finally {
                this.rootDirectories.unlock();
            }
        }
        if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
            this.logger.debug(this + " unregistered " + path);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.service.close();
            this.rootDirectories.clear();
        }
    }

    private void update(CachedDirectory<WatchedDirectory> cachedDirectory, TypedPath typedPath, List<PathWatchers.Event> list, boolean bl) {
        try {
            cachedDirectory.update(typedPath, bl).observe(this.updateCacheObserver(list));
        }
        catch (NoSuchFileException noSuchFileException) {
            this.remove(cachedDirectory, typedPath.getPath(), list);
            TypedPath typedPath2 = TypedPaths.get(typedPath.getPath());
            list.add(new PathWatchers.Event(typedPath2, typedPath2.exists() ? PathWatchers.Event.Kind.Modify : PathWatchers.Event.Kind.Delete));
            CachedDirectory cachedDirectory2 = (CachedDirectory)this.rootDirectories.remove(typedPath.getPath());
            if (cachedDirectory2 != null) {
                Iterator iterator = cachedDirectory2.listEntries(Integer.MAX_VALUE, Filters.AllPass).iterator();
                while (iterator.hasNext()) {
                    ((WatchedDirectory)iterator.next().getValue().get()).close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOverflow(PathWatchers.Overflow overflow) {
        Object object;
        ArrayList<PathWatchers.Event> arrayList;
        Path path;
        block9: {
            path = overflow.getPath();
            if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
                this.logger.debug(this + " received overflow for " + path);
            }
            arrayList = new ArrayList<PathWatchers.Event>();
            if (this.rootDirectories.lock()) {
                try {
                    object = this.find(path);
                    if (object == null) break block9;
                    try {
                        for (TypedPath typedPath : FileTreeViews.list(path, 0, (Filter<? super TypedPath>)new Filter<TypedPath>(){

                            @Override
                            public boolean accept(TypedPath typedPath) {
                                return typedPath.isDirectory() && NioPathWatcher.this.directoryRegistry.acceptPrefix(typedPath.getPath());
                            }
                        })) {
                            this.add(typedPath, arrayList);
                        }
                    }
                    catch (IOException iOException) {
                        List list = object.remove(path);
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            arrayList.add(new PathWatchers.Event(Entries.setExists(iterator.next(), false).getTypedPath(), PathWatchers.Event.Kind.Delete));
                        }
                    }
                }
                finally {
                    this.rootDirectories.unlock();
                }
            }
        }
        arrayList.add(new PathWatchers.Event((TypedPath)object, (object = TypedPaths.get(path)).exists() ? PathWatchers.Event.Kind.Overflow : PathWatchers.Event.Kind.Delete));
        this.runCallbacks(arrayList);
    }

    private void runCallbacks(List<PathWatchers.Event> list) {
        Iterator<PathWatchers.Event> iterator = list.iterator();
        HashSet<Path> hashSet = new HashSet<Path>();
        while (iterator.hasNext()) {
            PathWatchers.Event event = iterator.next();
            Path path = event.getTypedPath().getPath();
            if (!this.directoryRegistry.accept(path) || !hashSet.add(path)) continue;
            this.observers.onNext(new PathWatchers.Event(TypedPaths.get(path), event.getKind()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEvent(PathWatchers.Event event) {
        if (Loggers.shouldLog(this.logger, Loggers.Level.DEBUG)) {
            this.logger.debug(this + " received event " + event);
        }
        ArrayList<PathWatchers.Event> arrayList = new ArrayList<PathWatchers.Event>();
        if (!this.closed.get() && this.rootDirectories.lock()) {
            try {
                if (this.directoryRegistry.acceptPrefix(event.getTypedPath().getPath())) {
                    boolean bl = event.getKind() == PathWatchers.Event.Kind.Delete;
                    TypedPath typedPath = TypedPaths.get(event.getTypedPath().getPath());
                    if (bl) {
                        this.remove(typedPath.getPath(), arrayList);
                    }
                    if (typedPath.exists()) {
                        if (typedPath.isDirectory() && !typedPath.isSymbolicLink()) {
                            this.add(typedPath, arrayList);
                        }
                        arrayList.add(event);
                    } else if (!bl) {
                        this.remove(typedPath.getPath(), arrayList);
                    } else {
                        arrayList.add(event);
                    }
                }
            }
            finally {
                this.rootDirectories.unlock();
            }
        }
        this.runCallbacks(arrayList);
    }

    @Override
    public int addObserver(FileTreeViews.Observer<? super PathWatchers.Event> observer) {
        return this.observers.addObserver(observer);
    }

    @Override
    public void removeObserver(int n) {
        this.observers.removeObserver(n);
    }
}

