/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineInternalError;
import com.taskadapter.redmineapi.bean.Attachment;
import com.taskadapter.redmineapi.bean.Issue;
import com.taskadapter.redmineapi.internal.CopyBytesHandler;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.Transport;
import com.taskadapter.redmineapi.internal.io.MarkedIOException;
import com.taskadapter.redmineapi.internal.io.MarkedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class AttachmentManager {
    private final Transport transport;

    AttachmentManager(Transport transport) {
        this.transport = transport;
    }

    public Attachment addAttachmentToIssue(Integer issueId, File attachmentFile, String contentType) throws RedmineException, IOException {
        Attachment attach = this.uploadAttachment(contentType, attachmentFile);
        new Issue(this.transport, -1).setId(issueId).addAttachment(attach).update(new RequestParam[0]);
        return attach;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment uploadAttachment(String fileName, String contentType, byte[] content) throws RedmineException, IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        try {
            Attachment attachment = this.uploadAttachment(fileName, contentType, is, content.length);
            return attachment;
        }
        finally {
            try {
                ((InputStream)is).close();
            }
            catch (IOException e) {
                throw new RedmineInternalError("Unexpected exception", e);
            }
        }
    }

    public Attachment uploadAttachment(String contentType, File content) throws RedmineException, IOException {
        try (FileInputStream is = new FileInputStream(content);){
            Attachment attachment = this.uploadAttachment(content.getName(), contentType, is, content.length());
            return attachment;
        }
    }

    public Attachment uploadAttachment(String fileName, String contentType, InputStream content) throws RedmineException, IOException {
        return this.uploadAttachment(fileName, contentType, content, -1L);
    }

    public Attachment uploadAttachment(String fileName, String contentType, InputStream content, long contentLength) throws RedmineException, IOException {
        MarkedInputStream wrapper = new MarkedInputStream(content, "uploadStream");
        try {
            String token = this.transport.upload(wrapper, contentLength);
            return new Attachment(this.transport).setToken(token).setContentType(contentType).setFileName(fileName);
        }
        catch (RedmineException e) {
            AttachmentManager.unwrapException(e, "uploadStream");
            throw e;
        }
    }

    public Attachment getAttachmentById(int attachmentID) throws RedmineException {
        return this.transport.getObject(Attachment.class, attachmentID, new RequestParam[0]);
    }

    public void downloadAttachmentContent(Attachment issueAttachment, OutputStream stream) throws RedmineException {
        this.transport.download(issueAttachment.getContentURL(), new CopyBytesHandler(stream));
    }

    public byte[] downloadAttachmentContent(Attachment issueAttachment) throws RedmineException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.downloadAttachmentContent(issueAttachment, baos);
        try {
            baos.close();
        }
        catch (IOException e) {
            throw new RedmineInternalError();
        }
        return baos.toByteArray();
    }

    @Deprecated
    public void delete(int attachmentId) throws RedmineException {
        new Attachment(this.transport).setId(attachmentId).delete();
    }

    private static void unwrapException(RedmineException exception, String tag) throws IOException {
        for (Throwable e = exception; e != null; e = e.getCause()) {
            MarkedIOException marked;
            if (!(e instanceof MarkedIOException) || !tag.equals((marked = (MarkedIOException)e).getTag())) continue;
            throw marked.getIOException();
        }
    }
}

