/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.Group;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.bean.User;
import com.taskadapter.redmineapi.internal.DirectObjectsSearcher;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.ResultsWrapper;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.List;
import java.util.Map;

public class UserManager {
    private final Transport transport;

    UserManager(Transport transport) {
        this.transport = transport;
    }

    public User getCurrentUser() throws RedmineException {
        return this.transport.getCurrentUser(new RequestParam[0]);
    }

    @Deprecated
    public User createUser(User user) throws RedmineException {
        return user.create();
    }

    @Deprecated
    public void deleteUser(Integer userId) throws RedmineException {
        this.transport.deleteObject(User.class, Integer.toString(userId));
    }

    @Deprecated
    public void addUserToGroup(User user, Group group) throws RedmineException {
        this.transport.addUserToGroup(user.getId(), group.getId());
    }

    public List<User> getUsers() throws RedmineException {
        return this.transport.getObjectsList(User.class, new RequestParam("include", "memberships,groups"));
    }

    public ResultsWrapper<User> getUsers(Map<String, String> parameters) throws RedmineException {
        return DirectObjectsSearcher.getObjectsListNoPaging(this.transport, parameters, User.class);
    }

    public User getUserById(Integer userId) throws RedmineException {
        return this.transport.getObject(User.class, userId, new RequestParam("include", "memberships,groups"));
    }

    public List<Group> getGroups() throws RedmineException {
        return this.transport.getObjectsList(Group.class, new RequestParam[0]);
    }

    public Group getGroupById(int id) throws RedmineException {
        return this.transport.getObject(Group.class, id, new RequestParam[0]);
    }

    public Group getGroupByName(String name) throws RedmineException {
        return this.transport.getObject(Group.class, name, new RequestParam[0]);
    }

    @Deprecated
    public Group createGroup(Group base) throws RedmineException {
        return this.transport.addObject(base, new RequestParam[0]);
    }

    @Deprecated
    public void deleteGroup(Group base) throws RedmineException {
        this.transport.deleteObject(Group.class, base.getId().toString());
    }

    public List<Role> getRoles() throws RedmineException {
        return this.transport.getObjectsList(Role.class, new RequestParam[0]);
    }

    public Role getRoleById(int id) throws RedmineException {
        return this.transport.getObject(Role.class, id, new RequestParam[0]);
    }

    @Deprecated
    public void update(User obj) throws RedmineException {
        this.transport.updateObject(obj, new RequestParam[0]);
    }

    @Deprecated
    public void update(Group group) throws RedmineException {
        this.transport.updateObject(group, new RequestParam[0]);
    }
}

