/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CustomField {
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> DATABASE_ID = new Property<Integer>(Integer.class, "id");
    public static final Property<String> NAME = new Property<String>(String.class, "name");
    public static final Property<String> VALUE = new Property<String>(String.class, "value");
    public static final Property<Boolean> MULTIPLE = new Property<Boolean>(Boolean.class, "multiple");
    public static final Property<List<String>> VALUES = new Property<List>(List.class, "values");

    public CustomField() {
        this.initCollections(this.storage);
    }

    public CustomField setId(Integer id) {
        this.storage.set(DATABASE_ID, id);
        return this;
    }

    private void initCollections(PropertyStorage storage) {
        storage.set(VALUES, new ArrayList());
    }

    public Integer getId() {
        return this.storage.get(DATABASE_ID);
    }

    public String getName() {
        return this.storage.get(NAME);
    }

    public CustomField setName(String name) {
        this.storage.set(NAME, name);
        return this;
    }

    public String getValue() {
        return this.storage.get(VALUE);
    }

    public CustomField setValue(String value) {
        this.storage.set(VALUE, value);
        this.storage.set(VALUES, new ArrayList());
        this.storage.set(MULTIPLE, false);
        return this;
    }

    public List<String> getValues() {
        return this.storage.get(VALUES);
    }

    public CustomField setValues(List<String> values) {
        this.storage.set(VALUES, values);
        this.storage.set(VALUE, null);
        this.storage.set(MULTIPLE, true);
        return this;
    }

    public boolean isMultiple() {
        return this.storage.get(MULTIPLE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomField that = (CustomField)o;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public String toString() {
        return "CustomField{id=" + this.getId() + ", name='" + this.getName() + '\'' + ", value='" + this.getValue() + '\'' + ", values=" + this.getValues() + '}';
    }
}

