/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.FluentStyle;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Project;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import com.taskadapter.redmineapi.bean.PropertyStorageUtil;
import com.taskadapter.redmineapi.bean.Role;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.Transport;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class Membership
implements Identifiable,
FluentStyle {
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> DATABASE_ID = new Property<Integer>(Integer.class, "id");
    public static final Property<Project> PROJECT = new Property<Project>(Project.class, "project");
    public static final Property<Integer> USER_ID = new Property<Integer>(Integer.class, "userId");
    public static final Property<String> USER_NAME = new Property<String>(String.class, "userName");
    public static final Property<Integer> GROUP_ID = new Property<Integer>(Integer.class, "groupId");
    public static final Property<String> GROUP_NAME = new Property<String>(String.class, "groupName");
    public static final Property<Set<Role>> ROLES = new Property<Set>(Set.class, "roles");
    private Transport transport;

    public Membership(Transport transport) {
        this.storage.set(ROLES, new HashSet());
        this.setTransport(transport);
    }

    public Membership(Transport transport, Project project, int userId) {
        this(transport);
        this.setProject(project);
        this.setUserId(userId);
    }

    public Membership setId(Integer id) {
        this.storage.set(DATABASE_ID, id);
        return this;
    }

    @Override
    public Integer getId() {
        return this.storage.get(DATABASE_ID);
    }

    public Project getProject() {
        return this.storage.get(PROJECT);
    }

    public Membership setProject(Project project) {
        this.storage.set(PROJECT, project);
        return this;
    }

    public Integer getUserId() {
        return this.storage.get(USER_ID);
    }

    public Membership setUserId(Integer id) {
        this.storage.set(USER_ID, id);
        return this;
    }

    public Integer getGroupId() {
        return this.storage.get(GROUP_ID);
    }

    public void setGroupId(Integer id) {
        this.storage.set(GROUP_ID, id);
    }

    public String getUserName() {
        return this.storage.get(USER_NAME);
    }

    public void setUserName(String id) {
        this.storage.set(USER_NAME, id);
    }

    public String getGroupName() {
        return this.storage.get(GROUP_NAME);
    }

    public void setGroupName(String id) {
        this.storage.set(GROUP_NAME, id);
    }

    public Collection<Role> getRoles() {
        return Collections.unmodifiableCollection((Collection)this.storage.get(ROLES));
    }

    public Membership addRoles(Collection<Role> roles) {
        this.storage.get(ROLES).addAll(roles);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Membership that = (Membership)o;
        return !(this.getId() != null ? !this.getId().equals(that.getId()) : that.getId() != null);
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public String toString() {
        return "Membership [id=" + this.getId() + ", project=" + this.getProject() + ", userId=" + this.getUserId() + ", groupId=" + this.getGroupId() + ", roles=" + this.getRoles() + "]";
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }

    public Membership create() throws RedmineException {
        if (this.getProject() == null) {
            throw new IllegalArgumentException("Project must be set");
        }
        if (this.getUserId() == null && this.getRoles().isEmpty()) {
            throw new IllegalArgumentException("Either User or Roles field must be set");
        }
        return this.transport.addChildEntry(Project.class, this.getProject().getId() + "", this, new RequestParam[0]);
    }

    public void update() throws RedmineException {
        this.transport.updateObject(this, new RequestParam[0]);
    }

    public void delete() throws RedmineException {
        this.transport.deleteObject(Membership.class, Integer.toString(this.getId()));
    }

    @Override
    public void setTransport(Transport transport) {
        this.transport = transport;
        PropertyStorageUtil.updateCollections(this.storage, transport);
    }
}

