/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.bean;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.bean.CustomField;
import com.taskadapter.redmineapi.bean.FluentStyle;
import com.taskadapter.redmineapi.bean.Identifiable;
import com.taskadapter.redmineapi.bean.Property;
import com.taskadapter.redmineapi.bean.PropertyStorage;
import com.taskadapter.redmineapi.bean.PropertyStorageUtil;
import com.taskadapter.redmineapi.bean.Tracker;
import com.taskadapter.redmineapi.internal.RequestParam;
import com.taskadapter.redmineapi.internal.Transport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Project
implements Identifiable,
Serializable,
FluentStyle {
    private static final long serialVersionUID = 4529305420978716446L;
    private final PropertyStorage storage = new PropertyStorage();
    public static final Property<Integer> DATABASE_ID = new Property<Integer>(Integer.class, "id");
    public static final Property<String> STRING_IDENTIFIER = new Property<String>(String.class, "identifier");
    public static final Property<String> NAME = new Property<String>(String.class, "name");
    public static final Property<String> DESCRIPTION = new Property<String>(String.class, "description");
    public static final Property<String> HOMEPAGE = new Property<String>(String.class, "homepage");
    public static final Property<Date> CREATED_ON = new Property<Date>(Date.class, "createdOn");
    public static final Property<Date> UPDATED_ON = new Property<Date>(Date.class, "updatedOn");
    public static final Property<Integer> PARENT_DATABASE_ID = new Property<Integer>(Integer.class, "parentId");
    public static final Property<Integer> STATUS = new Property<Integer>(Integer.class, "status");
    public static final Property<Boolean> PUBLIC = new Property<Boolean>(Boolean.class, "public");
    public static final Property<Boolean> INHERIT_MEMBERS = new Property<Boolean>(Boolean.class, "inheritMembers");
    public static final Property<Set<CustomField>> CUSTOM_FIELDS = new Property<Set>(Set.class, "customFields");
    public static final Property<Set<Tracker>> TRACKERS = new Property<Set>(Set.class, "trackers");
    private Transport transport;

    public Project(Transport transport) {
        this.transport = transport;
        this.storage.set(CUSTOM_FIELDS, new HashSet());
    }

    public Project(Transport transport, String name, String key) {
        this(transport);
        this.setName(name);
        this.setIdentifier(key);
    }

    public Project setId(Integer id) {
        this.storage.set(DATABASE_ID, id);
        return this;
    }

    public String getHomepage() {
        return this.storage.get(HOMEPAGE);
    }

    public Project setHomepage(String homepage) {
        this.storage.set(HOMEPAGE, homepage);
        return this;
    }

    public String getIdentifier() {
        return this.storage.get(STRING_IDENTIFIER);
    }

    public Project setIdentifier(String identifier) {
        this.storage.set(STRING_IDENTIFIER, identifier);
        return this;
    }

    @Override
    public Integer getId() {
        return this.storage.get(DATABASE_ID);
    }

    public String getName() {
        return this.storage.get(NAME);
    }

    public Project setName(String name) {
        this.storage.set(NAME, name);
        return this;
    }

    public Collection<Tracker> getTrackers() {
        if (!this.storage.isPropertySet(TRACKERS)) {
            return Collections.unmodifiableCollection(new HashSet());
        }
        return Collections.unmodifiableCollection((Collection)this.storage.get(TRACKERS));
    }

    public Project addTrackers(Collection<Tracker> trackers) {
        if (!this.storage.isPropertySet(TRACKERS)) {
            this.storage.set(TRACKERS, new HashSet());
        }
        this.storage.get(TRACKERS).addAll(trackers);
        return this;
    }

    public Project clearTrackers() {
        this.storage.set(TRACKERS, new HashSet());
        return this;
    }

    public Tracker getTrackerByName(String trackerName) {
        for (Tracker t : this.getTrackers()) {
            if (!t.getName().equals(trackerName)) continue;
            return t;
        }
        return null;
    }

    public String toString() {
        return "Project{id=" + this.getId() + ", identifier='" + this.getIdentifier() + '\'' + ", name='" + this.getName() + '\'' + '}';
    }

    public String getDescription() {
        return this.storage.get(DESCRIPTION);
    }

    public Project setDescription(String description) {
        this.storage.set(DESCRIPTION, description);
        return this;
    }

    public Date getCreatedOn() {
        return this.storage.get(CREATED_ON);
    }

    public Project setCreatedOn(Date createdOn) {
        this.storage.set(CREATED_ON, createdOn);
        return this;
    }

    public Date getUpdatedOn() {
        return this.storage.get(UPDATED_ON);
    }

    public Project setUpdatedOn(Date updatedOn) {
        this.storage.set(UPDATED_ON, updatedOn);
        return this;
    }

    public Integer getParentId() {
        return this.storage.get(PARENT_DATABASE_ID);
    }

    public Project setParentId(Integer parentId) {
        this.storage.set(PARENT_DATABASE_ID, parentId);
        return this;
    }

    public Integer getStatus() {
        return this.storage.get(STATUS);
    }

    public Project setStatus(Integer status) {
        this.storage.set(STATUS, status);
        return this;
    }

    @Deprecated
    public Boolean getProjectPublic() {
        return this.storage.get(PUBLIC);
    }

    public Project setInheritMembers(Boolean inheritMembers) {
        this.storage.set(INHERIT_MEMBERS, inheritMembers);
        return this;
    }

    public Boolean getInheritMembers() {
        return this.storage.get(INHERIT_MEMBERS);
    }

    public Project setProjectPublic(Boolean projectPublic) {
        this.storage.set(PUBLIC, projectPublic);
        return this;
    }

    public Collection<CustomField> getCustomFields() {
        return this.storage.get(CUSTOM_FIELDS);
    }

    public Project addCustomFields(Collection<CustomField> customFields) {
        this.storage.get(CUSTOM_FIELDS).addAll(customFields);
        return this;
    }

    public CustomField getCustomFieldById(int customFieldId) {
        for (CustomField customField : this.getCustomFields()) {
            if (customFieldId != customField.getId()) continue;
            return customField;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Project project = (Project)o;
        return !(this.getId() != null ? !this.getId().equals(project.getId()) : project.getId() != null);
    }

    public int hashCode() {
        return this.getId() != null ? this.getId().hashCode() : 0;
    }

    public PropertyStorage getStorage() {
        return this.storage;
    }

    @Override
    public void setTransport(Transport transport) {
        this.transport = transport;
        PropertyStorageUtil.updateCollections(this.storage, transport);
    }

    public Project create() throws RedmineException {
        return this.transport.addObject(this, new RequestParam("include", "trackers"));
    }

    public void update() throws RedmineException {
        this.transport.updateObject(this, new RequestParam[0]);
    }

    public void delete() throws RedmineException {
        this.transport.deleteObject(Project.class, this.getIdentifier());
    }
}

