/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal;

import com.taskadapter.redmineapi.internal.LocalDateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class RedmineDateParser {
    public static final LocalDateFormat FULL_DATE_FORMAT = new LocalDateFormat("yyyy/MM/dd HH:mm:ss Z");
    public static final LocalDateFormat FULL_DATE_FORMAT_V2 = new LocalDateFormat("yyyy-MM-dd'T'HH:mm:ssz");
    public static final LocalDateFormat FULL_DATE_FORMAT_V3 = new LocalDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz");
    private static final String SHORT_DATE_PATTERN_V1 = "yyyy/MM/dd";
    private static final String SHORT_DATE_PATTERN_V2 = "yyyy-MM-dd";
    public static final LocalDateFormat SHORT_DATE_FORMAT = new LocalDateFormat("yyyy/MM/dd");
    public static final LocalDateFormat SHORT_DATE_FORMAT_V2 = new LocalDateFormat("yyyy-MM-dd");
    private static final int SHORT_DATE_FORMAT_MAX_LENGTH = Math.max("yyyy/MM/dd".length(), "yyyy-MM-dd".length());

    static Date parse(String dateStr) throws ParseException {
        if (dateStr.length() > SHORT_DATE_FORMAT_MAX_LENGTH) {
            return RedmineDateParser.parseLongFormat(dateStr);
        }
        return RedmineDateParser.parseShortFormat(dateStr);
    }

    private static Date parseShortFormat(String dateStr) throws ParseException {
        SimpleDateFormat format = dateStr.length() >= 5 && dateStr.charAt(4) == '/' ? (SimpleDateFormat)SHORT_DATE_FORMAT.get() : (SimpleDateFormat)SHORT_DATE_FORMAT_V2.get();
        return format.parse(dateStr);
    }

    private static Date parseLongFormat(String dateStr) throws ParseException {
        if (dateStr.length() >= 5 && dateStr.charAt(4) == '/') {
            SimpleDateFormat format = (SimpleDateFormat)FULL_DATE_FORMAT.get();
            return format.parse(dateStr);
        }
        SimpleDateFormat format = (dateStr = RedmineDateParser.normalizeTimeZoneInfo(dateStr)).indexOf(46) < 0 ? (SimpleDateFormat)FULL_DATE_FORMAT_V2.get() : (SimpleDateFormat)FULL_DATE_FORMAT_V3.get();
        return format.parse(dateStr);
    }

    private static String normalizeTimeZoneInfo(String dateStr) throws ParseException {
        if (dateStr.endsWith("Z")) {
            dateStr = dateStr.substring(0, dateStr.length() - 1) + "GMT-00:00";
        } else {
            int inset = 6;
            if (dateStr.length() <= 6) {
                throw new ParseException("Bad date value " + dateStr, 6);
            }
            String s0 = dateStr.substring(0, dateStr.length() - 6);
            String s1 = dateStr.substring(dateStr.length() - 6, dateStr.length());
            dateStr = s0 + "GMT" + s1;
        }
        return dateStr;
    }
}

