/*
 * Decompiled with CFR 0.152.
 */
package com.taskadapter.redmineapi.internal.comm;

import com.taskadapter.redmineapi.RedmineException;
import com.taskadapter.redmineapi.RedmineFormatException;
import com.taskadapter.redmineapi.RedmineTransportException;
import com.taskadapter.redmineapi.internal.comm.Communicator;
import com.taskadapter.redmineapi.internal.comm.ContentHandler;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCommunicator
implements Communicator<HttpResponse> {
    private final Logger logger = LoggerFactory.getLogger(BaseCommunicator.class);
    private final HttpClient client;

    public BaseCommunicator(HttpClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R sendRequest(HttpRequest request, ContentHandler<HttpResponse, R> handler) throws RedmineException {
        this.logger.debug(request.getRequestLine().toString());
        request.addHeader("Accept-Encoding", "gzip");
        HttpClient httpclient = this.client;
        try {
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)request);
            try {
                R r = handler.processContent(httpResponse);
                return r;
            }
            finally {
                EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            }
        }
        catch (ClientProtocolException e1) {
            throw new RedmineFormatException(e1);
        }
        catch (IOException e1) {
            throw new RedmineTransportException("Cannot fetch data from " + this.getMessageURI(request) + " : " + e1.toString(), e1);
        }
    }

    private String getMessageURI(HttpRequest request) {
        String uri = request.getRequestLine().getUri();
        int paramsIndex = uri.indexOf(63);
        if (paramsIndex >= 0) {
            return uri.substring(0, paramsIndex);
        }
        return uri;
    }
}

