/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tdgss.jgssp2gss;

import com.teradata.tdgss.jgssp2gss.GssContext;
import com.teradata.tdgss.jgssp2gss.GssCredential;
import com.teradata.tdgss.jgssp2gss.GssMinorStatus;
import com.teradata.tdgss.jgssp2gss.GssName;
import com.teradata.tdgss.jgssspi.GSSMechanism;
import com.teradata.tdgss.jtdgss.TdgssException;
import com.teradata.tdgss.jtdgss.TdgssLogger;
import com.teradata.tdgss.jtdgss.TdgssName;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class SspiMechanism
implements GSSMechanism {
    private final TdgssLogger logger;
    private static Oid _mechOid;
    private static Oid _gssOid;
    private String userName = null;
    private String realm = null;
    private String extLogdata = null;
    private GSSManager mgr = null;
    protected static final Oid mechOid;
    protected static final Oid gssOid;
    protected static final int servicesAvailable = 127;

    public SspiMechanism(TdgssLogger tdgssLogger) {
        this.logger = tdgssLogger;
        this.mgr = GSSManager.getInstance();
    }

    @Override
    public boolean acceptable(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        byte[] byArray;
        if (object == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Token is null");
            }
            return false;
        }
        try {
            byArray = (byte[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return (byArray[8] & 1) != 1 && byArray[1] == 1;
    }

    @Override
    public GSSContext getContextForAccept(Object object, GSSCredential gSSCredential, Object[] objectArray) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Getting an acceptable context ");
        }
        if (!this.acceptable(object, gSSCredential, objectArray)) {
            throw new TdgssException(10, GssMinorStatus.GSSP2GSS_ERR_INVALID_TOKEN);
        }
        GSSContext gSSContext = this.mgr.createContext(gSSCredential);
        return new GssContext(gSSContext, mechOid, null, this.logger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GSSContext getContextForInit(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, int n2, List<Oid> list) throws GSSException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Enter SspiMechanism.getContextForInit");
        }
        long l = System.currentTimeMillis();
        try {
            if (!this.initable(gSSCredential, gSSName, n, objectArray, n2)) {
                throw new TdgssException(10, GssMinorStatus.GSSP2GSS_ERR_INVALID_TOKEN);
            }
            if (gSSCredential == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No Credential Object");
                }
                throw new TdgssException(13);
            }
            long l2 = System.currentTimeMillis();
            try {
                ((GssCredential)gSSCredential).login();
            }
            finally {
                long l3 = System.currentTimeMillis() - l2;
                if (l3 > 60000L) {
                    this.logger.error("SspiMechanism.getContextForInit login took " + l3 + " ms");
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("SspiMechanism.getContextForInit login took " + l3 + " ms");
                }
            }
            GSSCredential gSSCredential2 = ((GssCredential)gSSCredential).getGssCredential();
            GSSName gSSName2 = this.mgr.createName(gSSName.toString().getBytes(), gSSName.getStringNameType());
            GSSContext gSSContext = this.mgr.createContext(gSSName2, gssOid, gSSCredential2, n);
            this.setServices(gSSContext, n2);
            GssContext gssContext = new GssContext(gSSContext, mechOid, (GssCredential)gSSCredential, this.logger);
            return gssContext;
        }
        finally {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SspiMechanism.getContextForInit took " + (System.currentTimeMillis() - l) + " ms");
            }
        }
    }

    @Override
    public boolean initable(GSSCredential gSSCredential, GSSName gSSName, int n, Object[] objectArray, int n2) {
        if (gSSName == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("GSSException.BAD_NAME: target name cannot be null");
            }
            return false;
        }
        if ((0x7F & n2) == n2) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("unable to support requested services");
            this.logger.debug("servicesAvailable are 127");
            this.logger.debug("servicesRequested are " + n2);
        }
        return false;
    }

    @Override
    public GSSCredential createCredential(GSSName gSSName, int n, int n2) throws GSSException {
        GssName gssName;
        if (gSSName == null) {
            gssName = null;
        } else if (gSSName instanceof GssName) {
            gssName = (GssName)gSSName;
        } else {
            throw new TdgssException(3);
        }
        return new GssCredential(gssName, n, n2);
    }

    @Override
    public GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        if (oid != null && oid.equals(TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16)) {
            byte[] byArray2;
            try {
                String string = new String(byArray, "UTF-16");
                byArray2 = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
                return null;
            }
            return new GssName(byArray2, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8);
        }
        return new GssName(byArray, oid);
    }

    @Override
    public Oid[] getNames() {
        return new Oid[]{GSSName.NT_HOSTBASED_SERVICE, TdgssName.GSS_C_NT_TDAT_MECHDATA, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF8, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF16, TdgssName.GSS_C_NT_TDAT_MECHDATA_UTF32};
    }

    @Override
    public Oid getMech() {
        return mechOid;
    }

    @Override
    public int getServices() {
        return 127;
    }

    public void setServices(GSSContext gSSContext, int n) throws GSSException {
        if ((n & 1) != 0) {
            gSSContext.requestCredDeleg(true);
        }
        if ((n & 2) != 0) {
            gSSContext.requestMutualAuth(true);
        }
        if ((n & 4) != 0) {
            gSSContext.requestReplayDet(true);
        }
        if ((n & 8) != 0) {
            gSSContext.requestSequenceDet(true);
        }
        if ((n & 0x10) != 0) {
            gSSContext.requestAnonymity(true);
        }
        if ((n & 0x20) != 0) {
            gSSContext.requestConf(true);
        }
        if ((n & 0x40) != 0) {
            gSSContext.requestInteg(true);
        }
    }

    static {
        try {
            _mechOid = new Oid("1.2.840.113554.1.2.2");
            _gssOid = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException gSSException) {
            throw new ExceptionInInitializerError(gSSException);
        }
        mechOid = _mechOid;
        gssOid = _gssOid;
    }
}

