/*
 * Decompiled with CFR 0.152.
 */
package com.thimbleware.jmemcached;

import com.thimbleware.jmemcached.Cache;
import com.thimbleware.jmemcached.CacheElement;
import com.thimbleware.jmemcached.protocol.binary.MemcachedBinaryPipelineFactory;
import com.thimbleware.jmemcached.protocol.text.MemcachedPipelineFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroupFuture;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.ServerSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemCacheDaemon<CACHE_ELEMENT extends CacheElement> {
    final Logger log = LoggerFactory.getLogger(MemCacheDaemon.class);
    public static String memcachedVersion = "0.9";
    private int frameSize = 0x2000000;
    private boolean binary = false;
    private boolean verbose;
    private int idleTime;
    private InetSocketAddress addr;
    private Cache<CACHE_ELEMENT> cache;
    private boolean running = false;
    private ServerSocketChannelFactory channelFactory;
    private DefaultChannelGroup allChannels;

    public MemCacheDaemon() {
    }

    public MemCacheDaemon(Cache<CACHE_ELEMENT> cache) {
        this.cache = cache;
    }

    public void start() {
        this.channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.allChannels = new DefaultChannelGroup("jmemcachedChannelGroup");
        ServerBootstrap bootstrap = new ServerBootstrap((ChannelFactory)this.channelFactory);
        ChannelPipelineFactory pipelineFactory = this.binary ? this.createMemcachedBinaryPipelineFactory(this.cache, memcachedVersion, this.verbose, this.idleTime, this.allChannels) : this.createMemcachedPipelineFactory(this.cache, memcachedVersion, this.verbose, this.idleTime, this.frameSize, this.allChannels);
        bootstrap.setPipelineFactory(pipelineFactory);
        bootstrap.setOption("sendBufferSize", (Object)65536);
        bootstrap.setOption("receiveBufferSize", (Object)65536);
        Channel serverChannel = bootstrap.bind((SocketAddress)this.addr);
        this.allChannels.add(serverChannel);
        this.log.info("Listening on " + String.valueOf(this.addr.getHostName()) + ":" + this.addr.getPort());
        this.running = true;
    }

    protected ChannelPipelineFactory createMemcachedBinaryPipelineFactory(Cache cache, String memcachedVersion, boolean verbose, int idleTime, DefaultChannelGroup allChannels) {
        return new MemcachedBinaryPipelineFactory(cache, memcachedVersion, verbose, idleTime, allChannels);
    }

    protected ChannelPipelineFactory createMemcachedPipelineFactory(Cache cache, String memcachedVersion, boolean verbose, int idleTime, int receiveBufferSize, DefaultChannelGroup allChannels) {
        return new MemcachedPipelineFactory(cache, memcachedVersion, verbose, idleTime, receiveBufferSize, allChannels);
    }

    public void stop() {
        this.log.info("terminating daemon; closing all channels");
        ChannelGroupFuture future = this.allChannels.close();
        future.awaitUninterruptibly();
        if (!future.isCompleteSuccess()) {
            throw new RuntimeException("failure to complete closing all network channels");
        }
        this.log.info("channels closed, freeing cache storage");
        try {
            this.cache.close();
        }
        catch (IOException e) {
            throw new RuntimeException("exception while closing storage", e);
        }
        this.channelFactory.releaseExternalResources();
        this.running = false;
        this.log.info("successfully shut down");
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setIdleTime(int idleTime) {
        this.idleTime = idleTime;
    }

    public void setAddr(InetSocketAddress addr) {
        this.addr = addr;
    }

    public Cache<CACHE_ELEMENT> getCache() {
        return this.cache;
    }

    public void setCache(Cache<CACHE_ELEMENT> cache) {
        this.cache = cache;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public void setBinary(boolean binary) {
        this.binary = binary;
    }
}

