/*
 * Decompiled with CFR 0.152.
 */
package com.toomuchcoding.jsonassert;

import com.toomuchcoding.jsonassert.JsonAsserterConfiguration;
import com.toomuchcoding.jsonassert.JsonVerifiable;
import com.toomuchcoding.jsonassert.NamelessArrayHavingFieldAssertion;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import shaded.com.jayway.jsonpath.DocumentContext;
import shaded.com.jayway.jsonpath.JsonPath;

public class JsonAssertion {
    private final DocumentContext parsedJson;
    private final LinkedList<String> jsonPathBuffer = new LinkedList();
    private final JsonAsserterConfiguration jsonAsserterConfiguration = new JsonAsserterConfiguration();
    private static final Map<String, DocumentContext> CACHE = new ConcurrentHashMap<String, DocumentContext>();

    private JsonAssertion(DocumentContext parsedJson) {
        this.parsedJson = parsedJson;
    }

    private JsonAssertion(String body) {
        DocumentContext documentContext = CACHE.get(body);
        if (documentContext == null && !this.empty(body)) {
            documentContext = JsonPath.parse(body);
            CACHE.put(body, documentContext);
        }
        this.parsedJson = documentContext;
    }

    private boolean empty(String text) {
        return text == null || text.length() == 0 || text.matches("^\\s*$");
    }

    public static JsonVerifiable assertThat(String body) {
        return new JsonAssertion(body).root();
    }

    public static JsonVerifiable assertThat(DocumentContext parsedJson) {
        return new JsonAssertion(parsedJson).root();
    }

    public static JsonVerifiable assertThatJson(String body) {
        return JsonAssertion.assertThat(body);
    }

    public static JsonVerifiable assertThatJson(DocumentContext parsedJson) {
        return JsonAssertion.assertThat(parsedJson);
    }

    private JsonVerifiable root() {
        NamelessArrayHavingFieldAssertion asserter = new NamelessArrayHavingFieldAssertion(this.parsedJson, this.jsonPathBuffer, "", this.jsonAsserterConfiguration);
        asserter.jsonPathBuffer.offer("$");
        return asserter;
    }
}

