/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.support.beans;

import com.totsp.mavenplugin.gwt.support.beans.Bean;
import de.hunsicker.jalopy.Jalopy;
import java.beans.IntrospectionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.transform.JDOMSource;

public class BeanGeneratorBase {
    private static HashSet<File> writtenFiles = new HashSet();
    private static HashMap<String, Element> baseClasses = new HashMap();
    private static HashMap<String, Element> allClasses = new HashMap();

    protected BeanGeneratorBase() {
    }

    public static void buildBeanElements(String packageName, Bean bean) {
        String cannonical = bean.clazz.getCanonicalName();
        if (allClasses.containsKey(cannonical)) {
            return;
        }
        Element clazz = new Element("class");
        clazz.addContent((Content)new Element("package").setText(BeanGeneratorBase.getPackageName(bean.clazz))).addContent((Content)new Element("shortName").setText(bean.clazz.getSimpleName())).addContent((Content)new Element("extends").addContent((Content)new Element("package").setText(BeanGeneratorBase.getPackageName(bean.clazz.getSuperclass()))).addContent((Content)new Element("shortName").setText(bean.clazz.getSuperclass().getSimpleName())));
        for (Map.Entry<String, Bean> entry : bean.properties.entrySet()) {
            Bean prop = new Element("property").addContent((Content)new Element("name").setText(entry.getKey())).addContent((Content)new Element("package").setText(BeanGeneratorBase.getPackageName(entry.getValue().clazz))).addContent((Content)new Element("shortName").setText(entry.getValue().clazz.getSimpleName()));
            if (entry.getValue().getArrayDepth() > 0) {
                prop.addContent((Content)new Element("arrayDepth").setText("" + entry.getValue().getArrayDepth()));
            }
            for (Bean p : entry.getValue().getParameterTypes()) {
                prop.addContent((Content)new Element("parameterType").addContent((Content)new Element("package").setText(BeanGeneratorBase.getPackageName(p.clazz))).addContent((Content)new Element("shortName").setText(p.clazz.getSimpleName())));
            }
            clazz.addContent((Content)prop);
        }
        boolean found = false;
        for (String outterClassName : allClasses.keySet()) {
            if (!cannonical.substring(0, cannonical.lastIndexOf(".")).equals(outterClassName)) continue;
            allClasses.get(outterClassName).addContent((Content)clazz);
            found = true;
            break;
        }
        if (!found) {
            baseClasses.put(cannonical, clazz);
        }
        allClasses.put(cannonical, clazz);
        for (Bean prop : bean.properties.values()) {
            if (prop.isCustom()) {
                BeanGeneratorBase.buildBeanElements(packageName, prop);
            }
            for (Bean param : prop.getParameterTypes()) {
                if (!param.isCustom()) continue;
                BeanGeneratorBase.buildBeanElements(packageName, param);
            }
        }
        for (Bean param : bean.getParameterTypes()) {
            if (!param.isCustom()) continue;
            BeanGeneratorBase.buildBeanElements(packageName, param);
        }
        if (bean.parent != null && bean.parent.isCustom()) {
            BeanGeneratorBase.buildBeanElements(packageName, bean.parent);
        }
    }

    public static void writeBean(String packageName, File packageDirectory, boolean getSet, boolean propSupport, Bean bean) throws IOException, IntrospectionException {
        BeanGeneratorBase.writeBean(packageName, packageDirectory, getSet, propSupport, false, bean);
    }

    public static void writeBean(String packageName, File packageDirectory, boolean getSet, boolean propSupport, boolean overwrite, Bean bean) throws IOException, IntrospectionException {
        BeanGeneratorBase.buildBeanElements(packageName, bean);
        for (Map.Entry<String, Element> entry : baseClasses.entrySet()) {
            String beanName = entry.getKey().substring(entry.getKey().lastIndexOf(".") + 1);
            File javaFile = new File(packageDirectory, beanName + ".java");
            if (!overwrite) {
                int i = 0;
                while (javaFile.exists()) {
                    beanName = beanName + i;
                    javaFile = new File(packageDirectory, beanName + ".java");
                    ++i;
                }
            }
            writtenFiles.add(javaFile);
            System.out.print("Generating: " + bean.clazz.getCanonicalName());
            System.out.println(" to file: " + javaFile.getAbsolutePath());
            TransformerFactory xformFactory = TransformerFactory.newInstance();
            try {
                Transformer transformer = xformFactory.newTransformer(new StreamSource(BeanGeneratorBase.class.getResourceAsStream("./DTO.xsl")));
                transformer.setParameter("propertyChangeSupport", propSupport ? "yes" : "no");
                transformer.setParameter("gettersAndSetters", getSet ? "yes" : "no");
                transformer.setParameter("destinationPackage", packageName);
                Document doc = new Document();
                doc.setRootElement(entry.getValue());
                transformer.transform((Source)new JDOMSource(doc), new StreamResult(new FileOutputStream(javaFile)));
                doc.detachRootElement();
                Jalopy jalopy = new Jalopy();
                jalopy.setInput(javaFile);
                jalopy.setOutput(javaFile);
                jalopy.format();
                if (jalopy.getState() == Jalopy.State.OK) {
                    System.out.println(javaFile + " successfully formatted");
                    continue;
                }
                if (jalopy.getState() == Jalopy.State.WARN) {
                    System.out.println(javaFile + " formatted with warnings");
                    continue;
                }
                if (jalopy.getState() != Jalopy.State.ERROR) continue;
                System.out.println(javaFile + " could not be formatted");
            }
            catch (TransformerConfigurationException ex) {
                ex.printStackTrace();
            }
            catch (TransformerException ex) {
                ex.printStackTrace();
            }
        }
    }

    static String getPackageName(Class clazz) {
        return clazz.getCanonicalName().indexOf(".") == -1 ? "java.lang" : clazz.getCanonicalName().substring(0, clazz.getCanonicalName().lastIndexOf("."));
    }
}

