/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.support.beans;

import com.totsp.mavenplugin.gwt.support.beans.Bean;
import com.totsp.mavenplugin.gwt.support.beans.Generator;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;

public class GlobalGeneratorContext {
    private HashMap<String, String> processedBeans = new HashMap();
    private HashMap<String, String> translatedClasses = new HashMap();
    private HashSet<File> writtenFiles = new HashSet();
    private boolean getSet;
    private boolean propSupport;
    private boolean overwriteGeneratedClasses;
    private HashMap properties = new HashMap();

    public GlobalGeneratorContext(boolean getSet, boolean propSupport, boolean overwriteGeneratedClasses) {
        this.getSet = getSet;
        this.propSupport = propSupport;
        this.overwriteGeneratedClasses = overwriteGeneratedClasses;
    }

    public File CreateFile(String packageDir, String baseName) {
        return this.CreateFile(packageDir, baseName, ".java");
    }

    public File CreateFile(String packageDir, String baseName, String extension) {
        File javaFile = new File(packageDir, baseName + extension);
        if (!this.isOverwriteGeneratedClasses()) {
            int i = 0;
            while (javaFile.exists()) {
                javaFile = new File(packageDir, baseName + i + extension);
                ++i;
            }
        } else {
            int i = 0;
            while (this.writtenFiles.contains(javaFile)) {
                javaFile = new File(packageDir, baseName + i + extension);
                ++i;
            }
        }
        this.writtenFiles.add(javaFile);
        return javaFile;
    }

    public String getTranslatedName(String classname) {
        return this.translatedClasses.get(classname);
    }

    public void putTranslatedName(String classname, String translatedName) {
        this.translatedClasses.put(classname, translatedName);
    }

    public boolean hasBeanBeenProcessed(Bean bean, Generator gen) {
        String key = gen.getClass().getName() + "->" + bean.clazz.getName();
        return this.processedBeans.containsKey(key);
    }

    public void markBeanAsProcessed(Bean bean, Generator gen) {
        String key = gen.getClass().getName() + "->" + bean.clazz.getName();
        this.processedBeans.put(key, key);
    }

    public HashMap getProperties() {
        return this.properties;
    }

    public void setProperties(HashMap properties) {
        this.properties = properties;
    }

    public boolean isGetSet() {
        return this.getSet | this.propSupport;
    }

    public void setGetSet(boolean getSet) {
        this.getSet = getSet;
    }

    public boolean isPropSupport() {
        return this.propSupport;
    }

    public void setPropSupport(boolean propSupport) {
        this.propSupport = propSupport;
    }

    public boolean isOverwriteGeneratedClasses() {
        return this.overwriteGeneratedClasses;
    }

    public void setOverwriteGeneratedClasses(boolean overwriteGeneratedClasses) {
        this.overwriteGeneratedClasses = overwriteGeneratedClasses;
    }
}

