/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.support.beans;

import com.totsp.mavenplugin.gwt.support.beans.Bean;
import com.totsp.mavenplugin.gwt.support.beans.Generator;
import com.totsp.mavenplugin.gwt.support.beans.GlobalGeneratorContext;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanGeneratorContext {
    private final GlobalGeneratorContext globalContext;
    private final Bean bean;
    private Generator gen;
    HashMap<String, String> importMap = new HashMap();

    public BeanGeneratorContext(GlobalGeneratorContext globalContext, Bean bean) {
        this(globalContext, bean, null);
    }

    public BeanGeneratorContext(GlobalGeneratorContext globalContext, Bean bean, Generator gen) {
        this(globalContext, bean, gen, null);
    }

    public BeanGeneratorContext(GlobalGeneratorContext globalContext, Bean bean, Generator gen, HashMap<String, String> importMap) {
        this.globalContext = globalContext;
        this.bean = bean;
        this.setGen(gen);
        this.importMap = importMap;
    }

    public boolean markAsGenerated() {
        if (!this.globalContext.hasBeanBeenProcessed(this.bean, this.gen)) {
            this.globalContext.markBeanAsProcessed(this.bean, this.gen);
            return false;
        }
        return true;
    }

    public static String[] getImportList(String packageName, HashMap<String, String> importMap) {
        ArrayList<String> keepers = new ArrayList<String>(importMap.size());
        for (String curr : importMap.values()) {
            boolean inSamePackage;
            boolean bl = inSamePackage = curr.startsWith(packageName) && curr.lastIndexOf(46) == packageName.length();
            if (curr.startsWith("java.lang") || inSamePackage) continue;
            keepers.add(curr);
        }
        Object[] importArray = keepers.toArray(new String[0]);
        Arrays.sort(importArray);
        return importArray;
    }

    public void writeImportList(PrintWriter pw, String packageName) {
        String[] imports;
        for (String str : imports = BeanGeneratorContext.getImportList(packageName, this.importMap)) {
            pw.print("import ");
            pw.print(str);
            pw.println(";");
        }
    }

    public String getParentName() throws IOException {
        if (this.bean.parent == null) {
            return null;
        }
        return this.resolveTranslatedType(this.bean.parent);
    }

    protected String resolveTranslatedType(Bean bean) throws IOException {
        Class clazz = bean.getType();
        String type = null;
        if (clazz == Integer.TYPE) {
            type = "int";
        } else if (clazz == Long.TYPE) {
            type = "long";
        } else if (clazz == Float.TYPE) {
            type = "float";
        } else if (clazz == Double.TYPE) {
            type = "double";
        } else if (clazz == Boolean.TYPE) {
            type = "boolean";
        } else if (clazz == Character.TYPE) {
            type = "char";
        } else if (clazz == Byte.TYPE) {
            type = "byte";
        } else {
            if (bean.isCustom()) {
                this.getGen().Generate(new BeanGeneratorContext(this.getGlobalContext(), bean, this.getGen(), this.getGen().getImportMap()));
                type = this.getGlobalContext().getTranslatedName(bean.getType().getName());
            } else {
                type = clazz.getName();
            }
            type = this.getUsableClassName(type);
        }
        return type;
    }

    protected String resolveOriginalType(Bean bean) {
        Class clazz = bean.getType();
        String type = null;
        type = clazz == Integer.TYPE ? "int" : (clazz == Long.TYPE ? "long" : (clazz == Float.TYPE ? "float" : (clazz == Double.TYPE ? "double" : (clazz == Boolean.TYPE ? "boolean" : (clazz == Character.TYPE ? "char" : (clazz == Byte.TYPE ? "byte" : this.getUsableClassName(clazz.getName())))))));
        return type;
    }

    public String getUsableClassName(String type) {
        String enclosingClassNameFQ;
        String[] nameParts = type.split("\\.");
        String simpleName = nameParts[nameParts.length - 1];
        String packageName = type.substring(0, type.length() - simpleName.length() - 1);
        String[] nestedNames = simpleName.split("\\$");
        String enclosingClassName = nestedNames[0];
        String retVal = enclosingClassNameFQ = packageName + "." + nestedNames[0];
        if (!this.importMap.containsKey(enclosingClassName) || this.importMap.get(enclosingClassName).equals(enclosingClassNameFQ)) {
            this.importMap.put(enclosingClassName, enclosingClassNameFQ);
            retVal = enclosingClassName;
        }
        if (nestedNames.length > 1) {
            StringBuffer buff = new StringBuffer(retVal);
            for (int i = 1; i < nestedNames.length; ++i) {
                buff.append(".").append(nestedNames[i]);
            }
            retVal = buff.toString();
        }
        return retVal;
    }

    public GlobalGeneratorContext getGlobalContext() {
        return this.globalContext;
    }

    public Bean getBean() {
        return this.bean;
    }

    public Generator getGen() {
        return this.gen;
    }

    public void setGen(Generator gen) {
        this.gen = gen;
    }

    public String getGetPrefix() {
        return this.getBean().getGetPrefix();
    }

    public String getGeneratedGet(String object, String attr) {
        return this.getBean().getGeneratedGet(object, attr, this.getGlobalContext().isGetSet());
    }

    public String getGeneratedSet(String object, String attr, String value) {
        return this.getBean().getGeneratedSet(object, attr, value, this.getGlobalContext().isGetSet());
    }

    public String getOriginalGet(String object, String attr) {
        return this.getBean().getOriginalGet(object, attr);
    }

    public String getOriginalSet(String object, String attr, String value) {
        return this.getBean().getOriginalSet(object, attr, value);
    }
}

