/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.support.beans;

import com.totsp.mavenplugin.gwt.support.beans.Bean;
import com.totsp.mavenplugin.gwt.support.beans.BeanGeneratorContext;
import com.totsp.mavenplugin.gwt.support.beans.Generator;
import com.totsp.mavenplugin.gwt.support.beans.GlobalGeneratorContext;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatorGenerator
implements Generator {
    protected static HashMap<Class, CollectionInfo> collectionInfo = new HashMap();
    File packageDir;
    String className = "Translater";
    String packageName;
    String beanPackageName;
    File fileName;
    boolean twoWay;
    HashMap<Class, String> translatorMap = new HashMap();
    HashMap<String, String> importMap = new HashMap();
    ArrayList<String> methods = new ArrayList();

    public TranslatorGenerator(String packageName, File packageDir, String beanPackageName, boolean twoWay) {
        this.packageName = packageName;
        this.packageDir = packageDir;
        this.beanPackageName = beanPackageName;
        this.twoWay = twoWay;
    }

    protected void writeHeader(PrintWriter pw, String parentName) {
        String[] imports;
        pw.print("package ");
        pw.print(this.packageName);
        pw.println(";\n");
        for (String str : imports = BeanGeneratorContext.getImportList(this.packageName, this.importMap)) {
            pw.print("import ");
            pw.print(str);
            pw.println(";");
        }
        pw.print("\n\n");
        pw.print("public class ");
        pw.print(this.className);
        if (parentName != null) {
            pw.print(" extends ");
            pw.print(parentName);
        }
        pw.println(" {");
    }

    public void fun() {
    }

    protected String getTabDepth(int depth) {
        StringBuffer buf = new StringBuffer(depth + 1);
        for (int i = 0; i <= depth + 1; ++i) {
            buf.append("\t\t");
        }
        return buf.toString();
    }

    protected char getVarNameForDepth(int depth) {
        return (char)(97 + depth);
    }

    protected String getPreviousArrayString(String attr, int depth, boolean isGetSet) {
        if (depth == 0) {
            return isGetSet ? "get" + Bean.getCamelCase(attr) + "()" : attr;
        }
        return this.getPreviousArrayString(attr, depth - 1, isGetSet) + "[" + this.getVarNameForDepth(depth - 1) + "]";
    }

    protected String getArrayString(String attr, int depth, boolean isGetSet) {
        return this.getPreviousArrayString(attr, depth, isGetSet) + "[" + this.getVarNameForDepth(depth) + "]";
    }

    protected String getArrayType(String baseType, String sizeToAllocate, int totalDepth, int currDepth) {
        StringBuffer buff = new StringBuffer(baseType);
        for (int i = currDepth; i < totalDepth; ++i) {
            if (i == currDepth) {
                buff.append("[").append(sizeToAllocate).append("]");
                continue;
            }
            buff.append("[]");
        }
        return buff.toString();
    }

    public void writeSnippet(PrintWriter pw, String src, String dest, String attName, Bean attType, int depth, ParamGen srcGen, ParamGen destGen) throws IOException {
        String tab = this.getTabDepth(depth);
        char variableName = this.getVarNameForDepth(depth);
        String DestAttType = destGen.resolveType(attType);
        if (attType.getArrayDepth() > depth) {
            String srcArray = src + "." + this.getPreviousArrayString(attName, depth, srcGen.isGetSet());
            String destArray = dest + "." + this.getPreviousArrayString(attName, depth, destGen.isGetSet());
            if (attType.getArrayDepth() > depth) {
                pw.println(tab + "if (" + srcArray + " != null) {");
                if (depth == 0) {
                    pw.println(tab + "\t" + destGen.getSet(dest, attName, " new " + this.getArrayType(DestAttType, srcArray + ".length", attType.getArrayDepth(), depth)) + ";");
                } else {
                    pw.println(tab + "\t" + destArray + " = new " + this.getArrayType(DestAttType, srcArray + ".length", attType.getArrayDepth(), depth) + ";");
                }
                pw.println(tab + "\tfor(int " + variableName + "=0; " + variableName + "<" + srcArray + ".length; " + variableName + "++) {");
                if (depth == attType.getArrayDepth() - 1) {
                    String nextSrcArray = src + "." + this.getArrayString(attName, depth, srcGen.isGetSet());
                    String nextDestArray = dest + "." + this.getArrayString(attName, depth, destGen.isGetSet());
                    this.writeSnippet(pw, nextSrcArray, nextDestArray, attName, attType, depth + 1, srcGen, destGen);
                } else {
                    this.writeSnippet(pw, src, dest, attName, attType, depth + 1, srcGen, destGen);
                }
                pw.println(tab + "\t}");
                pw.println(tab + "}");
            }
        } else if (attType.isBaseType()) {
            if (attName != null && depth == 0) {
                pw.println(tab + destGen.getSet(dest, attName, srcGen.getGet(src, attName)) + ";");
            } else {
                pw.println(tab + dest + "=" + src + ";");
            }
        } else if (attType.isCollectionType()) {
            CollectionInfo info = collectionInfo.get(attType.getType());
            if (depth == 0) {
                pw.println(tab + "if (" + srcGen.getGet(src, attName) + " != null) {");
                pw.println(tab + "\t" + destGen.getSet(dest, attName, info.allocString) + ";");
            } else {
                pw.println(tab + "if (" + src + " != null) {");
                pw.println(tab + "\t" + dest + "=" + info.allocString + ";");
            }
            String iteratorName = "iter_" + variableName;
            pw.print(tab + "\t" + srcGen.getUsableClassName("java.util.Iterator") + " " + iteratorName + "=");
            String localSrc = depth == 0 ? srcGen.getGet(src, attName) : src;
            switch (info.addType) {
                case collection: 
                case stack: {
                    pw.println(localSrc + ".iterator();");
                    break;
                }
                case map: {
                    pw.println(localSrc + ".keySet().iterator();");
                    break;
                }
            }
            pw.println(tab + "\twhile (" + iteratorName + ".hasNext()) {");
            pw.println("");
            String varSrc1 = "varSrc_" + variableName;
            String varDest1 = "varDest_" + variableName;
            String varSrc2 = "varSrc2_" + variableName;
            String varDest2 = "varDest2_" + variableName;
            switch (info.addType) {
                case collection: 
                case stack: {
                    Bean param1 = attType.getParameterTypes().get(0);
                    String param1DestType = destGen.resolveType(param1);
                    String param1SrcType = srcGen.resolveType(param1);
                    pw.println(tab + "\t" + param1DestType + " " + varDest1 + ";");
                    pw.println(tab + "\t" + param1SrcType + " " + varSrc1 + "=(" + param1SrcType + ")" + iteratorName + ".next();");
                    this.writeSnippet(pw, varSrc1, varDest1, attName, param1, depth + 1, srcGen, destGen);
                    String grossCast = "((" + srcGen.getUsableClassName("java.util.Collection") + ")";
                    if (depth == 0) {
                        pw.println(tab + "\t" + grossCast + destGen.getGet(dest, attName) + ").add(" + varDest1 + ");");
                        break;
                    }
                    pw.println(tab + "\t" + grossCast + dest + ").add(" + varDest1 + ");");
                    break;
                }
                case map: {
                    Bean param1 = attType.getParameterTypes().get(0);
                    String param1DestType1 = destGen.resolveType(param1);
                    String param1SrcType1 = srcGen.resolveType(param1);
                    Bean param2 = attType.getParameterTypes().get(1);
                    String param1DestType2 = destGen.resolveType(param2);
                    String param1SrcType2 = srcGen.resolveType(param2);
                    pw.println(tab + "\t" + param1DestType1 + " " + varDest1 + ";");
                    pw.println(tab + "\t" + param1SrcType1 + " " + varSrc1 + "=(" + param1SrcType1 + ")" + iteratorName + ".next();");
                    pw.println(tab + "\t" + param1DestType2 + " " + varDest2 + ";");
                    pw.println(tab + "\t" + param1SrcType2 + " " + varSrc2 + "=(" + param1SrcType2 + ")" + localSrc + ".get( " + varSrc1 + ");");
                    this.writeSnippet(pw, varSrc1, varDest1, attName, param1, depth + 1, srcGen, destGen);
                    this.writeSnippet(pw, varSrc2, varDest2, attName, param2, depth + 1, srcGen, destGen);
                    String grossCast = "((" + srcGen.getUsableClassName("java.util.Map") + ")";
                    if (depth == 0) {
                        pw.println(tab + "\t" + grossCast + destGen.getGet(dest, attName) + ").put(" + varDest1 + ", " + varDest2 + ");");
                        break;
                    }
                    pw.println(tab + "\t" + grossCast + dest + ").put(" + varDest1 + ", " + varDest2 + ");");
                    break;
                }
            }
            pw.println(tab + "\t}");
            pw.println(tab + "}");
        } else {
            String varDest1 = "varDest_" + variableName;
            if (attName == null) {
                varDest1 = dest;
                pw.println(tab + "\t\ttranslate(" + src + ", " + varDest1 + ");");
            } else {
                if (depth == 0) {
                    pw.println(tab + "\tif (" + srcGen.getGet(src, attName) + " != null) {");
                    pw.println(tab + "\t\t" + DestAttType + " " + varDest1 + "= new " + DestAttType + "();");
                    pw.print(tab + "\t\t" + destGen.getSet(dest, attName, varDest1) + ";");
                    pw.println(tab + "\t\ttranslate(" + srcGen.getGet(src, attName) + ", " + varDest1 + ");");
                    pw.println(tab + "\t} else {");
                    pw.print(tab + "\t\t" + destGen.getSet(dest, attName, "null") + ";");
                } else {
                    pw.println(tab + "\tif (" + src + " != null) {");
                    pw.println(tab + "\t\t" + DestAttType + " " + varDest1 + "= new " + DestAttType + "();");
                    pw.println(tab + "\t\t" + dest + "= " + varDest1 + ";");
                    pw.println(tab + "\t\ttranslate(" + src + ", " + varDest1 + ");");
                    pw.println(tab + "\t} else {");
                    pw.println(tab + "\t\t" + dest + "= " + null + ";");
                }
                pw.println(tab + "\t}");
            }
        }
    }

    public String getTranlatorName(Bean attribute, BeanGeneratorContext beanContext) throws IOException {
        if (!this.translatorMap.containsKey(attribute.getType())) {
            assert (false);
            this.Generate(new BeanGeneratorContext(beanContext.getGlobalContext(), attribute, this, this.getImportMap()));
        }
        return this.translatorMap.get(attribute.getType());
    }

    public void writeOneArgTranslate(PrintWriter pw, String srcType, String destType) {
        pw.println("\tpublic static " + destType + " translate(" + srcType + " src) throws Exception {");
        pw.println("\t\t" + destType + " var = new " + destType + "();");
        pw.println("\t\ttranslate(src, var);");
        pw.println("\t\treturn var;");
        pw.println("\t}");
    }

    public void writeTwoArgTranslate(PrintWriter pw, Bean bean, String srcType, String destType, ParamGen srcGen, ParamGen destGen) throws IOException {
        pw.println("\tpublic static void translate(" + srcType + " src, " + destType + " dest) throws Exception {");
        if (bean.parent != null) {
            pw.println("\t\t{ //Translate Parent Class");
            this.writeSnippet(pw, "(" + srcGen.resolveType(bean.parent) + ")src", "(" + destGen.resolveType(bean.parent) + ")dest", null, bean.parent, 0, srcGen, destGen);
            pw.println("\t\t}\n");
        }
        for (String propertyName : bean.properties.keySet()) {
            Bean propertyType = bean.properties.get(propertyName);
            pw.println("\t\t{ //Translate " + propertyName);
            this.writeSnippet(pw, "src", "dest", propertyName, propertyType, 0, srcGen, destGen);
            pw.println("\t\t}\n");
        }
        pw.println("\t}\n");
    }

    public void writeMethods(PrintWriter pw, BeanGeneratorContext beanContext) throws IOException {
        Bean bean = beanContext.getBean();
        if (this.translatorMap.containsKey(bean.getType())) {
            return;
        }
        this.translatorMap.put(bean.getType(), "translate");
        String OriginalTypeName = beanContext.resolveOriginalType(bean);
        String GeneratedTypeName = beanContext.resolveTranslatedType(bean);
        this.writeOneArgTranslate(pw, OriginalTypeName, GeneratedTypeName);
        if (this.twoWay) {
            this.writeOneArgTranslate(pw, GeneratedTypeName, OriginalTypeName);
        }
        OriginalParamGen origGen = new OriginalParamGen(beanContext);
        TranslatedParamGen translatedGen = new TranslatedParamGen(beanContext);
        this.writeTwoArgTranslate(pw, bean, OriginalTypeName, GeneratedTypeName, origGen, translatedGen);
        if (this.twoWay) {
            this.writeTwoArgTranslate(pw, bean, GeneratedTypeName, OriginalTypeName, translatedGen, origGen);
        }
    }

    @Override
    public void Init(GlobalGeneratorContext globalContext) throws Exception {
        this.fileName = globalContext.CreateFile(this.packageDir.toString(), this.className);
    }

    @Override
    public void Generate(BeanGeneratorContext beanContext) throws IOException {
        System.out.println(beanContext.getBean().getArrayDepth() + " " + beanContext.getBean().clazz);
        if (beanContext.markAsGenerated()) {
            return;
        }
        beanContext.getGlobalContext().putTranslatedName(beanContext.getBean().clazz.getName(), this.beanPackageName + "." + beanContext.getBean().clazz.getSimpleName());
        StringWriter body = new StringWriter();
        this.writeMethods(new PrintWriter(body), beanContext);
        this.methods.add(body.getBuffer().toString());
    }

    @Override
    public void Finish(GlobalGeneratorContext globalContext) throws Exception {
        PrintWriter pw = new PrintWriter(this.fileName);
        this.writeHeader(pw, null);
        for (String str : this.methods) {
            pw.println(str);
        }
        pw.println("}");
        pw.flush();
        pw.close();
    }

    @Override
    public HashMap<String, String> getImportMap() {
        return this.importMap;
    }

    static {
        collectionInfo.put(Map.class, new CollectionInfo("new java.util.HashMap()", AddType.map));
        collectionInfo.put(HashMap.class, new CollectionInfo("new java.util.HashMap()", AddType.map));
        collectionInfo.put(Collection.class, new CollectionInfo("new java.util.ArrayList()", AddType.collection));
        collectionInfo.put(List.class, new CollectionInfo("new java.util.ArrayList()", AddType.collection));
        collectionInfo.put(ArrayList.class, new CollectionInfo("new java.util.ArrayList()", AddType.collection));
        collectionInfo.put(Set.class, new CollectionInfo("new java.util.HashSet()", AddType.collection));
        collectionInfo.put(HashSet.class, new CollectionInfo("new java.util.HashSet()", AddType.collection));
        collectionInfo.put(Vector.class, new CollectionInfo("new java.util.Vector()", AddType.collection));
        collectionInfo.put(Stack.class, new CollectionInfo("new java.util.Stack()", AddType.stack));
        collectionInfo.put(Stack.class, new CollectionInfo("null", AddType.iterator));
    }

    protected static class TranslatedParamGen
    extends ParamGen {
        protected TranslatedParamGen(BeanGeneratorContext beanContext) {
            super(beanContext, beanContext.getGlobalContext().isGetSet());
        }

        public String resolveType(Bean attType) throws IOException {
            return this.beanContext.resolveTranslatedType(attType);
        }

        public String getGet(String object, String attr) {
            return this.beanContext.getGeneratedGet(object, attr);
        }

        public String getSet(String object, String attr, String value) {
            return this.beanContext.getGeneratedSet(object, attr, value);
        }
    }

    protected static class OriginalParamGen
    extends ParamGen {
        protected OriginalParamGen(BeanGeneratorContext beanContext) {
            super(beanContext, true);
        }

        public String resolveType(Bean attType) throws IOException {
            return this.beanContext.resolveOriginalType(attType);
        }

        public String getGet(String object, String attr) {
            return this.beanContext.getOriginalGet(object, attr);
        }

        public String getSet(String object, String attr, String value) {
            return this.beanContext.getOriginalSet(object, attr, value);
        }
    }

    protected static abstract class ParamGen {
        BeanGeneratorContext beanContext;
        boolean isGetSet;

        protected ParamGen(BeanGeneratorContext beanContext, boolean isGetSet) {
            this.beanContext = beanContext;
            this.isGetSet = isGetSet;
        }

        boolean isGetSet() {
            return this.isGetSet;
        }

        public String getUsableClassName(String type) {
            return this.beanContext.getUsableClassName(type);
        }

        abstract String resolveType(Bean var1) throws IOException;

        abstract String getGet(String var1, String var2);

        abstract String getSet(String var1, String var2, String var3);
    }

    public static class CollectionInfo {
        public final String allocString;
        public final AddType addType;

        public CollectionInfo(String allocString, AddType addType) {
            this.allocString = allocString;
            this.addType = addType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AddType {
        collection,
        map,
        stack,
        iterator;

    }
}

