/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt;

import com.totsp.mavenplugin.gwt.support.MakeCatalinaBase;
import com.totsp.mavenplugin.gwt.util.BuildClasspathUtil;
import com.totsp.mavenplugin.gwt.util.DependencyScope;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractGWTMojo
extends AbstractMojo {
    public static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    public static final String GWT_GROUP_ID = "com.google.gwt";
    public static final String WINDOWS = "windows";
    public static final String LINUX = "linux";
    public static final String MAC = "mac";
    public static final String LEOPARD = "leopard";
    public static final String GOOGLE_WEBTOOLKIT_HOME = "google.webtoolkit.home";
    private static final String JAVA_COMMAND = System.getProperty("java.home") != null ? FileUtils.normalize((String)(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java")) : "java";
    private MavenProject project;
    private List pluginClasspathList;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private File buildDir;
    private String gwtVersion;
    private File gwtHome;
    private File output;
    private File gen;
    private String[] compileTarget;
    private String runTarget;
    private String logLevel;
    private String style;
    private boolean noServer;
    private int port;
    private File tomcat;
    private int debugPort;
    private File contextXml;
    private File webXml;
    private boolean webXmlServletPathAsIs;
    private boolean debugSuspend;
    private String jvm;
    private String extraJvmArgs;
    private String testFilter;
    private String extraTestArgs;
    private boolean testSkip;
    private boolean compileSkip;
    private boolean sourcesOnPath;
    private boolean resourcesOnPath;
    private boolean enableAssertions;
    private String shellServletMappingURL;
    private File i18nOutputDir;
    private boolean i18nConstantsWithLookup;
    private String[] i18nMessagesNames;
    private String[] i18nConstantsNames;
    private String[] generatorRootClasses;
    private String generatorDestinationPackage;
    private boolean generateGettersAndSetters;
    private boolean generatePropertyChangeSupport;
    private boolean overwriteGeneratedClasses;
    private String whitelist;
    private String blacklist;
    private boolean showTreeLogger;
    private int localWorkers;
    private File workDir;
    private File extraDir;

    protected ClassLoader fixThreadClasspath() {
        try {
            ClassWorld world = new ClassWorld();
            ClassRealm root = world.newRealm("gwt-plugin", Thread.currentThread().getContextClassLoader());
            ClassRealm realm = root.createChildRealm("gwt-project");
            Iterator<File> it = BuildClasspathUtil.buildClasspathList(this, DependencyScope.COMPILE).iterator();
            while (it.hasNext()) {
                realm.addConstituent(it.next().toURI().toURL());
            }
            Thread.currentThread().setContextClassLoader(realm.getClassLoader());
            return realm.getClassLoader();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void makeCatalinaBase() throws Exception {
        this.getLog().debug((CharSequence)"make catalina base for embedded Tomcat");
        if (this.getWebXml() != null && this.getWebXml().exists()) {
            this.getLog().info((CharSequence)("source web.xml present - " + this.getWebXml() + " - using it with embedded Tomcat"));
        } else {
            this.getLog().info((CharSequence)"source web.xml NOT present, using default empty web.xml for shell");
        }
        String[] args = new String[]{this.getTomcat().getAbsolutePath(), this.getWebXml().getAbsolutePath(), this.getShellServletMappingURL()};
        MakeCatalinaBase.main((String[])args);
        if (this.getContextXml() != null && this.getContextXml().exists()) {
            this.getLog().info((CharSequence)("contextXml parameter present - " + this.getContextXml() + " - using it for embedded Tomcat ROOT.xml"));
            FileUtils.copyFile((File)this.getContextXml(), (File)new File(this.getTomcat(), "conf/gwt/localhost/ROOT.xml"));
        }
    }

    public void setBuildDir(File buildDir) {
        this.buildDir = buildDir;
    }

    public File getBuildDir() {
        return this.buildDir;
    }

    public void setCompileTarget(String[] compileTarget) {
        this.compileTarget = compileTarget;
    }

    public String[] getCompileTarget() {
        return this.compileTarget;
    }

    public void setContextXml(File contextXml) {
        this.contextXml = contextXml;
    }

    public File getContextXml() {
        return this.contextXml;
    }

    public void setJvm(String jvm) {
        this.jvm = jvm;
    }

    public String getJvm() {
        return this.jvm;
    }

    public void setExtraJvmArgs(String extraJvmArgs) {
        this.extraJvmArgs = extraJvmArgs;
    }

    public String getExtraJvmArgs() {
        return this.extraJvmArgs;
    }

    public void setGen(File gen) {
        this.gen = gen;
    }

    public File getGen() {
        return this.gen;
    }

    public void setGwtHome(File gwtHome) {
        this.gwtHome = gwtHome;
    }

    public File getGwtHome() {
        return this.gwtHome;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setNoServer(boolean noServer) {
        this.noServer = noServer;
    }

    public boolean isNoServer() {
        return this.noServer;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public File getOutput() {
        return this.output;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setRunTarget(String runTarget) {
        this.runTarget = runTarget;
    }

    public String getRunTarget() {
        return this.runTarget;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String getStyle() {
        return this.style;
    }

    public void setTomcat(File tomcat) {
        this.tomcat = tomcat;
    }

    public File getTomcat() {
        return this.tomcat;
    }

    public void setWebXml(File webXml) {
        this.webXml = webXml;
    }

    public File getWebXml() {
        return this.webXml;
    }

    public boolean isWebXmlServletPathAsIs() {
        return this.webXmlServletPathAsIs;
    }

    public void setWebXmlServletPathAsIs(boolean webXmlServletPathAsIs) {
        this.webXmlServletPathAsIs = webXmlServletPathAsIs;
    }

    public String getShellServletMappingURL() {
        return this.shellServletMappingURL;
    }

    public void setShellServletMappingURL(String shellServletMappingURL) {
        this.shellServletMappingURL = shellServletMappingURL;
    }

    public String[] getGeneratorRootClasses() {
        return this.generatorRootClasses;
    }

    public void setGeneratorRootClasses(String[] generatorRootClasses) {
        this.generatorRootClasses = generatorRootClasses;
    }

    public String getGeneratorDestinationPackage() {
        return this.generatorDestinationPackage;
    }

    public void setGeneratorDestinationPackage(String generatorDestinationPackage) {
        this.generatorDestinationPackage = generatorDestinationPackage;
    }

    public boolean isGenerateGettersAndSetters() {
        return this.generateGettersAndSetters;
    }

    public void setGenerateGettersAndSetters(boolean generateGettersAndSetters) {
        this.generateGettersAndSetters = generateGettersAndSetters;
    }

    public boolean isGeneratePropertyChangeSupport() {
        return this.generatePropertyChangeSupport;
    }

    public void setGeneratePropertyChangeSupport(boolean generatePropertyChangeSupport) {
        this.generatePropertyChangeSupport = generatePropertyChangeSupport;
    }

    public boolean isOverwriteGeneratedClasses() {
        return this.overwriteGeneratedClasses;
    }

    public void setOverwriteGeneratedClasses(boolean overwriteGeneratedClasses) {
        this.overwriteGeneratedClasses = overwriteGeneratedClasses;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public boolean isDebugSuspend() {
        return this.debugSuspend;
    }

    public void setDebugSuspend(boolean debugSuspend) {
        this.debugSuspend = debugSuspend;
    }

    public String getGwtVersion() {
        return this.gwtVersion;
    }

    public void setGwtVersion(String gwtVersion) {
        this.gwtVersion = gwtVersion;
    }

    public void setCompileTargets(String[] targets) {
        this.compileTarget = targets;
    }

    public String getTestFilter() {
        return this.testFilter;
    }

    public void setTestFilter(String testFilter) {
        this.testFilter = testFilter;
    }

    public boolean getSourcesOnPath() {
        return this.sourcesOnPath;
    }

    public void setSourcesOnPath(boolean value) {
        this.sourcesOnPath = value;
    }

    public boolean getResourcesOnPath() {
        return this.resourcesOnPath;
    }

    public void setResourcesOnPath(boolean resourcesOnPath) {
        this.resourcesOnPath = resourcesOnPath;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public List getPluginClasspathList() {
        return this.pluginClasspathList;
    }

    public void setPluginClasspathList(List pluginClasspathList) {
        this.pluginClasspathList = pluginClasspathList;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public File getI18nOutputDir() {
        return this.i18nOutputDir;
    }

    public void setI18nOutputDir(File outputDir) {
        this.i18nOutputDir = outputDir;
    }

    public boolean isI18nConstantsWithLookup() {
        return this.i18nConstantsWithLookup;
    }

    public void setI18nConstantsWithLookup(boolean i18nConstantsWithLookup) {
        this.i18nConstantsWithLookup = i18nConstantsWithLookup;
    }

    public String[] getI18nMessagesNames() {
        return this.i18nMessagesNames;
    }

    public void setI18nMessagesNames(String[] messagesNames) {
        this.i18nMessagesNames = messagesNames;
    }

    public String[] getI18nConstantsNames() {
        return this.i18nConstantsNames;
    }

    public void setI18nConstantsNames(String[] constantsNames) {
        this.i18nConstantsNames = constantsNames;
    }

    public String getExtraTestArgs() {
        return this.extraTestArgs;
    }

    public void setExtraTestArgs(String extraTestArgs) {
        this.extraTestArgs = extraTestArgs;
    }

    public String getJavaCommand() {
        return this.getJvm() != null ? this.getJvm() : JAVA_COMMAND;
    }

    public boolean isTestSkip() {
        return this.testSkip;
    }

    public void setTestSkip(boolean skip) {
        this.testSkip = skip;
    }

    public boolean isCompileSkip() {
        return this.compileSkip;
    }

    public String getWhitelist() {
        return this.whitelist;
    }

    public String getBlacklist() {
        return this.blacklist;
    }

    public boolean isShowTreeLogger() {
        return this.showTreeLogger;
    }

    public void setShowTreeLogger(boolean showTreeLogger) {
        this.showTreeLogger = showTreeLogger;
    }

    public int getLocalWorkers() {
        return this.localWorkers;
    }

    public void setLocalWorkers(int localWorkers) {
        this.localWorkers = localWorkers;
    }

    public File getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(File workDir) {
        this.workDir = workDir;
    }

    public File getExtraDir() {
        return this.extraDir;
    }

    public void setExtraDir(File extraDir) {
        this.extraDir = extraDir;
    }
}

