/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.scripting;

import com.totsp.mavenplugin.gwt.AbstractGWTMojo;
import com.totsp.mavenplugin.gwt.DebugMojo;
import com.totsp.mavenplugin.gwt.scripting.ProcessWatcher;
import com.totsp.mavenplugin.gwt.scripting.ScriptWriter16;
import com.totsp.mavenplugin.gwt.util.BuildClasspathUtil;
import com.totsp.mavenplugin.gwt.util.DependencyScope;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.StringUtils;

public class ScriptWriterUnix16
implements ScriptWriter16 {
    public File writeRunScript(AbstractGWTMojo mojo) throws MojoExecutionException {
        String extra;
        String filename = mojo instanceof DebugMojo ? "debug.sh" : "run.sh";
        File file = new File(mojo.getBuildDir(), filename);
        PrintWriter writer = this.getPrintWriterWithClasspath(mojo, file, DependencyScope.RUNTIME);
        String string = extra = mojo.getExtraJvmArgs() != null ? mojo.getExtraJvmArgs() : "";
        if (AbstractGWTMojo.OS_NAME.startsWith("mac") && extra.indexOf("-XstartOnFirstThread") == -1) {
            extra = "-XstartOnFirstThread " + extra;
        }
        writer.print("\"" + mojo.getJavaCommand() + "\" " + extra + " -cp \"$CP\" ");
        if (mojo instanceof DebugMojo) {
            writer.print(" -Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,address=");
            writer.print(mojo.getDebugPort());
            writer.print(mojo.isDebugSuspend() ? ",suspend=y " : ",suspend=n ");
        }
        writer.print("-Dcatalina.base=\"" + mojo.getTomcat().getAbsolutePath() + "\" ");
        writer.print(" com.google.gwt.dev.HostedMode");
        writer.print(" -gen ");
        writer.print(mojo.getGen().getAbsolutePath());
        writer.print(" -logLevel ");
        writer.print(mojo.getLogLevel());
        writer.print(" -style ");
        writer.print(mojo.getStyle());
        if (mojo.isEnableAssertions()) {
            writer.print(" -ea ");
        }
        if (mojo.isShowTreeLogger()) {
            writer.print(" -treeLogger ");
        }
        writer.print(" -workDir ");
        writer.print(mojo.getWorkDir().getAbsolutePath());
        writer.print(" -extra ");
        writer.print(mojo.getExtraDir());
        writer.print(" -war ");
        writer.print("\"" + mojo.getOutput().getAbsolutePath() + "\" ");
        writer.print("-localWorkers ");
        writer.print(mojo.getLocalWorkers());
        writer.print(" -port ");
        writer.print(Integer.toString(mojo.getPort()));
        if (mojo.isNoServer()) {
            writer.print(" -server ");
        }
        if (mojo.getWhitelist() != null && mojo.getWhitelist().length() > 0) {
            writer.print(" -whitelist \"");
            writer.print(mojo.getWhitelist());
            writer.print("\" ");
        }
        if (mojo.getBlacklist() != null && mojo.getBlacklist().length() > 0) {
            writer.print(" -blacklist \"");
            writer.print(mojo.getBlacklist());
            writer.print("\" ");
        }
        writer.print(" -startupUrl " + mojo.getRunTarget());
        writer.print(" ");
        writer.print(mojo.getCompileTarget()[0]);
        writer.println();
        writer.flush();
        writer.close();
        this.chmodUnixFile(file);
        return file;
    }

    public File writeCompileScript(AbstractGWTMojo mojo) throws MojoExecutionException {
        return this.writeCompilerInvocationScript(mojo, false);
    }

    protected File writeCompilerInvocationScript(AbstractGWTMojo mojo, boolean validateOnly) throws MojoExecutionException {
        String extra;
        File file = new File(mojo.getBuildDir(), validateOnly ? "validate.sh" : "compile.sh");
        PrintWriter writer = this.getPrintWriterWithClasspath(mojo, file, DependencyScope.COMPILE);
        String string = extra = mojo.getExtraJvmArgs() != null ? mojo.getExtraJvmArgs() : "";
        if (AbstractGWTMojo.OS_NAME.startsWith("mac") && extra.indexOf("-XstartOnFirstThread") == -1) {
            extra = "-XstartOnFirstThread " + extra;
        }
        writer.print("\"" + mojo.getJavaCommand() + "\" " + extra + " -cp \"$CP\" ");
        writer.print(" com.google.gwt.dev.Compiler ");
        writer.print(" -gen ");
        writer.print(mojo.getGen().getAbsolutePath());
        writer.print(" -logLevel ");
        writer.print(mojo.getLogLevel());
        writer.print(" -style ");
        writer.print(mojo.getStyle());
        if (mojo.isEnableAssertions()) {
            writer.print(" -ea ");
        }
        if (mojo.isShowTreeLogger()) {
            writer.print(" -treeLogger ");
        }
        writer.print(" -workDir ");
        writer.print(mojo.getWorkDir().getAbsolutePath());
        writer.print(" -extra ");
        writer.print(mojo.getExtraDir());
        writer.print(" -war ");
        writer.print("\"" + mojo.getOutput().getAbsolutePath() + "\"");
        writer.print(" -localWorkers ");
        writer.print(mojo.getLocalWorkers());
        writer.print(" ");
        for (String target : mojo.getCompileTarget()) {
            writer.print(target);
        }
        writer.println();
        writer.flush();
        writer.close();
        this.chmodUnixFile(file);
        return file;
    }

    public File writeI18nScript(AbstractGWTMojo mojo) throws MojoExecutionException {
        String extra;
        File file = new File(mojo.getBuildDir(), "i18n.sh");
        if (!file.exists()) {
            if (mojo.getLog().isDebugEnabled()) {
                mojo.getLog().debug((CharSequence)("File '" + file.getAbsolutePath() + "' does not exsists, trying to create."));
            }
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                if (mojo.getLog().isDebugEnabled()) {
                    mojo.getLog().debug((CharSequence)("New file '" + file.getAbsolutePath() + "' created."));
                }
            }
            catch (Exception exe) {
                mojo.getLog().error((CharSequence)("Couldn't create file '" + file.getAbsolutePath() + "'. Reason: " + exe.getMessage()), (Throwable)exe);
            }
        }
        PrintWriter writer = this.getPrintWriterWithClasspath(mojo, file, DependencyScope.COMPILE);
        if (mojo.getI18nConstantsNames() != null) {
            for (String target : mojo.getI18nConstantsNames()) {
                String string = extra = mojo.getExtraJvmArgs() != null ? mojo.getExtraJvmArgs() : "";
                if (AbstractGWTMojo.OS_NAME.startsWith("mac") && extra.indexOf("-XstartOnFirstThread") == -1) {
                    extra = "-XstartOnFirstThread " + extra;
                }
                writer.print("\"" + mojo.getJavaCommand() + "\" " + extra + " -cp \"$CP\" ");
                writer.print(" com.google.gwt.i18n.tools.I18NSync");
                writer.print(" -out ");
                writer.print(mojo.getI18nOutputDir());
                writer.print(mojo.isI18nConstantsWithLookup() ? " -createConstantsWithLookup " : " ");
                writer.print(target);
                writer.println();
            }
        }
        if (mojo.getI18nMessagesNames() != null) {
            for (String target : mojo.getI18nMessagesNames()) {
                String string = extra = mojo.getExtraJvmArgs() != null ? mojo.getExtraJvmArgs() : "";
                if (AbstractGWTMojo.OS_NAME.startsWith("mac") && extra.indexOf("-XstartOnFirstThread") == -1) {
                    extra = "-XstartOnFirstThread " + extra;
                }
                writer.print("\"" + mojo.getJavaCommand() + "\" " + extra + " -cp \"$CP\" ");
                writer.print(" com.google.gwt.i18n.tools.I18NSync");
                writer.print(" -createMessages ");
                writer.print(" -out ");
                writer.print(mojo.getI18nOutputDir());
                writer.print(" ");
                writer.print(target);
                writer.println();
            }
        }
        writer.flush();
        writer.close();
        this.chmodUnixFile(file);
        return file;
    }

    public void writeTestScripts(AbstractGWTMojo mojo) throws MojoExecutionException {
        String extra;
        String string = extra = mojo.getExtraJvmArgs() != null ? mojo.getExtraJvmArgs() : "";
        if (AbstractGWTMojo.OS_NAME.startsWith("mac") && extra.indexOf("-XstartOnFirstThread") == -1) {
            extra = "-XstartOnFirstThread " + extra;
        }
        String testExtra = mojo.getExtraTestArgs() != null ? mojo.getExtraTestArgs() : "";
        File outputDir = new File(mojo.getBuildDir(), "gwtTest");
        outputDir.mkdirs();
        outputDir.mkdir();
        List testCompileRoots = mojo.getProject().getTestCompileSourceRoots();
        for (String currRoot : testCompileRoots) {
            Collection coll = FileUtils.listFiles((File)new File(currRoot), (IOFileFilter)new WildcardFileFilter(mojo.getTestFilter()), (IOFileFilter)HiddenFileFilter.VISIBLE);
            for (File currFile : coll) {
                String testName = currFile.toString();
                mojo.getLog().debug((CharSequence)("gwtTest test match found (after filter applied) - " + testName));
                if (testName.lastIndexOf(46) > testName.lastIndexOf(File.separatorChar)) {
                    testName = testName.substring(0, testName.lastIndexOf(46));
                }
                if (testName.startsWith(currRoot)) {
                    testName = testName.substring(currRoot.length());
                }
                if (testName.startsWith(File.separator)) {
                    testName = testName.substring(1);
                }
                testName = StringUtils.replace((String)testName, (char)File.separatorChar, (char)'.');
                mojo.getLog().debug((CharSequence)("testName after parsing - " + testName));
                File file = new File(mojo.getBuildDir() + File.separator + "gwtTest", "gwtTest-" + testName + ".sh");
                PrintWriter writer = this.getPrintWriterWithClasspath(mojo, file, DependencyScope.TEST);
                writer.print("\"" + mojo.getJavaCommand() + "\" ");
                if (extra.length() > 0) {
                    writer.print(" " + extra + " ");
                }
                if (testExtra.length() > 0) {
                    writer.print(" " + testExtra + " ");
                }
                writer.print(" -cp \"$CP\" ");
                writer.print("junit.textui.TestRunner ");
                writer.print(testName);
                writer.flush();
                writer.close();
                this.chmodUnixFile(file);
            }
        }
    }

    private PrintWriter getPrintWriterWithClasspath(AbstractGWTMojo mojo, File file, DependencyScope scope) throws MojoExecutionException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new FileWriter(file));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error creating script - " + file, (Exception)e);
        }
        File sh = new File("/bin/bash");
        if (!sh.exists()) {
            sh = new File("/usr/bin/bash");
        }
        if (!sh.exists()) {
            sh = new File("/bin/sh");
        }
        writer.println("#!" + sh.getAbsolutePath());
        writer.println();
        try {
            Collection<File> classpath = BuildClasspathUtil.buildClasspathList(mojo, scope);
            writer.print("CP=");
            Iterator<File> it = classpath.iterator();
            while (it.hasNext()) {
                File f = it.next();
                if (it.hasNext()) {
                    writer.print("\"" + f.getAbsolutePath() + "\":");
                    continue;
                }
                writer.print("\"" + f.getAbsolutePath() + "\"");
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Error creating script - " + file, (Exception)((Object)e));
        }
        writer.println();
        writer.println();
        return writer;
    }

    private void chmodUnixFile(File file) {
        try {
            ProcessWatcher pw = new ProcessWatcher(new String[]{"chmod", "+x", file.getAbsolutePath()});
            pw.startProcess(System.out, System.err);
            pw.waitFor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public File writeValidationScript(AbstractGWTMojo mojo) throws MojoExecutionException {
        return this.writeCompilerInvocationScript(mojo, true);
    }
}

