/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt.scripting;

import com.totsp.mavenplugin.gwt.AbstractGWTMojo;
import com.totsp.mavenplugin.gwt.scripting.ProcessWatcher;
import com.totsp.mavenplugin.gwt.scripting.TestResult;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;

public final class ScriptUtil {
    private ScriptUtil() {
    }

    public static void runScript(File exec) throws MojoExecutionException {
        ProcessWatcher pw = null;
        pw = AbstractGWTMojo.OS_NAME.startsWith("windows") ? new ProcessWatcher("\"" + exec.getAbsolutePath() + "\"") : new ProcessWatcher(exec.getAbsolutePath().replaceAll(" ", "\\ "));
        try {
            pw.startProcess(System.out, System.err);
            int retVal = pw.waitFor();
            if (retVal != 0) {
                throw new MojoExecutionException(exec.getName() + " script exited abnormally with code - " + retVal);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Exception attempting to run script - " + exec.getName(), e);
        }
    }

    public static TestResult runTestScript(File exec) throws MojoExecutionException {
        TestResult testResult = new TestResult();
        StringBuilder out = new StringBuilder();
        StringBuilder err = new StringBuilder();
        ProcessWatcher pw = null;
        pw = AbstractGWTMojo.OS_NAME.startsWith("windows") ? new ProcessWatcher("\"" + exec.getAbsolutePath() + "\"") : new ProcessWatcher(exec.getAbsolutePath().replaceAll(" ", "\\ "));
        try {
            String lastLine;
            pw.startProcess(out, err);
            pw.waitFor();
            if (err.length() > 0) {
                boolean validError = true;
                if (AbstractGWTMojo.OS_NAME.startsWith("mac")) {
                    validError = false;
                    String[] errLines = err.toString().split("\n");
                    for (int i = 0; i < errLines.length; ++i) {
                        String currentErrLine = errLines[i].trim();
                        if (currentErrLine.endsWith("[JavaCocoaComponent compatibility mode]: Enabled") || currentErrLine.endsWith("[JavaCocoaComponent compatibility mode]: Setting timeout for SWT to 0.100000") || currentErrLine.length() == 0) continue;
                        validError = true;
                        break;
                    }
                }
                if (validError) {
                    throw new MojoExecutionException("error attempting to run test - " + exec.getName() + " - " + err.toString());
                }
            }
            String[] lines = null;
            lines = AbstractGWTMojo.OS_NAME.startsWith("windows") ? out.toString().split("\r\n") : out.toString().split("\n");
            testResult.lastLine = lastLine = lines[lines.length - 1];
            if (lastLine.indexOf("Tests run") != -1) {
                testResult.code = TestResult.TestCode.FAILURE;
            } else if (lastLine.indexOf("OK") != -1) {
                testResult.code = TestResult.TestCode.SUCCESS;
            }
            testResult.message = out.toString();
        }
        catch (Exception e) {
            throw new MojoExecutionException("error attempting to run test - " + exec.getName() + " - " + e.getMessage(), e);
        }
        return testResult;
    }
}

