/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt;

import com.totsp.mavenplugin.gwt.AbstractGWTMojo;
import com.totsp.mavenplugin.gwt.GWTSetup;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProjectBuilder;
import org.codehaus.plexus.util.FileUtils;

public class GWTExtractor
extends AbstractGWTMojo {
    protected ArtifactRepository local;
    protected List remoteRepos;
    protected MavenProjectBuilder mavenProjectBuilder;
    protected ArtifactFactory factory;
    protected ArtifactResolver resolver;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Iterator iter = this.getProject().getDependencyArtifacts().iterator();
        boolean fFoundDependency = false;
        while (iter.hasNext()) {
            Artifact a = (Artifact)iter.next();
            if (!a.getGroupId().equals(this.getGroupId()) || !a.getArtifactId().equals(GWTSetup.guessArtifactId())) continue;
            try {
                fFoundDependency = true;
                File artifactFile = a.getFile();
                if (artifactFile == null) {
                    Artifact gwtDevArtifact = this.factory.createArtifact(this.getGroupId(), GWTSetup.guessArtifactId(), this.getGwtVersion(), "", "zip");
                    try {
                        this.resolver.resolve(gwtDevArtifact, this.remoteRepos, this.local);
                    }
                    catch (Exception e) {
                        String error = "Error:  Could not resolve GWT artifact.  If you set \"setup\" goal for this plugin, this may be a bug.  Check that you do not have any dependencies that conflict with " + this.getGroupId() + ":" + GWTSetup.guessArtifactId() + "\n" + "If not, please report this error to the gwt-maven project.";
                        throw new MojoExecutionException(error, e);
                    }
                    artifactFile = gwtDevArtifact.getFile();
                }
                ZipFile zipFile = new ZipFile(artifactFile);
                File extractionDir = this.getGwtBinDirectory();
                File timestampFile = new File(extractionDir, ".timestamp-" + a.getFile().lastModified());
                if (timestampFile.exists()) break;
                if (extractionDir.exists()) {
                    FileUtils.deleteDirectory((File)extractionDir);
                }
                System.out.println("Unzipping GWT " + this.getGwtVersion() + " install to : " + extractionDir.toString());
                extractionDir.mkdirs();
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    File entryFile = new File(extractionDir, entry.getName());
                    if (entry.isDirectory()) {
                        entryFile.mkdirs();
                        continue;
                    }
                    FileOutputStream fis = new FileOutputStream(entryFile);
                    GWTExtractor.copyStream(zipFile.getInputStream(entry), fis);
                    fis.flush();
                    fis.close();
                }
                timestampFile.createNewFile();
                break;
            }
            catch (IOException e) {
                String error = "Error:  Could not load GWT artifact.  If you set \"setup\" goal for this plugin, this may be a bug.  Check that you do not have any dependencies that conflict with " + this.getGroupId() + ":" + GWTSetup.guessArtifactId() + "\n" + "If not, please report this error to the gwt-maven project.";
                throw new MojoExecutionException(error, (Exception)e);
            }
        }
        if (!fFoundDependency) {
            String error = "Error:  Could not load GWT artifact.  Make sure you have the setup goal enabled for this plugin or that you have setup a dependency on " + this.getGroupId() + ":" + GWTSetup.guessArtifactId() + "\n";
            throw new MojoExecutionException(error);
        }
    }
}

