/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.mavenplugin.gwt;

import com.totsp.mavenplugin.gwt.AbstractGWTMojo;
import com.totsp.mavenplugin.gwt.GWTSetup;
import com.totsp.mavenplugin.gwt.ProcessWatcher;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;

public class GWTTest
extends AbstractGWTMojo {
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isSkip()) {
            return;
        }
        try {
            String extra;
            ArrayList<String> classPathList;
            block34: {
                classPathList = new ArrayList<String>(this.getProject().getTestClasspathElements());
                try {
                    Thread.currentThread().getContextClassLoader().loadClass("com.google.gwt.dev.GWTCompiler");
                }
                catch (ClassNotFoundException cnf) {
                    File toolkitHome;
                    File devJar;
                    String doNotFindGwtDev = this.getProject().getProperties().getProperty("google.webtoolkit.doNotFileGwtDev");
                    if (Boolean.valueOf(doNotFindGwtDev).booleanValue()) break block34;
                    String toolkitHomeStr = this.getProject().getProperties().getProperty("google.webtoolkit.home");
                    if (this.getProject().getProperties().getProperty("google.webtoolkit.home") == null) {
                        File targetDir = null;
                        try {
                            targetDir = new File(this.getGwtBinDirectory(), GWTSetup.guessArtifactId() + "-" + this.getGwtVersion()).getCanonicalFile();
                            this.getProject().getProperties().setProperty("google.webtoolkit.home", targetDir.getCanonicalPath());
                            toolkitHomeStr = GWT_PATH = targetDir.getCanonicalPath();
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException(e.getMessage());
                        }
                    }
                    if (toolkitHomeStr == null) {
                        try {
                            if (this.getGwtHome() != null) {
                                toolkitHomeStr = this.getGwtHome().getCanonicalPath();
                            }
                        }
                        catch (IOException e) {
                            throw new MojoFailureException("Error:  google.webtoolkit.home is not set.  Please set this property an active profile in your POM or user settings.");
                        }
                        if (toolkitHomeStr == null) {
                            throw new MojoFailureException("Error:  google.webtoolkit.home is not set.  Please set this property an active profile in your POM or user settings.");
                        }
                    }
                    if (!(devJar = new File(toolkitHome = new File(toolkitHomeStr), GWTSetup.guessDevJarName())).exists()) {
                        String[] devJars = toolkitHome.list((FilenameFilter)new WildcardFileFilter("gwt-dev-*.jar"));
                        if (devJars.length == 1) {
                            devJar = new File(toolkitHome, devJars[0]);
                        } else {
                            if (devJars.length == 1) {
                                String Error = "Could not find a gwt-dev jar.  Looked in " + toolkitHome + ".  If you think you " + "already gwt-dev-*.jar in your path, you can set the property google.webtoolkit.doNotFileGwtDev to " + "\"true\" in your POM.";
                                throw new MojoFailureException(Error);
                            }
                            String Error = "Could not find a gwt-dev jar.  \nLooked in " + toolkitHome + ", but found more than one jar that fullfilled gwt-dev-*.jar" + "If you think you already gwt-dev-*.jar in your path, you can set " + "the property google.webtoolkit.doNotFileGwtDev to \"true\" in your POM.";
                            throw new MojoFailureException(Error);
                        }
                    }
                    try {
                        classPathList.add(devJar.getCanonicalPath());
                    }
                    catch (IOException e) {
                        classPathList.add(devJar.getAbsolutePath());
                    }
                }
            }
            classPathList.add(this.getProject().getBuild().getSourceDirectory());
            classPathList.add(this.getProject().getBuild().getTestSourceDirectory());
            String exe = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            String classpath = StringUtils.join(classPathList.iterator(), (String)File.pathSeparator);
            ArrayList arguments = new ArrayList();
            StringBuffer cmd = new StringBuffer();
            cmd.append(exe).append(' ');
            String string = extra = this.getExtraJvmArgs() != null ? this.getExtraJvmArgs() : "";
            if (System.getProperty("os.name").toLowerCase(Locale.US).startsWith("mac") && extra.indexOf("-XstartOnFirstThread") == -1) {
                extra = "-XstartOnFirstThread " + extra;
            }
            cmd.append(extra).append(" ");
            cmd.append("-cp ");
            cmd.append(classpath).append(' ');
            cmd.append("junit.textui.TestRunner ");
            File outputDir = new File(this.getBuildDir(), "gwtTest");
            outputDir.mkdirs();
            outputDir.mkdir();
            List testCompileRoots = this.getProject().getTestCompileSourceRoots();
            int run = 0;
            int fail = 0;
            int error = 0;
            for (String currRoot : testCompileRoots) {
                Collection coll = FileUtils.listFiles((File)new File(currRoot), (IOFileFilter)new WildcardFileFilter(this.getTestFilter()), (IOFileFilter)HiddenFileFilter.VISIBLE);
                for (File currFile : coll) {
                    ArrayList<String> specificArgs = new ArrayList<String>(arguments);
                    String packageName = currFile.toString();
                    if (packageName.lastIndexOf(46) > packageName.lastIndexOf(File.separatorChar)) {
                        packageName = packageName.substring(0, packageName.lastIndexOf(46));
                    }
                    if (packageName.startsWith(currRoot)) {
                        packageName = packageName.substring(currRoot.length());
                    }
                    if (packageName.startsWith(File.separator)) {
                        packageName = packageName.substring(1);
                    }
                    packageName = StringUtils.replace((String)packageName, (char)File.separatorChar, (char)'.');
                    specificArgs.add(packageName);
                    try {
                        String curr;
                        String[] lines;
                        String fullCmd = cmd.toString() + packageName;
                        System.out.println(fullCmd);
                        ProcessWatcher pw = new ProcessWatcher(fullCmd, null, this.getBuildDir());
                        StringBuffer out = new StringBuffer();
                        StringBuffer err = new StringBuffer();
                        pw.startProcess(out, err);
                        pw.waitFor();
                        if (err.length() > 0) {
                            System.err.println(err);
                        }
                        FileWriter writer = new FileWriter(new File(outputDir, "TEST-" + packageName + ".txt"));
                        writer.write(err.toString());
                        writer.write("\n" + out.toString());
                        writer.flush();
                        writer.close();
                        Pattern p = Pattern.compile("\\s*Tests run:\\s*(\\d+)\\s*,\\s*Failures:\\s*(\\d+),\\s*Errors:\\s*(\\d+)\\s*");
                        Pattern p2 = Pattern.compile("OK\\s\\((\\d+) tests\\)\\s*");
                        Matcher m = null;
                        Matcher m2 = null;
                        String[] arr$ = lines = out.toString().split("\n");
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && !(m = p.matcher(curr = arr$[i$])).matches() && !(m2 = p2.matcher(curr)).matches(); ++i$) {
                        }
                        if (m.matches()) {
                            run += Integer.parseInt(m.group(1));
                            fail += Integer.parseInt(m.group(2));
                            error += Integer.parseInt(m.group(3));
                            System.out.println("Testing " + packageName);
                            System.out.println(m.group(0));
                            continue;
                        }
                        if (err.length() == 0) {
                            if (m2.matches()) {
                                run += Integer.parseInt(m2.group(1));
                                continue;
                            }
                            System.out.println(out.toString());
                            continue;
                        }
                        ++error;
                        System.out.println("Unit tests failed.");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (error + fail > 0) {
                throw new MojoExecutionException("GWT Unit Tests failed.\nTests run: " + run + ", Failures: " + fail + ", Errors: " + error + ", Skipped: 0");
            }
            System.out.println("OK (" + run + " tests)");
        }
        catch (DependencyResolutionRequiredException e) {
            e.printStackTrace();
        }
    }

    public boolean isSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    static class StreamSucker
    extends Thread {
        InputStream steam;
        OutputStream os;
        int byteswritten = 0;
        volatile boolean timeToClose = false;

        public StreamSucker(InputStream steam, OutputStream os) {
            this.steam = steam;
            this.os = os;
        }

        public void siphonAvailableBytes(byte[] buf) throws IOException {
            boolean close = this.timeToClose;
            int available = this.steam.available();
            while (available > 0) {
                available = this.steam.read(buf);
                this.os.write(buf, 0, available);
                this.byteswritten += available;
                available = this.steam.available();
            }
            if (close) {
                throw new IOException("Done");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buf = new byte[4096];
            try {
                while (true) {
                    StreamSucker streamSucker = this;
                    synchronized (streamSucker) {
                        this.wait(80L);
                    }
                    this.siphonAvailableBytes(buf);
                }
            }
            catch (InterruptedException e) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

