/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.metadata.iptc;

import com.twelvemonkeys.imageio.metadata.Directory;
import com.twelvemonkeys.imageio.metadata.MetadataReader;
import com.twelvemonkeys.imageio.metadata.iptc.IPTCDirectory;
import com.twelvemonkeys.imageio.metadata.iptc.IPTCEntry;
import com.twelvemonkeys.lang.StringUtil;
import com.twelvemonkeys.lang.Validate;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import javax.imageio.IIOException;
import javax.imageio.stream.ImageInputStream;

public final class IPTCReader
extends MetadataReader {
    private static final int ENCODING_UNKNOWN = -1;
    private static final int ENCODING_UNSPECIFIED = 0;
    private static final int ENCODING_UTF_8 = 1779015;
    private int encoding = 0;

    public Directory read(ImageInputStream imageInputStream) throws IOException {
        Validate.notNull((Object)imageInputStream, (String)"input");
        ArrayList<IPTCEntry> arrayList = new ArrayList<IPTCEntry>();
        while (imageInputStream.read() == 28) {
            int n;
            short s = imageInputStream.readShort();
            IPTCEntry iPTCEntry = this.readEntry(imageInputStream, s, n = imageInputStream.readUnsignedShort());
            if (iPTCEntry == null) continue;
            arrayList.add(iPTCEntry);
        }
        return new IPTCDirectory(arrayList);
    }

    private IPTCEntry readEntry(ImageInputStream imageInputStream, short s, int n) throws IOException {
        Object object = null;
        switch (s) {
            case 346: {
                this.encoding = this.parseEncoding(imageInputStream, n);
                return null;
            }
            case 512: {
                object = imageInputStream.readUnsignedShort();
                break;
            }
            default: {
                if ((s & 0xFF00) == 512) break;
                imageInputStream.skipBytes(n);
                return null;
            }
        }
        if (object == null) {
            object = n < 1 ? null : this.parseString(imageInputStream, n);
        }
        return new IPTCEntry(s, object);
    }

    private int parseEncoding(ImageInputStream imageInputStream, int n) throws IOException {
        return n == 3 && (imageInputStream.readUnsignedByte() << 16 | imageInputStream.readUnsignedByte() << 8 | imageInputStream.readUnsignedByte()) == 1779015 ? 1779015 : -1;
    }

    private String parseString(ImageInputStream imageInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        imageInputStream.readFully(byArray);
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder charsetDecoder = charset.newDecoder();
        try {
            CharBuffer charBuffer = charsetDecoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(byArray));
            return charBuffer.toString();
        }
        catch (CharacterCodingException characterCodingException) {
            if (this.encoding == 1779015) {
                throw new IIOException("Wrong encoding of IPTC data, explicitly set to UTF-8 in DataSet 1:90", characterCodingException);
            }
            return StringUtil.decode((byte[])byArray, (int)0, (int)byArray.length, (String)"ISO8859_1");
        }
    }
}

